/**
 * Jowrney Editor for XE
 * Jowrney Kim, jowrney@jowrney.com
 * http://www.jowrney.com
 * 2011.02.01
 */
 
var jowrneyEditor = new modsEditor(); 

function editorStart_xe(editor_sequence, content_key, primary_key, request_uri, lang_type, color_set, func_externals) {

	var $textarea, $form, $input, saved_str, xeed, opt = {};
	$textarea = $('#jowrney-'+editor_sequence);
	//$textarea.hide();
	$form     = $($textarea[0].form).attr('editor_sequence', editor_sequence);
	$input    = $form.find('input[name='+content_key+']');

	if($input[0]) $textarea.val($input.remove().val()).attr('name', content_key);
	$textarea.attr('name', content_key);

	// Set standard API...
	editorRelKeys[editor_sequence] = {
		primary   : $form[0][primary_key],
		content   : $form[0][content_key],
		func      : function(){ return jowrneyEditor.getContent(); },
		pasteHTML : function(text){ jowrneyEditor.setContent(text); }
	};

	var externalArr;
	if(!func_externals) externalArr = null
	else externalArr = func_externals;

	jowrneyEditor.setConfig({
		containerCss: "modsEditor",
		rootElementID: "jowrney-editor-"+editor_sequence,
		iframeID:"editor_iframe_"+editor_sequence, //for XE...
		lang: lang_type,
		colorset: color_set,
		frameSrc: request_uri+"modules/editor/skins/jowrneyEditor/_js/modsEditor.html",
		editorFontFamily: "Malgun Gothic",
		fonts:["Malgun Gothic","Gulim","Dotum","궁서","Meiryo"],
		icoFolder:request_uri+"modules/editor/skins/jowrneyEditor/_img/modsEditor/icon/",
		tabFileUsed:false,
		tabExternalUsed:true,
		tabExternals:externalArr,
		onTabExternals: function(component){
			//확장패널이 클릭되었을때. 이벤트 처리
		},
		ondblClick: function(event){
			var node = event.target; //더블클릭된 엘리면트 임.. 
			//alert(node.tagName+","+node.id+","+node.innerHTML+","+$(node).attr("editor_component")); //by Squall...
			//임시로 수정을 위한 공용함수 접근... by Jowrney...
			var comp = $(node).attr("editor_component");
			editorPrevNode = node;
			openComponent(comp, editor_sequence);
		},
		onReady: function(){
			$("#jowrney-editor-container-"+editor_sequence).html($input.val());
			jowrneyEditor.setContent($("#jowrney-editor-container-"+editor_sequence));
		}
	});

}

function editorGetContentTextarea(editor_sequence) {
	return jowrneyEditor.getContent();
}

