/*
 * modsAX Javascript Library
 * modsAX.com 2009 squall
 * modsAX are licensed under a Creative Commons Attribution 3.0 license.
 * http://creativecommons.org/licenses/by/3.0/deed.ko
 * If you don't want to author Link
 * You must register. Join the modsAX license member then you free use modsAX
 * http://www.modsAX.com
 */

var modsfx = Class.create({
  version: "1.0",
  initialize: function(options){
    this.plugin     = "http://www.macromedia.com/go/getflashplayer"
    this.classid    = "clsid:d27cdb6e-ae6d-11cf-96b8-444553540000";
    this.embedType  = "application/x-shockwave-flash";
    this.OPT        = options;
    this.Params     = "";
    if(!this.OPT.src)                 alert("'src' option is required");
    if(!this.OPT.width)               this.OPT.width = 100;
    if(!this.OPT.height)              this.OPT.height = 100;
    if(!this.OPT.name)                this.OPT.name = "noname";
    if(!this.OPT.id)                  this.OPT.id = this.OPT.name;
    if(!this.OPT.allowScriptAccess)   this.OPT.allowScriptAccess = "sameDomain";
    if(!this.OPT.menu)                this.OPT.menu = "true";
    if(!this.OPT.quality)             this.OPT.quality = "best";
    if(!this.OPT.wmode)               this.OPT.wmode = "transparent";
    if(!this.OPT.bgcolor)             this.OPT.bgcolor = "#ffffff";
    if(!this.OPT.align)               this.OPT.align = "middle";
    if(!this.OPT.version)             this.OPT.version = "8,0,0,0";
    if(!this.OPT.allowFullScreen)     this.OPT.allowFullScreen = "false";
    if(!this.OPT.fontList)            this.OPT.fontList = "";
    if(!this.OPT.fontDefault)         this.OPT.fontDefault = "";
    if(!this.OPT.key)                 this.OPT.key = "";
    this.codebase = "http://fpdownload.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version="+this.OPT.version;
    this.fxName = this.OPT.fxName;
  },
  play: function(playTG){
    if(!playTG) playTG = this.fxName;
    var myParam = this.getParam();
    var p_out = [];
    p_out.push("<object classid=\""+this.classid+"\" codebase=\""+this.codebase+"\" ");
    p_out.push(" width=\""+this.OPT.width+"\" height=\""+this.OPT.height+"\" id=\""+this.OPT.id+"\" align=\""+this.OPT.align+"\">");
    p_out.push("<param name=\"allowScriptAccess\" value=\""+this.OPT.allowScriptAccess+"\" />");
    p_out.push("<param name=\"movie\" value=\""+this.OPT.src+"\" />");
    p_out.push("<param name=\"menu\" value=\""+this.OPT.menu+"\" /><param name=\"quality\" value=\""+this.OPT.quality+"\" />");
    p_out.push("<param name=\"wmode\" value=\""+this.OPT.wmode+"\" /><param name=\"bgcolor\" value=\""+this.OPT.bgcolor+"\" />");
    p_out.push("<param name=\"allowFullScreen\" value=\""+this.OPT.allowFullScreen+"\" />");
    if(myParam.length > 0)
    p_out.push("<param name='flashvars' value='"+myParam.join("&")+"' />");
    p_out.push("<embed src=\""+this.OPT.src+"\" ");
    p_out.push(" menu=\""+this.OPT.menu+"\" quality=\""+this.OPT.quality+"\" wmode=\""+this.OPT.wmode+"\" bgcolor=\""+this.OPT.bgcolor+"\" width=\""+this.OPT.width+"\" height=\""+this.OPT.height+"\" align=\""+this.OPT.align+"\" ");
    if(myParam.length > 0)
    p_out.push(" flashvars='"+myParam.join("&")+"' ");
    p_out.push(" name=\""+this.OPT.name+"\" allowScriptAccess=\""+this.OPT.allowScriptAccess+"\" allowFullScreen=\""+this.OPT.allowFullScreen+"\" type=\""+this.embedType+"\" pluginspage=\""+this.plugin+"\" />");
    p_out.push("</object>");
    $M(playTG).innerHTML = p_out.join('');
    this.getMovie = (navigator.appName.indexOf("Microsoft") != -1) ? window[this.OPT.name] : document[this.OPT.name];;
  },
  setParam: function(pr){
    if(typeof(pr) == "object") this.Params = pr;
    else alert("Param set up incorrectly");
  },
  getParam: function(){
  	var qs = [];
    if(this.Params){
  	  var pr = this.Params;
      for(var key in pr) qs.push(key+"="+pr[key]);
  	}
    if(this.OPT.fontList != "") qs.push("fontList="+this.OPT.fontList);
    if(this.OPT.fontDefault != "") qs.push("fontDefault="+this.OPT.fontDefault);
    if(this.OPT.key != "") qs.push("key="+this.OPT.key);
  	return qs;
  },
  app: function(fname, args){
  	if(args)
  	this.getMovie[fname](args);
  	else
  	this.getMovie[fname]();
  }
}); // modsfx

var modsfxQClass = Class.create({
  version: "1.0",
  initialize: function(){
    this.fxQueue      = [];
    this.playQueue    = [];
    this.connectQueue = [];
    this.config       = {showError:false};
    this.delayTime    = {play:200, rePlay:500, requestFn:300, reRequestFn:500};
    this.requestQueueLive = false; // requestFn 
    this.reqErrCnt = 0;
  },
  add: function(fxName, fxOptions){
    // Object test
    var hasObj = this.fxQueue.or(function(n){
      return n.objName == fxName;
    });
    if(hasObj == false){
      var myOPT = fxOptions;
      if(!myOPT.src)                 alert("'src' option is required");
      if(!myOPT.width)               myOPT.width = "100%";
      if(!myOPT.height)              myOPT.height = "100%";
      if(!myOPT.allowScriptAccess)   myOPT.allowScriptAccess = "always";
      if(!myOPT.menu)                myOPT.menu = "false";
      if(!myOPT.quality)             myOPT.quality = "best";
      if(!myOPT.wmode)               myOPT.wmode = "opaque";
      if(!myOPT.bgcolor)             myOPT.bgcolor = "#ffffff";
      if(!myOPT.align)               myOPT.align = "middle";
      if(!myOPT.version)             myOPT.version = "9,0,0,0";
      if(!myOPT.allowFullScreen)     myOPT.allowFullScreen = "false";
      if(!myOPT.fontList)            myOPT.fontList = "";
      if(!myOPT.fontDefault)         myOPT.fontDefault = "";
      if(!myOPT.key)                 myOPT.key = "";
      
      var myName = fxName + "_modsfxQ";
      var addObj = new modsfx({
        fxName: fxName, 
        src:myOPT.src+"?dummy="+mods.dummy, width:myOPT.width, height:myOPT.height, name:myName, menu:myOPT.menu, 
        allowScriptAccess:myOPT.allowScriptAccess, 
        quality:myOPT.quality, wmode:myOPT.wmode, bgcolor:myOPT.bgcolor, align:myOPT.align, version:myOPT.version, 
        allowFullScreen:myOPT.allowFullScreen,
        fontList:myOPT.fontList,
        fontDefault:myOPT.fontDefault,
        key:myOPT.key
      });
      this.fxQueue.push({objName:fxName, fxObject:addObj});
      this.playQueue.push(fxName);
    }
  },
  setParam: function(fxName, params){
    var catchIndex  = this.getIndex(fxName);
    if(catchIndex > -1) this.fxQueue[catchIndex].fxObject.setParam(params);
    else alert("Was calling the wrong name !");
  },
  getIndex: function(fxName){
    var catchs = this.fxQueue.getObj(function(n){
      return n.objName == fxName;
    });
    return catchs.index;
  },
  play: function(fxName){
    var myTime = this.delayTime;
    var rePlay = this.playQueueFn.bind(this);
    setTimeout(rePlay, myTime.play);
  },
  clear: function(){
    this.fxQueue.clear();
    this.playQueue.clear();
  },
  playQueueFn: function(){
    var myTime = this.delayTime;
    // queue control
    var rePlay = this.playQueueFn.bind(this);
    var errs = [];
    var failQueue = [];
    for(var a=this.playQueue.length-1;a>-1;a--){
      try{
        var catchName     = this.playQueue[a];
        var catchIndex    = this.getIndex(catchName);
        if(catchIndex > -1) this.fxQueue[catchIndex].fxObject.play();
      }catch(e){
        failQueue.push(this.playQueue[a]);  
        errs.push(catchName + ":play fail \n" + e.print().toString() + "\n");
      }
    }
    this.playQueue = failQueue; //exec    
    if(errs.length > 0){
      if(this.config.showError) alert(errs.join(''));
      else setTimeout(rePlay, myTime.rePlay);
    }
  },
  requestFn: function(){
    var myTime = this.delayTime;
    this.connectQueue.push(arguments);
    var rePlay = this.requestQueueFn.bind(this);
    if(!this.requestQueueLive){
      setTimeout(rePlay, myTime.requestFn); 
      this.requestQueueLive = true;
    } // queue live then call
  },
  requestQueueFn: function(){
    var myTime = this.delayTime;
    this.requestQueueLive = true;
    // queue control
    var rePlay = this.requestQueueFn.bind(this);
    var errs = [];
    var failQueue = [];
    for(var a=this.connectQueue.length-1;a>-1;a--){
      try{
        if(this.connectQueue[a][0]){
          var catchName     = this.connectQueue[a][0];
          var catchFn       = this.connectQueue[a][1];
          var catchIndex    = this.getIndex(catchName);
          if(catchIndex > -1){
			      this.fxQueue[catchIndex].fxObject.app(catchFn, this.connectQueue[a][2]);
          }
        }
      }catch(e){
        failQueue.push(this.connectQueue[a]);  
        errs.push(catchName + ":call fail \n" + e.print().toString() + "\n");
      }
    }
    this.connectQueue = failQueue; //exec re
    if(errs.length > 0){
      if(this.config.showError){
        if(this.reqErrCnt < 3){
          alert(errs.join(''));
          this.reqErrCnt++;
          setTimeout(rePlay, 1000);
        }else{
          alert("Stop process");
        }
      }else{
        setTimeout(rePlay, myTime.reRequestFn);
      }
    }else{
      this.requestQueueLive = false;
    }
  },
  returnFn: function(fxName, fxOptions){}
}); // ARIAfxQ
var modsFlash   = new modsfxQClass();

// ARIAchart added ---------------------------------------------------------------------------------------------------------------------------
var ARIAchartClass = Class.create(modsfxQClass, {
  version: "1.0",
  initialize: function($super){
    $super();
  },
  setData: function(fxName, args, matrix){
    if(args == null){
      alert("fail to data convert");
    }else{
      var dataMatrix = true;
      if(matrix != undefined) dataMatrix = matrix;
      
      if(args.tagName){
        if(args.tagName.toLowerCase() == "table"){
          var returnData = this.convertTable(args); //convert table
          if(dataMatrix == true || dataMatrix == "true")
          this.requestFn(fxName,"setData",{dataProvider:returnData.datas, dataField:"value", categoryField:"name", series:returnData.series});
          else
          this.requestFn(fxName,"setData",this.reverseData({dataProvider:returnData.datas,dataField:"value",categoryField:"name",series:returnData.series}));
        }else{
          alert(args.tagName+" is wrong element name");
        }
      }else{
        if(dataMatrix == true || dataMatrix == "true"){
          this.requestFn(fxName, "setData",  args);
        }else{
          var newArgs = this.reverseData(args);
          this.requestFn(fxName, "setData",  newArgs);
        }
      }
    }
  },
  reverseData: function(args){
    var myData = [];
    var myseries = [];

    args.dataProvider[0].each(function(n, index){
      myData.push([]);      
    });

    args.dataProvider.each(function(n, index){
      n.each(function(m, mindex){
        myData[mindex].push({name:args.series[index].displayName, value:m.value});
        if(index == 0)
        myseries.push({idx:mindex, xField:"name", yField:"value", displayName:m.name});
      });
    });
    
    return {dataProvider:myData, dataField:args.dataField, categoryField:args.categoryField, series:myseries};
  },
  setChart: function(fxName, args){
    this.requestFn(fxName, "setChart",  args);
  },
  setLegend: function(fxName, args){
    this.requestFn(fxName, "setLegend",  args);
  },
  setGrid: function(fxName, args){
    this.requestFn(fxName, "setGrid",  args);
  },
  setDatatip: function(fxName, args){
    this.requestFn(fxName, "setDatatip",  args);
  },
  setCoordinate: function(fxName, args){
    this.requestFn(fxName, "setCoordinate",  args);
  },
  setTween: function(fxName, args){
    this.requestFn(fxName, "setTween",  args);
  },
  setBackground: function(fxName, args){
    this.requestFn(fxName, "setBackground",  args);
  },
  setVerticalAxis: function(fxName, args){
    this.requestFn(fxName, "setVerticalAxis",  args);
  },
  setHorizontalAxis: function(fxName, args){
    this.requestFn(fxName, "setHorizontalAxis",  args);
  },
  convertTable: function(myTable){
    var rowHead = [];
    var colHead = [];
    var myData = [];
    var series = [];
    for(var i = 0;i < myTable.rows.length;i++){
      var myDataRows = [];
      for(var k = 0;k < myTable.rows[i].cells.length;k++){
        var cell = myTable.rows[i].cells[k];
        if(i == 0) rowHead.push(cell.innerHTML);
        if(k == 0) colHead.push(cell.innerHTML);
        if(i > 0 && k > 0){
          var myValue = parseFloat(cell.innerHTML.delHtml().trim().replace(/,/, ""));
          if(isNaN(myValue)) myValue = 0;
          myDataRows.push({name:rowHead[k], value:myValue});
        }
      }
      if(i > 0) myData.push(myDataRows);
    }
    for(var a=0;a<colHead.length;a++){
      if(a > 0) series.push({idx:(a-1), xField:"name", yField:"value", displayName:colHead[a]});
    }
    return {series:series, datas:myData};
  }
}); //ARIAchartClass

var ARIAchart = new ARIAchartClass();