/*
 * modsAX Javascript Library
 * modsAX.com 2009-2010 squall
 * modsAX are licensed under http://www.modsax.com/license/
 */

/*
try{
	// inserting via DOM fails in Safari 2.0, so brute force approach
	document.write('<script type="text/javascript" src="'+libraryName+'"><\/script>');
} catch(e) {
	// for xhtml+xml served content, fall back to DOM methods
	var script = document.createElement('script');
	script.type = 'text/javascript';
	script.src = libraryName;
	document.getElementsByTagName('head')[0].appendChild(script);
}
*/

var modsEditor = Class.create(modsAX, {
	version       : "modsEditor V1.0",
	author        : "SQUALL",
	createDate    : "2010.11.23",
	lastModifyDate: "2010.02.08",
	initialize: function($super){
		$super();
		this.moveSens = 0;
		this.contentMode = "editor";
		this.panelNum = 0;
		this.attchFiles = [];
		this.readyFiles = [];
		with(this){
			config.containerCss = "modsEditor";
			config.headCss = "editorHead";
			config.bodyCss = "editorBody";
			config.footCss = "editorFoot";
			config.height = 300;
			config.lang = "en";
			config.moveSens = 5;
			config.ie67adj = -2;
			config.selectMenuIndex = 0;
			config.tabFileUsed = false;
			config.tabTableUsed = false;
			config.tabLayoutUsed = false;
			config.tabOptionUsed = false;
			config.tabExternalUsed = false;
			config.frameSrc = "/_js/modsEditor.html";
			config.editorFontSize = "12px";
			config.editorFontFamily = "Malgun Gothic";
			config.colors = ["ffffff","faedd4","fff3b4","ffffbe","ffeaea","ffeaf8","e6ecfe","d6f3f9","e0f0e9","eaf4cf","e8e8e8","e7c991","f3d756","ffe409","f9b4cb","dfb7ee","b1c4fc","96ddf3","b1dab7","b8d63d","c2c2c2","d18e0a","ec9c2c","ff8b16","f3709b","af65dd","7293fa","49b5d5","6abb9a","5fb636","8e8e8e","9d6c08","c84205","e31600","c8056a","801fbf","3058d2","0686a8","318561","2b8400","474747","654505","8c3c04","840000","8c044b","57048c","193da9","004c5f","105738","174600","000000","463003","612a03","5b0000","610334","320251"];
			config.fonts = ["Malgun Gothic","Gulim","Dotum","궁서"];
			config.fontsizes = [8,9,10,11,12,14,16,18,20];
			config.lineHeights = [1.0, 1.2, 1.5, 1.8, 2.0, 2.5];
			config.swfUploader = "/_js/ModsMultiUploader.swf";
			config.uploadUrl = "/_as/uploadFile.asp";
			config.uploadPars = ["p1=1","p2=2"];
			config.deleteUrl = "/_as/deleteFile.asp",
			config.deletePars = [],
			config.uploadVolume = (5 * 1024 * 1024);
			config.uploadFilterName = "전체,이미지";
    		config.uploadFilterValue = "*.*,*.jpg; *.gif; *.png";
    		config.uploadCallBack = "mmuCall";
    		config.tabExternals = [];
		}
	},
	init: function(){
		this._self    = jQuery("#"+this.config.rootElementID);
	    var config = this.config;
	    // po
	    var po = [];
	    po.push("<div id=\""+config.rootElementID+"_container\" class=\""+config.containerCss+"\">");
	    po.push("	<div id=\""+config.rootElementID+"_head\"   class=\""+config.headCss+"\"></div>");
	    po.push("	<div id=\""+config.rootElementID+"_body\"   class=\""+config.bodyCss+"\"></div>");
	    po.push("	<div id=\""+config.rootElementID+"_foot\"   class=\""+config.footCss+"\"></div>");
	    po.push("</div>");
	    this._self.append(po.join(''));

	    // define element
	    this.container= jQuery("#"+config.rootElementID+"_container");
	    this.head     = jQuery("#"+config.rootElementID+"_head");
	    this.body     = jQuery("#"+config.rootElementID+"_body");
	    this.foot     = jQuery("#"+config.rootElementID+"_foot");

	    //init head
    	this.initHead();

    	//init foot
    	this.initFoot();

    	//init body
    	this.initBody();
	},
	initHead: function(){
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var po = [];
		//메뉴탭과 패널
		po.push("<div id=\""+re+"_headTab\" class='me___tabContainer'></div>");
		po.push("<div id=\""+re+"_headPanel\" class='me___headPanel'></div>");
		this.head.append(po.join(''));
		//메뉴 내용 구성
		po.clear();
		po.push("<div class='me___item me___itemOn'>");
		po.push("	<a href='#modsaxExecption' class='me____btn' id='"+this._GID([re, "home", "btn"])+"'>"+lg["home"]+"</a>");
		po.push("	<a href='#modsaxExecption' class='me____tab' id='"+this._GID([re, "home", "open"])+"'>open</a>");
		po.push("</div>");
		
		if(config.tabFileUsed){
		po.push("<div class='me___item'>");
		po.push("	<a href='#modsaxExecption' class='me____btn' id='"+this._GID([re, "attch", "btn"])+"'>"+lg["attch"]+"</a>");
		po.push("	<a href='#modsaxExecption' class='me____tab' id='"+this._GID([re, "attch", "open"])+"'>open</a>");
		po.push("	<div class='me____attchSwf' id='"+this._GID([re, "attch", "swf"])+"'></div>"); //head attchswf
		po.push("</div>");
		}

		if(config.tabTableUsed){
		po.push("<div class='me___item'>");
		po.push("	<a href='#modsaxExecption' class='me____btn' id='"+this._GID([re, "table", "btn"])+"'>"+lg["table"]+"</a>");
		po.push("	<a href='#modsaxExecption' class='me____tab' id='"+this._GID([re, "table", "open"])+"'>open</a>");
		po.push("</div>");
		}
		if(config.tabLayoutUsed){
		po.push("<div class='me___item'>");
		po.push("	<a href='#modsaxExecption' class='me____btn' id='"+this._GID([re, "layout", "btn"])+"'>"+lg["layout"]+"</a>");
		po.push("	<a href='#modsaxExecption' class='me____tab' id='"+this._GID([re, "layout", "open"])+"'>open</a>");
		po.push("</div>");
		}
		if(config.tabOptionUsed){
		po.push("<div class='me___item'>");
		po.push("	<a href='#modsaxExecption' class='me____btn' id='"+this._GID([re, "option", "btn"])+"'>"+lg["option"]+"</a>");
		po.push("	<a href='#modsaxExecption' class='me____tab' id='"+this._GID([re, "option", "open"])+"'>open</a>");
		po.push("</div>");
		}
		if(config.tabExternalUsed){
		po.push("<div class='me___item'>");
		po.push("	<a href='#modsaxExecption' class='me____btn' id='"+this._GID([re, "external", "btn"])+"'>"+lg["external"]+"</a>");
		po.push("	<a href='#modsaxExecption' class='me____tab' id='"+this._GID([re, "external", "open"])+"'>open</a>");
		po.push("</div>");
		}
		$("#"+re+"_headTab").append(po.join(''));
		$("#"+re+"_headTab").bind("click", this.onHeadClick.bind(this));
		this.initPanel();
		this.initFlashButton();
		this.openFileStatus();
	},
	initFlashButton: function(){ // top flash button init
		var config = this.config;
		var re = config.rootElementID;
		var swfTG = this._GID([re, "attch", "swf"]);
		modsFlash.add(swfTG, {src:config.swfUploader, width:"100%", height:"100%",wmode:"opeque"}); //transparent
		modsFlash.setParam(swfTG, {
    		onCall:config.uploadCallBack,
    		uploadPath:config.uploadUrl,
    		externalParam:config.uploadPars.join(","),
    		fileFilterName:config.uploadFilterName,		    		
    		fileFilterValue:config.uploadFilterValue
    	});
    	modsFlash.play();
	},
	initFlashButtonMoveTo: function(obj){ // top flash button init
		var config = this.config;
		var re = config.rootElementID;
		obj.append( $("#"+re+"_attch_swf") );
	},
	initPanel: function(){
		var config = this.config;
		var re = config.rootElementID;
		var po = [];
			po.push("<div class='me___selectW'>");
			po.push("	<a href='#modsaxExecption' class='me___value selectCommand me_ffs' style='font-family:"+config.editorFontFamily+"' id='"+this._GID([re, "fontname"])+"'>"+config.editorFontFamily+"</a>");
			po.push("</div>");
			po.push("<div class='me___selectS'>");
			po.push("	<a href='#modsaxExecption' class='me___value selectCommand me_fss' id='"+this._GID([re, "fontsize"])+"'>"+config.editorFontSize+"</a>");
			po.push("</div>");
			po.push("<div class='me___vline'></div>");
			po.push("<a href='#modsaxExecption' class='me___btnL'>");
			po.push("	<span class='me_icon me___bold simpleCommand' id='"+this._GID([re, "bold"])+"'>Bold</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___italic simpleCommand' id='"+this._GID([re, "italic"])+"'>Italic</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___underLine simpleCommand' id='"+this._GID([re, "underline"])+"'>UnderLine</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnR'>");
			po.push("	<span class='me_icon me___strike simpleCommand' id='"+this._GID([re, "strikethrough"])+"'>strike</span>");
			po.push("</a>");
			po.push("<div class='me___vline'></div>");
			po.push("<div class='me___selectTL'>");
			po.push("	<div class='me___fontColor_disp' style='background:#444444;' id='"+this._GID([re, "foreColorVal"])+"'></div>");
			po.push("	<a href='#modsaxExecption' class='me___value colorCommand' id='"+this._GID([re, "foreColor"])+"'>foreColor</a>");
			po.push("	<a href='#modsaxExecption' class='me___arrow selectCommand me_picker' id='"+this._GID([re, "foreColorExt"])+"'>+</a>");
			po.push("</div>");
			po.push("<div class='me___selectTR'>");
			po.push("	<div class='me___fontBgColor_disp' style='background:#ffffff;' id='"+this._GID([re, "backColorVal"])+"'></div>");
			po.push("	<a href='#modsaxExecption' class='me___value colorCommand' id='"+this._GID([re, "backColor"])+"'>backColor</a>");
			po.push("	<a href='#modsaxExecption' class='me___arrow selectCommand me_picker' id='"+this._GID([re, "backColorExt"])+"'>+</a>");
			po.push("</div>");
			po.push("<div class='me___vline'></div>");
			po.push("<a href='#modsaxExecption' class='me___btnL'>");
			po.push("	<span class='me_icon me___alignLeft simpleCommand' id='"+this._GID([re, "JustifyLeft"])+"'>alignLeft</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___alignCenter simpleCommand' id='"+this._GID([re, "JustifyCenter"])+"'>alignCenter</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___alignRight simpleCommand' id='"+this._GID([re, "JustifyRight"])+"'>alignRight</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnR'>");
			po.push("	<span class='me_icon me___alignJustify simpleCommand' id='"+this._GID([re, "JustifyFull"])+"'>alignJustify</span>");
			po.push("</a>");
			po.push("<div class='me___vline'></div>");
			po.push("<a href='#modsaxExecption' class='me___btnL'>");
			po.push("	<span class='me_icon me___li simpleCommand' id='"+this._GID([re, "InsertUnorderedList"])+"'>li</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___ol simpleCommand' id='"+this._GID([re, "InsertOrderedList"])+"'>ol</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___outdent simpleCommand' id='"+this._GID([re, "outdent"])+"'>outdent</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnM'>");
			po.push("	<span class='me_icon me___indent simpleCommand' id='"+this._GID([re, "indent"])+"'>indent</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnRa'>");
			po.push("	<span class='me_icon me___lineHeight selectCommand me_lhs' id='"+this._GID([re, "lineHeight"])+"'>lineHeight</span>");
			po.push("</a>");
			po.push("<div class='me___vline'></div>");
			po.push("<a href='#modsaxExecption' class='me___btnLa'>");
			po.push("	<span class='me_icon me___url selectCommand me_url' id='"+this._GID([re, "url"])+"'>url</span>");
			po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnMa'>");
			po.push("	<span class='me_icon me___imoticon selectCommand me_ico' id='"+this._GID([re, "imoticon"])+"'>imoticon</span>");
			po.push("</a>");
			//po.push("<a href='#modsaxExecption' class='me___btnMa'>");
			//po.push("	<span class='me_icon me___quotation selectCommand' id='"+this._GID([re, "quotation"])+"'>quotation</span>");
			//po.push("</a>");
			po.push("<a href='#modsaxExecption' class='me___btnR'>");
			po.push("	<span class='me_icon me___pageBreak pbCommand' id='"+this._GID([re, "pageBreak"])+"'>pageBreak</span>");
			po.push("</a>");
		$("#"+re+"_headPanel").append(po.join(''));
		$("#"+re+"_headPanel").find(".simpleCommand").bind("click", this.onSimpleCommandClick.bind(this));
		$("#"+re+"_headPanel").find(".colorCommand").bind("click", this.onColorCommandClick.bind(this));
		$("#"+re+"_headPanel").find(".selectCommand").bind("click", this.onSelectCommandClick.bind(this));
		$("#"+re+"_headPanel").find(".pbCommand").bind("click", this.onInsertCommand.bind(this));
	},
	closePanel: function(){
		var config = this.config;
		var re = config.rootElementID;
		var items = ["home_btn","attch_btn","table_btn","layout_btn","option_btn","external_btn"];
		$("#"+re+"_"+items[this.panelNum]).parent().removeClass("me___itemOn");
		if(this.panelNum == 0) return;
		if(this.panelNum == 1) this.initFlashButtonMoveTo($("#"+re+"_"+items[this.panelNum]).parent());
		
		//this.closeFileStatus();
		this.divPanel.remove();
		$("#"+config.rootElementID+"_head").removeClass("editorHeadExt");	
	},
	openPanel: function(){
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var items = ["home_btn","attch_btn","table_btn","layout_btn","option_btn","external_btn"];
		$("#"+re+"_"+items[this.panelNum]).parent().addClass("me___itemOn");
		
		if(this.panelNum == 0) return;
		if(this.panelNum == 1){
			this.divPanel = $("<div id='"+this._GID([re, "divPanel", "attch"])+"' class='me___headDivPanel_attch'></div>");	
			var po = [];
			po.push("<div class='me___headDivPanel_attch_btns' id='"+re+"_divPanel_attchBtns'>");
			po.push("	<span class='me___span' style='margin-left:33px;'>&nbsp;</span>");
			po.push("	<a href='#modsaxExecption' class='me___btnS1' id='"+this._GID([re, "attbtns", "insertDoc"])+"'>"+lg.insertDoc+"</a>");
			po.push("	<a href='#modsaxExecption' class='me___btnS1' id='"+this._GID([re, "attbtns", "delete"])+"'>"+lg.delSelected+"</a>");
			po.push("	<span class='me___span'>&nbsp;</span>");
			po.push("	<a href='#modsaxExecption' class='me___btnS1' id='"+this._GID([re, "attbtns", "selectAll"])+"'>"+lg.selectAll+"</a>");
			po.push("</div>");
			po.push("<div class='me___headDivPanel_attch_CT' nowrap='nowrap' align='left'>");

		$.each(this.attchFiles, function(si, fo){
			if(fo.checked){
			po.push("<div class='attchItem attchItemON' id='"+re+"_attchItem_"+si+"' title='"+fo.ti.dec()+"'>");
			}else{
			po.push("<div class='attchItem' id='"+re+"_attchItem_"+si+"' title='"+fo.ti.dec()+"'>");
			}
			po.push("<div class='attchItemName'>"+fo.ti.dec()+"</div>");
			po.push("<div class='attchItemPreview'>");
			var ty = fo.ty.dec().toLowerCase();
			if(ty == ".gif" | ty == ".jpg" | ty == ".png" | ty == ".bmp"){
			po.push("<img src='"+fo.path.dec()+fo.nm.dec()+"' width='100%' height='100%' alt='' />")
			}
			po.push("</div>");
			po.push("</div>");
		});
						
			po.push("	<div class='attchItemEnd' id='"+re+"_divPanel_attchItemEnd'>&nbsp;</div>");
			po.push("</div>");
			this.divPanel.html(po.join(''));
			//
			this.openFileStatus();
		}
		if(this.panelNum == 5){
			this.divPanel = $("<div id='"+this._GID([re, "divPanel", "external"])+"' class='me___headDivPanel_attch'></div>");
			var po = [];
			po.push("<div class='me___headDivPanel_attch_btns' id='"+re+"_divPanel_attchBtns'>");
			po.push("<div class='headTitle'>"+lg.externalTitle+"</div>");
			po.push("</div>");
			po.push("<div class='me___headDivPanel_attch_CT' nowrap='nowrap' align='left'>");
			
			$.each(config.tabExternals, function(idx, n){
			po.push("<div class='componentItem' title='"+n.title+"'>");
			po.push("<div class='componentItemName' id='"+n.component+"'>"+n.title+"</div>");  //for XE
			po.push("<div class='componentItemPreview' id='"+n.component+"' style='background:url("+n.ico+") no-repeat 50% 50%;'>");  //for XE
			if(n.ico != ""){
			//po.push("<img src='"+n.ico+"' alt='' width='13px' height='12px' style='margin:2px;' />")
			//for XE...
			}
			po.push("</div>");
			po.push("</div>");
			});
			
			po.push("	<div class='attchItemEnd' id='"+re+"_divPanel_attchItemEnd'>&nbsp;</div>");
			po.push("</div>");
			this.divPanel.html(po.join(''));
		}
		
		$("#"+re+"_headPanel").append(this.divPanel);
		$("#"+config.rootElementID+"_head").addClass("editorHeadExt");
		if(this.panelNum == 1){
			this.initFlashButtonMoveTo($("#"+re+"_divPanel_attchBtns"));
			$("#"+re+"_divPanel_attch").find(".me___btnS1").bind("click", this.onAttbtnsClick.bind(this));
			$("#"+re+"_divPanel_attch").find(".attchItem").bind("click", this.onAttchItemClick.bind(this));
		}
		if(this.panelNum == 5){
			$("#"+re+"_divPanel_external").find(".componentItemPreview").bind("click", this.onClickComponent.bind(this));
		}
	},
	setAttchItem: function(arg){
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		if(!arg) return;
		
		//file size check
		var useByte = 0;
		var volumeByte = config.uploadVolume;
		$.each(this.attchFiles, function(){
			useByte += this.size.number();
		});
		$.each(arg, function(index){
			useByte += this.size.number();
		});
		if(useByte > volumeByte){
			alert(	lg.volumeOverMsg + "\n\n(" + useByte.byte() + "/" + volumeByte.byte() +")" );
			modsFlash.requestFn(re+"_attch_swf","uploadCancel");
			return;
		}
		
		this.readyFiles = arg;
		this.readyUpload();
		//업로드 시작
		modsFlash.requestFn(re+"_attch_swf", "uploadStart");
	},
	readyUpload: function(){
		if(this.readyFiles.length == 0) return;
		var config = this.config;
		var re = config.rootElementID;
		//ready file
		var startIndex = this.attchFiles.length;
		var po = [];
			po.push("<div class='attchItem' id='"+re+"_attchItem_"+startIndex+"'>");
			po.push("	<div class='attchItemName'>.....</div>");
			po.push("	<div class='attchItemPreviewLoad'></div>");
			po.push("</div>");
		$("#"+re+"_divPanel_attchItemEnd").before(po.join(''));
	},
	uploadedFile: function(arg){
		var config = this.config;
		var re = config.rootElementID;
		var startIndex = this.attchFiles.length;
		$("#"+re+"_attchItem_"+startIndex).attr('title', arg.ti.dec());
		$("#"+re+"_attchItem_"+startIndex).find(".attchItemName").html(arg.ti.dec());
		$("#"+re+"_attchItem_"+startIndex).find(".attchItemPreviewLoad").addClass("attchItemPreview");
		$("#"+re+"_attchItem_"+startIndex).bind("click", this.onAttchItemClick.bind(this));
		var ty = arg.ty.dec().toLowerCase();
		if(ty == ".gif" | ty == ".jpg" | ty == ".png" | ty == ".bmp")
			$("#"+re+"_attchItem_"+startIndex).find(".attchItemPreviewLoad").html("<img src='"+arg.path.dec()+arg.nm.dec()+"' width='100%' height='100%' alt='' />")
		this.attchFiles.push(arg);
		this.readyFiles.pop();
		this.readyUpload();
		this.updateFileStatus();
	},
	openFileStatus: function(){
		if(this.fileStatus) return;
		var config = this.config;
		var re = config.rootElementID;
		this.fileStatus = $("<div class='me___headFileStatus'><div id='"+this._GID([re, "fileStatus"])+"'></div></div>");
		$("#"+re+"_headTab").before(this.fileStatus);
		this.updateFileStatus();
	},
	closeFileStatus: function(){
		if(this.attchFiles.length == 0){
			this.fileStatus.remove();		
			this.fileStatus = undefined;
		}
	},
	updateFileStatus: function(){
		var config = this.config;
		var re = config.rootElementID;
		
		var useByte = 0;
		var volumeByte = config.uploadVolume;
		$.each(this.attchFiles, function(index, n){
			useByte += n.size.number();
		});
		
		var used = (useByte.div(volumeByte)*100).round(1);
		
		var fstat = [];
		fstat.push(this.attchFiles.length+ "Files, ");
		fstat.push(useByte.byte()+" / "+volumeByte.byte());
		fstat.push(" (USED "+used+"%) ");
		$("#"+this._GID([re, "fileStatus"])).html(fstat.join(''));
	},
	setAttchFiles: function(files){
		this.attchFiles = files;
		if(this.attchFiles.length > 0){
			this.openFileStatus();	
		}
	},
	initFoot: function(){
		var config = this.config;
		var po = [];
		po.push("<a class='me___handle'>resizer</a>");
		po.push("<div class='me___container'>");
		po.push("	<a href='#modsaxExecption' id='"+config.rootElementID+"_contentMode_0' class='me____tab me____tabOn'>Editor</a>");
		po.push("	<a href='#modsaxExecption' id='"+config.rootElementID+"_contentMode_1' class='me____tab'>HTML</a>");
		po.push("</div>");
		this.foot.append(po.join(''));
		this.foot.find("a.me___handle").bind("mousedown", this.footOnDrag.bind(this));
		this.foot.find("a.me____tab").bind("click", this.onContentMode.bind(this));
	},
	/* initFoot sub functions */
		footOnDrag: function(){
			this.footOnMover = this.footOnMove.bind(this);
			jQuery(document).bind("mousemove", this.footOnMover);
			this.footOnDroper = this.footOnDrop.bind(this);
			jQuery(document).bind("mouseup", this.footOnDroper);
			this.selectstart = this.onselectStart.bind(this);
			jQuery(document).bind("selectstart", this.selectstart);
			this.canvasMask.show();
		},
		footOnMove: function(event){
			if(!event.pageX) return;
		    this.mouse = {x:event.pageX||0, y:event.pageY||0}; //Event.pointer(event);
		    //드래그 감도 적용
		    if(this.config.moveSens > this.moveSens) this.moveSens++;
		    if(this.moveSens == this.config.moveSens) this.footMove();
		},
		footMove: function(){
		    if(!this.draged){
		    	this.draged = true;

				this.canvasTop = (this.contentMode == "html") ? this.htmlArea.offset().top : this.canvas.offset().top;
		    }
		    if( (this.mouse.y - this.canvasTop) > 100 ) this.config.height = (this.mouse.y - this.canvasTop - 2);
		    if(this.observer) clearTimeout(this.observer);
      		this.observer = setTimeout(this.footSetCanvasHeight.bind(this), 10);
		},
		footOnDrop: function(){
			this.moveSens = 0;
			jQuery(document).unbind("mousemove", this.footOnMover);
			jQuery(document).unbind("mouseup", this.footOnDroper);
			jQuery(document).unbind("selectstart", this.selectstart);
			clearTimeout(this.observer);
			this.canvasMask.hide();
			this.draged = false;
		},
		footSetCanvasHeight: function(){
			this.canvas.css({height:this.config.height+"px"});
			if(this.contentMode == "html"){
				this.htmlArea.css({height:this.canvas.height()+"px"});
			}
		},
	/* initFoot sub functions */
	initBody: function(){
		var config = this.config;
		//this.canvas = jQuery("<iframe src='"+config.frameSrc+"' id='"+config.rootElementID+"_canvas' name='"+config.rootElementID+"_canvas' frameBorder='0' allowTransparency='true'></iframe>");
		//for XE...
		this.canvas = jQuery("<iframe src='"+config.frameSrc+"' id='"+config.iframeID+"' name='"+config.rootElementID+"_canvas' frameBorder='0' allowTransparency='true'></iframe>")	
		this.canvasMask = jQuery("<div id='"+config.rootElementID+"_canvasMask' class='me___modsMask' style='display:none;'></div>");
		this.body.append(this.canvas);
		this.body.append(this.canvasMask);
		this.canvas.css({"width":"100%",height:config.height+"px"});
		this.canvas.bind("load", this.readyFrame.bind(this));
	},
	setHtmlMode: function(power){
		if(power == "on"){
			var config = this.config;
			var canvasHeight = this.canvas.height();
			this.canvas.hide();
			this.htmlArea = jQuery("<textarea id='"+config.rootElementID+"_html' name='"+config.rootElementID+"_html' class='me__htmlArea'></textarea>");
			this.body.append(this.htmlArea);
			this.htmlArea.css({"width":"100%",height:canvasHeight+"px"});
			this.htmlArea.val(this.__getContent());
		}else{
			this.setContent(this.htmlArea.val());
			this.canvas.show();
			this.htmlArea.remove();
		}
	},
	readyFrame: function(){
		var config = this.config;
		this.myEDT = window[config.rootElementID+"_canvas"];

		var editorBody = this.myEDT.document;
		if(mods.browser.browser == "ie")	editorBody.body.contentEditable = true;
		else if(mods.browser.browser == "wk"){
			editorBody.body.contentEditable = true;
			editorBody.designMode = "On";
		}else if(mods.browser.browser == "moz")	editorBody.designMode = "On";
		else	editorBody.designMode = "On";
		editorBody.body.style.fontSize = config.editorFontSize;
	    editorBody.body.style.fontFamily = config.editorFontFamily;
		if(this.config.colorset == "black") editorBody.body.style.color = "#FFF"; //for XE... 
	    editorBody.body.focus();
	    this.bindFocusFrame();
	    if(this.config.ondblClick) this.bindDBLFrame(); //for XE
	    if(this.config.onReady) this.config.onReady();
	},
	focusFrame: function(){
		// close all menu
		this.closeColorPicker();
		this.closeffPicker();
		this.closefsPicker();
		this.closelhPicker();
		//this.closeulPicker();
		this.closeicPicker();
	},
	unbindFocusFrame: function(){
		var editorBody = this.myEDT.document;
		if(mods.browser.browser == "moz") $(editorBody).unbind("focus", this.focusFrame.bind(this));
	    else	$(editorBody.body).unbind("focus", this.focusFrame.bind(this));
	},
	bindFocusFrame: function(){
		var editorBody = this.myEDT.document;
		if(mods.browser.browser == "moz") $(editorBody).bind("focus", this.focusFrame.bind(this));
	    else	$(editorBody.body).bind("focus", this.focusFrame.bind(this));
	},
	bindDBLFrame: function(){ // for XE
		var editorBody = this.myEDT.document;
		if(mods.browser.browser == "moz") $(editorBody).bind("dblclick", this.ondblclickFrame.bind(this));
	    else	$(editorBody.body).bind("dblclick", this.ondblclickFrame.bind(this));
	},
	ondblclickFrame: function(event){
		this.config.ondblClick(event);
	},
	onselectStart: function(event){
    	event.stopPropagation();
    	return false;
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	__command: function(sCommand, bUserInterface, vValue){
		var myEDT = this.myEDT.document;
		myEDT.execCommand(sCommand, bUserInterface, vValue);
	},
	__pastHTML: function(sHTML){
		var myEDT = this.myEDT.document;
		var oTmpDiv = myEDT.createElement("DIV");
		oTmpDiv.innerHTML = sHTML;
		
		if(this.contentMode == "editor"){
			var myRange = new SSelection(this.myEDT);
			var rng = myRange.getRangeAt(0);
			rng.insertNode(oTmpDiv.lastChild);
		}else{
			$("#"+this.config.rootElementID+"_html").val($("#"+this.config.rootElementID+"_html").val()+sHTML);
		}
	},
	/* click event */
	onHeadClick: function(event){
		if(typeof(event) == "object"){
			var myID = event.target.id;
			if(!myID) return;
			var ids = myID.split(/_/g);
			var headNM = ids[1];
			var headCMD = ids[2];
		}else{
			var headNM = event;
			var headCMD = "";
		}
		if(headNM == "home"){
			this.closePanel();
			this.panelNum = 0;
			this.openPanel();
		}else if(headNM == "attch"){
			if(this.panelNum == 1) return;
			this.closePanel();
			this.panelNum = 1;
			this.openPanel();
		}else if(headNM == "external"){
			if(this.panelNum == 5) return;
			this.closePanel();
			this.panelNum = 5;
			this.openPanel();
		}
	},
	onAttchPanelOpen: function(arg){
		if(this.panelNum == 1){
			if(arg)	this.setAttchItem(arg);
			return;
		}
		this.closePanel();
		this.panelNum = 1;
		this.openPanel();
		if(arg)	this.setAttchItem(arg);
	},
	onSimpleCommandClick: function(event){
		var myID = event.target.id;
		if(!myID) return;
		var command = this._GPT(myID);
		this.__command(command);
	},
	onColorCommandClick: function(event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;
		var myID = event.target.id;
		if(!myID) return;
		var myCommand = this._GPT(myID);
		var myColor = $("#"+myID+"Val").css("background-color").toColor();
		this.__command(myCommand, false, myColor);

		var myRange = new SSelection(this.myEDT);
		var rng = myRange.getRangeAt(0);
		var nodes = rng.getNodes();
		if(nodes.length){
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var pnode = DOMfix.DF_parentNode(myNode);
				try{
					while(pnode.tagName != "FONT" && pnode.tagName != "SPAN"){
						pnode = DOMfix.DF_parentNode(pnode);
					}
					if(myCommand == "foreColor"){
						pnode.style.color = myColor;
						pnode.removeAttribute("color");
					}else{
						pnode.style.backgroundColor = myColor;
						pnode.removeAttribute("bgcolor");
					}
				}catch(e){}
			}
		}else{
			if(myCommand == "foreColor") myEDT.body.style.color = myColor;
			else myEDT.body.style.backgroundColor = myColor;
		}

	},
	onInsertCommand: function(event){
		var myID = event.target.id;
		if(!myID) return;
		var command = this._GPT(myID);
		if(command == "pageBreak"){
			this.__pastHTML("<hr style='page-break-before:always;border:1px dashed #444;' />");
		}
	},
	onSelectCommandClick: function(event){
		var myEDT = this.myEDT.document;
		var myID = event.target.id;
		if(!myID) return;
		var command = this._GPT(myID);
		//alert("select Command : " + command);
		if(command == "foreColorExt" || command == "backColorExt") this.openColorPicker(command);
		if(command == "fontname") this.fontFamilyPicker(command);
		if(command == "fontsize") this.fontSizePicker(command);
		if(command == "lineHeight") this.lineHeightPicker(command);
		if(command == "url") this.urlPicker(command);
		if(command == "imoticon") this.icoPicker(command);
	},
	onAttbtnsClick: function(event){
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var myID = event.target.id;
		if(!myID) return;
		var cmd = myID.split(/_/g).last();
		if(cmd == "selectAll"){
			$.each(this.attchFiles, function(idx, f){
				f.checked = true;
				$("#"+re+"_attchItem_"+idx).addClass("attchItemON");
			});
		}
		if(cmd == "delete"){
			var delFiles = [];
			$.each(this.attchFiles, function(idx, f){
				if(f.checked){
					delFiles.push("file="+f.nm+"&path="+f.path)	
				}
			});
			if(delFiles.length == 0){
				alert(lg.noSelectedFileMsg);
				return;
			}
			if(!confirm(lg.fileDeleteConfirm)) return;
			var url = config.deleteUrl;
			var pars = config.deletePars.join("&");
			if(pars != "") pars += "&";
			pars += delFiles.join("&")+"&dummy="+mods.dummy;
			new modsreq(url, {pars:pars, onsucc:this.onFileDelete.bind(this)});
		}
		if(cmd == "insertDoc"){
			var insertFiles = $.map(this.attchFiles, function(f){
				if(f.checked) return f;
			});
			if(insertFiles.length == 0){
				alert(lg.noSelectedFileMsg);
				return;
			}
			
			try{
			this.myEDT.document.body.focus();
			}catch(e){}
				
			for(var si = 0;si<insertFiles.length;si++){
				var fo = insertFiles[si];
				var ty = fo.ty.dec().toLowerCase();
				if(ty == ".gif" | ty == ".jpg" | ty == ".png" | ty == ".bmp"){
					this.__pastHTML("<img src='"+fo.path.dec()+fo.nm.dec()+"' alt='' editor_component='image_link' />");
				}else{
					this.__pastHTML("<a href='"+fo.path.dec()+fo.nm.dec()+"' target='_blank'>"+fo.ti.dec()+"</a><div>");
				}
			}
		    
			//goto home
			//this.onHeadClick("home");
		}
	},
	onFileDelete: function(res){
		if(res.result == "ok"){
			var config = this.config;
			var re = config.rootElementID;
			this.attchFiles = $.map(this.attchFiles, function(f, i){
				$("#"+re+"_attchItem_"+i).remove();
				if(f.checked){
				}else{
					return f;
				}
			});
		
			this.updateFileStatus();
						
			if(this.attchFiles.length == 0) return;
			$.each(this.attchFiles, function(si, fo){
				var po = [];
				po.push("<div class='attchItem' id='"+re+"_attchItem_"+si+"' title='"+fo.ti.dec()+"'>");
				po.push("<div class='attchItemName'>"+fo.ti.dec()+"</div>");
				po.push("<div class='attchItemPreview'>");
				var ty = fo.ty.dec().toLowerCase();
				if(ty == ".gif" | ty == ".jpg" | ty == ".png" | ty == ".bmp")
				po.push("<img src='"+fo.path.dec()+fo.nm.dec()+"' width='100%' height='100%' alt='' />")
				po.push("</div>");
				po.push("</div>");
				$("#"+re+"_divPanel_attchItemEnd").before(po.join(''));
			});
			
			$("#"+re+"_divPanel_attch").find(".attchItem").bind("click", this.onAttchItemClick.bind(this));
			
		}else{
			alert(res.msg.dec());	
		}
		
	},
	onAttchItemClick: function(event){
		var config = this.config;
		var re = config.rootElementID;
		var myID = event.target.id;
		if(!myID){
			try{
				myID = $(event.target).parents(".attchItem")[0].id;
			}catch(e){
			}
			if(!myID) return;
		};
		var fidx = myID.split(/_/g).last().number();
		this.attchFiles[fidx].checked = (!this.attchFiles[fidx].checked);
		if(this.attchFiles[fidx].checked){
			$("#"+re+"_attchItem_"+fidx).addClass("attchItemON");
		}else{
			$("#"+re+"_attchItem_"+fidx).removeClass("attchItemON");
		}
	},
	onClickComponent: function(event){
		var myID = event.target.id;
		if(!myID){
			try{
				myID = $(event.target).parents(".componentItemPreview")[0].id;
			}catch(e){
			}
			if(!myID) return;
		};
		if(this.config.onTabExternals) this.config.onTabExternals(myID);
	},
	/* ~~ colorPicker ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	openColorPicker: function(command){
		if(this.colorPicker) this.colorPicker.remove();
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var po = [];
		po.push("<div class='me___selecterBox me_picker' id='"+this._GID([re, command, "picker"])+"'>");
		po.push("	<div class='me___selecterArrow me_picker'></div>");
		if(command == "foreColorExt") po.push("	<div class='me___selecterTitle me_picker'>"+lg.textColor+"</div>");
		if(command == "backColorExt") po.push("	<div class='me___selecterTitle me_picker'>"+lg.textBgColor+"</div>");
		$.each(config.colors, function(index, n){
			po.push("<a href='#modsExex' class='colorItem me_picker' style='background:#"+n+"'>"+n+"</a>");
		});
		po.push("</div>");
		this.colorPicker = $(po.join(''));
		var myHeight = (config.colors.length / 7).ceil() * 21 + 28;
		if(command == "foreColorExt") this.colorPicker.css({width:150, height:myHeight, left:260, top:25});
		if(command == "backColorExt") this.colorPicker.css({width:150, height:myHeight, left:299, top:25});
		$("#"+re+"_headPanel").append(this.colorPicker);

		//other click observer init
		this.clickToClose = this.closeColorPicker.bind(this);
    	$(document).bind("click", this.clickToClose);
    	this.keyDownToClose = this.closeColorPickerKey.bind(this);
    	$(document).bind("keydown", this.keyDownToClose);
    	//color select
    	this.colorPicker.find(".colorItem").bind("click", this.clickColor.bind(this, command));
	},
	closeColorPicker: function(event){
		if(event){
			if(!$(event.target).hasClass("me_picker")){
				if(this.clickToClose) $(document).unbind('click', this.clickToClose);
				if(this.keyDownToClose) $(document).unbind('keydown', this.keyDownToClose);
				if(this.colorPicker) this.colorPicker.remove();
			}
		}else{
			if(this.clickToClose) $(document).unbind('click', this.clickToClose);
			if(this.keyDownToClose) $(document).unbind('keydown', this.keyDownToClose);
			if(this.colorPicker) this.colorPicker.remove();
		}
	},
	closeColorPickerKey: function(){
		if(event.keyCode == mods.Event.KEY_ESC){
			if(this.clickToClose) $(document).unbind('click', this.clickToClose);
			if(this.keyDownToClose) $(document).unbind('keydown', this.keyDownToClose);
			if(this.colorPicker) this.colorPicker.remove();
		}
	},
	clickColor: function(command, event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;

		var myColor = $(event.target).css("background-color").toColor();
		var myCommand = command.replace("Ext", "");
		this.__command(myCommand, false, myColor);

		var myRange = new SSelection(this.myEDT);
		var rng = myRange.getRangeAt(0);
		var nodes = rng.getNodes();
		if(nodes.length){
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var pnode = DOMfix.DF_parentNode(myNode);
				try{
					while(pnode.tagName != "FONT" && pnode.tagName != "SPAN"){
						pnode = DOMfix.DF_parentNode(pnode);
					}
					if(myCommand == "foreColor"){
						pnode.style.color = myColor;
						pnode.removeAttribute("color");
					}else{
						pnode.style.backgroundColor = myColor;
						pnode.removeAttribute("bgcolor");
					}
				}catch(e){}
			}
		}else{
			if(myCommand == "foreColor") myEDT.body.style.color = myColor;
			else myEDT.body.style.backgroundColor = myColor;
		}


		$("#"+this._GID([re, myCommand+"Val"])).css({background:"#"+myColor});
		this.closeColorPicker();
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	/* ~~ font family ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	fontFamilyPicker: function(command){
		if(this.ffPicker) this.ffPicker.remove();
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var po = [];
		po.push("<div class='me___selecterBox me_ffs' id='"+this._GID([re, command, "picker"])+"'>");
		po.push("	<div class='me___selecterArrow me_ffs'></div>");
		po.push("	<div class='me___selecterTitle me_ffs'>"+lg.fontFamily+"</div>");
		$.each(config.fonts, function(index, n){
			po.push("<a href='#modsExex' class='ffItem me_ffs' style='font-family:"+n+"'>"+lg.fontSample+"("+n+")</a>");
		});
		po.push("</div>");
		this.ffPicker = $(po.join(''));
		var myHeight = config.fonts.length * 25 + 30;
		this.ffPicker.css({width:150, height:myHeight, left:3, top:25});
		$("#"+re+"_headPanel").append(this.ffPicker);

		//other click observer init
		this.clickToCloseFF = this.closeffPicker.bind(this);
    	$(document).bind("click", this.clickToCloseFF);
    	this.keyDownToCloseFF = this.closeffPickerKey.bind(this);
    	$(document).bind("keydown", this.keyDownToCloseFF);
    	//color select
    	this.ffPicker.find(".ffItem").bind("click", this.clickff.bind(this, command));
	},
	closeffPicker: function(event){
		if(event){
			if(!$(event.target).hasClass("me_ffs")){
				if(this.clickToCloseFF) $(document).unbind('click', this.clickToCloseFF);
				if(this.keyDownToCloseFF) $(document).unbind('keydown', this.keyDownToCloseFF);
				if(this.ffPicker) this.ffPicker.remove();
			}
		}else{
			if(this.clickToCloseFF) $(document).unbind('click', this.clickToCloseFF);
			if(this.keyDownToCloseFF) $(document).unbind('keydown', this.keyDownToCloseFF);
			if(this.ffPicker) this.ffPicker.remove();
		}
	},
	closeffPickerKey: function(){
		if(event.keyCode == mods.Event.KEY_ESC){
			if(this.clickToCloseFF) $(document).unbind('click', this.clickToCloseFF);
			if(this.keyDownToCloseFF) $(document).unbind('keydown', this.keyDownToCloseFF);
			if(this.ffPicker) this.ffPicker.remove();
		}
	},
	clickff: function(command, event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;
		var myfont = $(event.target).css("font-family");

		this.__command(command, false, myfont);

		var myRange = new SSelection(this.myEDT);
		var rng = myRange.getRangeAt(0);
		var nodes = rng.getTextNodes();
		if(nodes.length){
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var pnode = DOMfix.DF_parentNode(myNode);
				try{
					while(pnode.tagName != "FONT" && pnode.tagName != "SPAN"){
						pnode = DOMfix.DF_parentNode(pnode);
					}
					pnode.style.fontFamily = myfont;
					pnode.removeAttribute("face");
				}catch(e){}
			}
			/*
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var SPANnode = myEDT.createElement("SPAN");
				var pnode = DOMfix.DF_parentNode(myNode);
				pnode.insertBefore(SPANnode, myNode);
				SPANnode.appendChild(myNode);
				SPANnode.style.fontFamily = myfont;
			}
			*/
		}else{
			myEDT.body.style.fontFamily = myfont;
		}
		//일단 현재 선택된 노드에 대한 합의의 형태로 일단락 추후 추가 개발토록 하자.

		$("#"+this._GID([re, "fontname"])).html(myfont);
		$("#"+this._GID([re, "fontname"])).css({"font-family":myfont});

		this.closeffPicker();
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	/* ~~ font size ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	fontSizePicker: function(command){
		if(this.fsPicker) this.fsPicker.remove();
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var po = [];
		po.push("<div class='me___selecterBox me_fss' id='"+this._GID([re, command, "picker"])+"'>");
		po.push("	<div class='me___selecterArrow me_fss'></div>");
		po.push("	<div class='me___selecterTitle me_fss'>"+lg.fontSize+"</div>");
		$.each(config.fontsizes, function(index, n){
			po.push("<a href='#modsExex' class='ffItem me_fss' style='font-size:"+n+"px'>"+lg.fontSample+"("+n+"px)</a>");
		});
		po.push("</div>");
		this.fsPicker = $(po.join(''));
		var myHeight = config.fontsizes.length * 25 + 30;
		this.fsPicker.css({width:150, height:myHeight, left:95, top:25});
		$("#"+re+"_headPanel").append(this.fsPicker);

		//other click observer init
		this.clickToCloseFS = this.closefsPicker.bind(this);
    	$(document).bind("click", this.clickToCloseFS);
    	this.keyDownToCloseFS = this.closefsPickerKey.bind(this);
    	$(document).bind("keydown", this.keyDownToCloseFS);
    	//color select
    	this.fsPicker.find(".ffItem").bind("click", this.clickfs.bind(this, command));
	},
	closefsPicker: function(event){
		if(event){
			if(!$(event.target).hasClass("me_fss")){
				if(this.clickToCloseFS) $(document).unbind('click', this.clickToCloseFS);
				if(this.keyDownToCloseFS) $(document).unbind('keydown', this.keyDownToCloseFS);
				if(this.fsPicker) this.fsPicker.remove();
			}
		}else{
			if(this.clickToCloseFS) $(document).unbind('click', this.clickToCloseFS);
			if(this.keyDownToCloseFS) $(document).unbind('keydown', this.keyDownToCloseFS);
			if(this.fsPicker) this.fsPicker.remove();
		}
	},
	closefsPickerKey: function(){
		if(event.keyCode == mods.Event.KEY_ESC){
			if(this.clickToCloseFS) $(document).unbind('click', this.clickToCloseFS);
			if(this.keyDownToCloseFS) $(document).unbind('keydown', this.keyDownToCloseFS);
			if(this.fsPicker) this.fsPicker.remove();
		}
	},
	clickfs: function(command, event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;
		var mysize = $(event.target).css("font-size");
		this.__command(command, false, 1);
		var myRange = new SSelection(this.myEDT);
		var rng = myRange.getRangeAt(0);
		var nodes = rng.getTextNodes();
		if(nodes.length){
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var pnode = DOMfix.DF_parentNode(myNode);
				try{
					while(pnode.tagName != "FONT" && pnode.tagName != "SPAN"){
						pnode = DOMfix.DF_parentNode(pnode);
					}
					pnode.style.fontSize = mysize;
					pnode.removeAttribute("size");
				}catch(e){}
			}
			/*
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var SPANnode = myEDT.createElement("SPAN");
				var pnode = DOMfix.DF_parentNode(myNode);
				pnode.insertBefore(SPANnode, myNode);
				SPANnode.appendChild(myNode);
				SPANnode.style.fontSize = mysize;
			}
			*/
		}else{
			myEDT.body.style.fontSize = mysize;
		}
		//일단 현재 선택된 노드에 대한 합의의 형태로 일단락 추후 추가 개발토록 하자.
		$("#"+this._GID([re, "fontsize"])).html(mysize);
		this.closefsPicker();
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	/* ~~ lineheight ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	lineHeightPicker: function(command){
		if(this.lhPicker) this.lhPicker.remove();
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var po = [];
		po.push("<div class='me___selecterBox me_lhs' id='"+this._GID([re, command, "picker"])+"'>");
		po.push("	<div class='me___selecterArrow me_lhs'></div>");
		po.push("	<div class='me___selecterTitle me_lhs'>"+lg.lineHeight+"</div>");
		$.each(config.lineHeights, function(index, n){
			po.push("<a href='#modsExex' class='ffItem me_lhs' style='text-align:center;'>"+n+"</a>");
		});
		po.push("</div>");
		this.lhPicker = $(po.join(''));
		var myHeight = config.lineHeights.length * 25 + 30;
		this.lhPicker.css({width:100, height:myHeight, left:515, top:25});
		$("#"+re+"_headPanel").append(this.lhPicker);

		//other click observer init
		this.clickToCloseLH = this.closelhPicker.bind(this);
    	$(document).bind("click", this.clickToCloseLH);
    	this.keyDownToCloseLH = this.closelhPickerKey.bind(this);
    	$(document).bind("keydown", this.keyDownToCloseLH);
    	//color select
    	this.lhPicker.find(".ffItem").bind("click", this.clicklh.bind(this, command));
	},
	closelhPicker: function(event){
		if(event){
			if(!$(event.target).hasClass("me_lhs")){
				if(this.clickToCloseLH) $(document).unbind('click', this.clickToCloseLH);
				if(this.keyDownToCloseLH) $(document).unbind('keydown', this.keyDownToCloseLH);
				if(this.lhPicker) this.lhPicker.remove();
			}
		}else{
			if(this.clickToCloseLH) $(document).unbind('click', this.clickToCloseLH);
			if(this.keyDownToCloseLH) $(document).unbind('keydown', this.keyDownToCloseLH);
			if(this.lhPicker) this.lhPicker.remove();
		}
	},
	closelhPickerKey: function(){
		if(event.keyCode == mods.Event.KEY_ESC){
			if(this.clickToCloseLH) $(document).unbind('click', this.clickToCloseLH);
			if(this.keyDownToCloseLH) $(document).unbind('keydown', this.keyDownToCloseLH);
			if(this.lhPicker) this.lhPicker.remove();
		}
	},
	clicklh: function(command, event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;
		var mylh = $(event.target).text();
		var myRange = new SSelection(this.myEDT);
		var rng = myRange.getRangeAt(0);
		var nodes = rng.getTextNodes();
		if(nodes.length){
			for(var a=0;a<nodes.length;a++){
				var myNode = nodes[a];
				var pnode = DOMfix.DF_parentNode(myNode);
				if(pnode.tagName == "BODY"){
					pnode.style.lineHeight = mylh+"em";
				}else{
					while(pnode.tagName != "P" && pnode.tagName != "DIV"){
						pnode = DOMfix.DF_parentNode(pnode);
					}
					pnode.style.lineHeight = mylh+"em";
				}
			}
		}else{
			myEDT.body.style.lineHeight = mylh+"em";
		}
		//$("#"+this._GID([re, "lineHeight"])).html(mylh);
		this.closelhPicker();
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	/* ~~ url ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	urlPicker: function(command){
		if(this.ulPicker) this.ulPicker.remove();
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		var inpID = this._GID([re, command, "input"]);
		var target_blank = this._GID([re, command, "target_blank"]);
		var target_self = this._GID([re, command, "target_self"]);

		var po = [];
		po.push("<div class='me___selecterBox me_url' id='"+this._GID([re, command, "picker"])+"'>");
		po.push("	<div class='me___selecterArrow me_url' style='left:240px;'></div>");
		po.push("	<div class='me___selecterTitle me_url'>"+lg.url+"</div>");
		po.push("	<div class='me___inputUrl me_url'><input type='text' id='"+inpID+"' class='me_url' style='width:280px;'></div>");
		po.push("	<div class='me___inputBtn me_url'>");
		po.push("	<input type='radio' name='"+this._GID([re, command, "target"])+"' id='"+target_blank+"' class='me_url' value='_blank' checked='checked'> _blank");
		po.push("	<input type='radio' name='"+this._GID([re, command, "target"])+"' id='"+target_self+"' class='me_url' value='_self'> _self");
		po.push("	<input type='button' value='OK' class='MODS_B_5020 me_url me___inputBtnOK' />");
		po.push("	</div>");
		po.push("</div>");
		this.ulPicker = $(po.join(''));
		var myHeight = 90;
		this.ulPicker.css({width:300, height:myHeight, left:355, top:25});
		$("#"+re+"_headPanel").append(this.ulPicker);

		/* url find */
		this.myRange = new SSelection(this.myEDT);
		this.oSelection = this.myRange.getRangeAt(0);
		var oNode = this.oSelection.commonAncestorContainer;
		while(oNode && oNode.tagName != "A") oNode = DOMfix.DF_parentNode(oNode);
		if(oNode){
			var sTarget = oNode.target;
			if(sTarget && sTarget == "_blank") $("#"+target_blank)[0].checked = true;
			$("#"+inpID).val( oNode.href?oNode.href:"http://" );
		}else{
			$("#"+inpID).val("http://");
		}
		$("#"+inpID).select();

		//other click observer init
		this.clickToCloseUL = this.closeulPicker.bind(this);
    	$(document).bind("click", this.clickToCloseUL);
    	this.keyDownToCloseUL = this.closeulPickerKey.bind(this);
    	$(document).bind("keydown", this.keyDownToCloseUL);
    	//color select
    	this.ulPicker.find(".me___inputBtnOK").bind("click", this.clickul.bind(this, command));
    	//this.bindFocusFrame();
	},
	closeulPicker: function(event){
		if(event){
			if(!$(event.target).hasClass("me_url")){
				if(this.clickToCloseUL) $(document).unbind('click', this.clickToCloseUL);
				if(this.keyDownToCloseUL) $(document).unbind('keydown', this.keyDownToCloseUL);
				if(this.ulPicker) this.ulPicker.remove();
			}
		}else{
			if(this.clickToCloseUL) $(document).unbind('click', this.clickToCloseUL);
			if(this.keyDownToCloseUL) $(document).unbind('keydown', this.keyDownToCloseUL);
			if(this.ulPicker) this.ulPicker.remove();
		}
	},
	closeulPickerKey: function(){
		if(event.keyCode == mods.Event.KEY_ESC){
			if(this.clickToCloseUL) $(document).unbind('click', this.clickToCloseUL);
			if(this.keyDownToCloseUL) $(document).unbind('keydown', this.keyDownToCloseUL);
			if(this.ulPicker) this.ulPicker.remove();
		}
	},
	clickul: function(command, event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;
		var lg = modsEditorLang[config.lang];
		var inpID = this._GID([re, command, "input"]);
		var target_blank = this._GID([re, command, "target_blank"]);
		var target_self = this._GID([re, command, "target_self"]);

		var sURL = $("#"+inpID).val();
		this.myRange.selectRange(this.oSelection);

		if(this._validateURL(sURL)){
			var sTarget = ($("#"+target_blank)[0].checked) ? "_blank" : "_self";
				if(this.oSelection.collapsed){
					this.__pastHTML("<a href='"+sURL+"' target='"+sTarget+"'>"+sURL+"</a>");
				}else{
					this.__command("CreateLink", false, sURL);
					this.myRange = new SSelection(this.myEDT);
					this.oSelection = this.myRange.getRangeAt(0);
					var oNode = this.oSelection.commonAncestorContainer;
					while(oNode && oNode.tagName != "A") oNode = DOMfix.DF_parentNode(oNode);
					if(oNode) oNode.target = sTarget;
				}
		}else{
			alert(lg.invaildUrlMsg);
		}
		this.closeulPicker();
	},
	_validateURL : function(sURL){
		return /^(http|https|ftp|mailto):(?:\/\/)?((\w|-)+(?:[\.:@](\w|-))+)(?:\/|@)?([^"\?]*?)(?:\?([^\?"]*?))?$/.test(sURL);
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	/* ~~ imoticon ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	icoPicker: function(command){
		if(this.icPicker) this.icPicker.remove();
		var config = this.config;
		var re = config.rootElementID;
		var lg = modsEditorLang[config.lang];
		if(this.icoCategoryIndex == undefined) this.icoCategoryIndex = 0;
		var icoCategoryIndex = this.icoCategoryIndex;
		var po = [];
		po.push("<div class='me___selecterBox me_ico' id='"+this._GID([re, command, "picker"])+"'>");
		po.push("	<div class='me___selecterArrow me_ico' style='left:372px;'></div>");
		po.push("	<div class='me___selecterTitleTab me_ico'>");
		po.push("		<div class='me___selecterTitleTabTray me_ico'>");
		$.each(modsEditorIcons, function(idx, ca){
			if(icoCategoryIndex == idx)
		po.push("<a href='#modsExec' class='categoryItem me_ico on' id='"+re+"_icoCategory_"+idx+"'>"+ca.categoryNM+"</a>");
			else
		po.push("<a href='#modsExec' class='categoryItem me_ico' id='"+re+"_icoCategory_"+idx+"'>"+ca.categoryNM+"</a>");
		});
		po.push("		</div>");
		po.push("	</div>");
		po.push("	<div class='me___selecterTray me_ico' style='height:120px;' id='"+re+"_icoTray'>");
		var icoFolder = modsEditorIcons[icoCategoryIndex].imageFolder;
		$.each(modsEditorIcons[icoCategoryIndex].icons, function(index, n){
			po.push("<a href='#modsExex' class='icoItem me_ico'><img src='"+icoFolder+n+"' align='middle' alt='' /></a>");
		});
		po.push("	</div>");
		po.push("	<div class='me___selecterBot me_ico' id='"+re+"_icoBot'>");
		po.push("	"+modsEditorIcons[icoCategoryIndex].copyRights);
		po.push("	</div>");
		po.push("</div>");
		this.icPicker = $(po.join(''));

		var myWidth = 396;
		var myHeight = 180;
		this.icPicker.css({width:myWidth, height:myHeight, left:245, top:25});
		$("#"+re+"_headPanel").append(this.icPicker);

		
		//other click observer init
		this.clickToCloseIC = this.closeicPicker.bind(this);
    	$(document).bind("click", this.clickToCloseIC);
    	this.keyDownToCloseIC = this.closeicPickerKey.bind(this);
    	$(document).bind("keydown", this.keyDownToCloseIC);
    	
    	//select
    	this.icPicker.find(".icoItem img").bind("click", this.clickic.bind(this, command));
    	this.icPicker.find(".me___selecterTitleTabTray .categoryItem").bind("click", this.changeCategory.bind(this));
	},
	closeicPicker: function(event){
		if(event){
			if(!$(event.target).hasClass("me_ico")){
				if(this.clickToCloseIC) $(document).unbind('click', this.clickToCloseIC);
				if(this.keyDownToCloseIC) $(document).unbind('keydown', this.keyDownToCloseIC);
				if(this.icPicker) this.icPicker.remove();
			}
		}else{
			if(this.clickToCloseIC) $(document).unbind('click', this.clickToCloseIC);
			if(this.keyDownToCloseIC) $(document).unbind('keydown', this.keyDownToCloseIC);
			if(this.icPicker) this.icPicker.remove();
		}
	},
	closeicPickerKey: function(){
		if(event.keyCode == mods.Event.KEY_ESC){
			if(this.clickToCloseIC) $(document).unbind('click', this.clickToCloseIC);
			if(this.keyDownToCloseIC) $(document).unbind('keydown', this.keyDownToCloseIC);
			if(this.icPicker) this.icPicker.remove();
		}
	},
	clickic: function(command, event){
		var config = this.config;
		var re = config.rootElementID;
		var myEDT = this.myEDT.document;
		var sHTML = "<img src='"+event.target.src+"' align='middle' alt='' style='vertical-align:middle;' editor_component='image_link' />"
		var oTmpDiv = myEDT.createElement("DIV");
		oTmpDiv.innerHTML = sHTML;
		var myRange = new SSelection(this.myEDT);
		var rng = myRange.getRangeAt(0);
		rng.insertNode(oTmpDiv.lastChild);
		this.closeicPicker();
	},
	changeCategory: function(event){
		var config = this.config;
		var re = config.rootElementID;
		var idx = event.target.id.split("_").last();
		if(this.icoCategoryIndex != undefined){
			$("#"+re+"_icoCategory_"+this.icoCategoryIndex).removeClass("on");
		}
		this.icoCategoryIndex = idx;
		icoCategoryIndex = idx;
		$("#"+re+"_icoCategory_"+idx).addClass("on");
		
		var po = [];
		var icoFolder = modsEditorIcons[icoCategoryIndex].imageFolder;
		$.each(modsEditorIcons[icoCategoryIndex].icons, function(index, n){
			po.push("<a href='#modsExex' class='icoItem me_ico'><img src='"+icoFolder+n+"' align='middle' alt='' /></a>");
		});
		$("#"+re+"_icoTray").html(po.join(''));
		this.icPicker.find(".icoItem img").bind("click", this.clickic.bind(this, "imoticon")); //for XE
		
		$("#"+re+"_icoBot").html(modsEditorIcons[icoCategoryIndex].copyRights);
	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	onContentMode: function(event){
		var config = this.config;
		if(event.target.id == config.rootElementID+"_contentMode_0"){
			if(this.contentMode != "editor"){
				this.contentMode = "editor";
				$("#"+config.rootElementID+"_contentMode_0").addClass("me____tabOn");
				$("#"+config.rootElementID+"_contentMode_1").removeClass("me____tabOn");
				this.setHtmlMode("off");
			}
		}else{
			if(this.contentMode != "html"){
				this.contentMode = "html";
				$("#"+config.rootElementID+"_contentMode_0").removeClass("me____tabOn");
				$("#"+config.rootElementID+"_contentMode_1").addClass("me____tabOn");
				this.setHtmlMode("on");
			}
		}
		//goto home
		//this.onHeadClick("home");
	},
	/* ~~ get&set content ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	__getContent: function(){
		var myEDT = this.myEDT.document;
		return myEDT.body.innerHTML;
	},
	getContent: function(){
		var myEDT = this.myEDT.document;
		var ff = myEDT.body.style.fontFamily;
		var fs = myEDT.body.style.fontSize;
		var cl = myEDT.body.style.color;
		var bc = myEDT.body.style.backgroundColor;
		var lh = myEDT.body.style.lineHeight;

		var sts = [];
		if(ff) sts.push("font-family:"+ff);
		if(fs) sts.push("font-size:"+fs);
		if(cl) sts.push("color:"+cl);
		if(bc) sts.push("background-color:"+bc);
		if(lh) sts.push("line-height:"+lh);

		if(this.contentMode == "editor"){
			return "<div class='modsEditorContentBody' style='"+sts.join(";")+";'>"+myEDT.body.innerHTML+"</div>";
		}else{
			return "<div class='modsEditorContentBody' style='"+sts.join(";")+";;'>"+this.htmlArea.val()+"</div>";
		}
	},
	setContent: function(content){
		var myEDT = this.myEDT.document;
		if(typeof content == "string"){
			if(content == "") content = "<p></p>";
			myEDT.body.innerHTML = content;
		}else{
			var myBody = content.find(".modsEditorContentBody");
			if(myBody.html() == null){
				myEDT.body.innerHTML = content.html();
			}else{
				myEDT.body.innerHTML = myBody.html();
				myEDT.body.style.fontFamily = myBody.css("fontFamily");
				myEDT.body.style.fontSize = myBody.css("fontSize");
				myEDT.body.style.color = myBody.css("color");
				myEDT.body.style.backgroundColor = myBody.css("backgroundColor");
				myEDT.body.style.lineHeight = myBody.css("lineHeight");
			}
		}

	},
	/* ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~ */
	nothing: function(){}
});