lb.se = function (o) {
	if(!o.search_keyword.value) {
		alert(lb.lang['search_isnull']);
		o.search_keyword.focus();
		return false;
	}
}

lb.zipSearch = function (o) {
	var params = new Array();
	var responses = new Array('error','message','address_list');
	var keyword = o.keyword.value;
	params['addr'] = (keyword.length > 2 && keyword.substring(keyword.length - 1, keyword.length) == '동') ? '%' + keyword.substring(0, keyword.length - 1) + '%' + '동' : keyword;
	exec_xml('krzip', 'getKrzipCodeList', params, lb.zipPrint, responses, params);
	return false;
}

lb.zipPrint = function (results, responses, args, form) {
	if(!results['address_list']) {
		alert(alert_msg['address']);
		return;
	}
	
	var address_list = results['address_list'].split("\n");
	var oSelect = jQuery('#lb_krzip').get(0).result;
	
	while(oSelect.length > 0) {
		oSelect.remove(0);
	}
	
	for(var i = 0; i < address_list.length; i++) {
		if(!address_list[i]) continue;
		var oOption = new Option(address_list[i],address_list[i],false,false);
		oOption.setAttribute('title', address_list[i]);
		oSelect.options[oSelect.options.length] = oOption;
	}

	oSelect.selectedIndex = 0;
	oSelect.disabled = false;
	jQuery('#lb_krzip select').addClass('lb-kz-done');
}

lb.zipSelect = function (target) {
	var result = jQuery('#lb_krzip select[name="result"]').val();
	if(!result) {
		alert(lb.lang['select_zip']);
		return;
	}
	window.opener.lb.zipSet(target, result);
	window.close();
}

lb.zipSet = function (i, r) {
	jQuery('#lb_' + i).val(r).attr('title', r);
	jQuery('#lb_' + (parseInt(i) + 1)).focus();
}

jQuery(function($){
	$('button.lb-m-b').click(function() {
		var p = $(this).parent().toggleClass('lb-ina');
		if(p.hasClass('lb-sel')) {
			var i = p.find('input[checked]').get(0);
		} else {
			var i = p.find('input').get(0);
		}
		if(i) i.focus();
	});
	$('div.lb-m').mouseleave(function() {
		$(this).addClass('lb-ina');
	});
	$('div.lb-m .lb-m-link').click(function() {
		if($(this).parent().parent().parent().hasClass('lb-ina')) {
			$(this).parent().parent().parent().removeClass('lb-ina');
			return false;
		}
	});
	$('div.lb-m input[type=radio]').change(function() {
		$(this).parent().addClass('lb-sel').siblings().removeClass('lb-sel');
	}).focus(function() {
		$(this).parent().addClass('lb-sel').siblings().removeClass('lb-sel');
	});
});