<?php
    /**
     * @class bible_read
     * @author HolyJohn (holyjohn@gmail.com)
     * @version 1.0
     * @brief 성경읽기
     *
     * Holybible.or.kr을 링크합니다.
     **/

    class bible_read extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

			// 위치 정렬 - 가운데, 왼쪽, 오른쪽 (기본 가운데)
			Context::set('table_position', $args->table_position);

			// 성경 찾을 때 링크를 새창으로 띄우는지 현재 창에서 띄우는지의 여부
			Context::set('window_position', $args->window_position);

            // 템플릿 파일을 지정
            $tpl_file = 'bible_read';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }


    }
?>
