<?php
    /**
     * @file	sphinx.admin.view.php
     * @class	sphinxAdminView
     * @brief	Sphinx Admin View
     * @author	ChoiHeeChul, KimJinHwan, ParkSunYoung
     **/
    class sphinxAdminView extends sphinx {
        /**
	 * @brief 초기화
	 **/
        function init() {
	    // 모듈 설정 가져오기
            $oModuleModel = &getModel('module');
            $this->config = $oModuleModel->getModuleConfig('sphinx');
            $this->setTemplatePath($this->module_path."tpl");
	}
        
        /**
         * @brief 기존 설정값을 로딩하여 설정 페이지 채움
         **/
	function dispSphinxAdminContent() {
            
	    // 설정값 로딩
            $serverName = $this->config->serverName;
            $serverPort = $this->config->serverPort;
            
            Context::set('serverName',$serverName);
            Context::set('serverPort',$serverPort);
            
            $useSphinx = $this->config->useSphinx;
            
            if(!$useSphinx)  $useSphinx = 'false';
            Context::set('useSphinx' , $useSphinx);
            
	    // 보여줄 템플릿 설정
            $this->setTemplateFile("index");
	}
    }
?>