<?php
    /**
     * @file   sphinx.view.php`
     * @class  sphinxView
     * @author ChoiHeeChul, KimJinHwan, ParkSunYoung
     * @brief  sphinx view / NHN의 루씬 모듈을 많은 부분 참고하였습니다. 
     **/
    class sphinxView extends sphinx {
        
	/**
         * @brief 초기화
         **/
        function init() {

	}
        
        /**
         * @brief Search configuration / nlucene 참고\n
         * 모듈 설정 읽어와서 검색대상 모듈 체크하고, 검색어,페이지,검색범위 읽어오기
         **/
        function IS() {
	    
	    // layout 설정 (
	    ///@todo 배포시에는 제거
	    $this->setLayout();
	    
            // 모듈 설정 읽어오기
            $oModuleModel = &getModel('module');
	    $config = $oModuleModel->getModuleConfig('sphinx');
            $ISconfig = $oModuleModel->getModuleConfig('integration_search');
            
            // 통합검색 모듈과 공유하는 설정
            if (!$ISconfig->skin) $ISconfig->skin = 'default';
            Context::set('module_info', unserialize($ISconfig->skin_vars));
            // 템플릿 경로 설정 (통합검색의 템플릿을 그대로 사용)
	    $oISModule = &getModule('integration_search');
            $this->setTemplatePath($this->module_path."/skins/default/");
            
            // 검색 대상 모듈 설정 읽어오기
            $target_mid = $ISconfig->target_module_srl;
            // 검색 대상 모듈 포함/제외 여부 설정 읽어오기
            $target_mode = $ISconfig->target;
            
            // 검색어 읽어오기
            $is_keyword = Context::get('is_keyword');
            // 페이지 읽어오기
            $page = (int) Context::get('page');
            if (!$page) $page = 1;
            // 검색 대상 읽어오기 
            $where = Context::get('where');
            
            // 검색 범위 읽어오기
	    $search_target = Context::get('search_target');
	    if ($search_target == 'tag') $search_target = 'tags';
	    if(!$this->isFieldCorrect($search_target)) $search_target = 'title_content';
            
            
            // sphinx setting
            $sph = new SphinxClient;
            $sph->setServer($config->serverName, $config->serverPort);
            
            // set page
            $sph->setLimits( ($page - 1) * 30 , 30);
            
            $sph->setMatchMode(SPH_MATCH_EXTENDED);
            $sph->setMaxQueryTime(3);
            $sph->setSortMode(SPH_SORT_ATTR_DESC,"regdate");
            
            // 검색 대상이 있으면 필터를 사용해서 해당 모듈만 검색
            if ( isset($target_mid) && $target_mid != '')
            {
                $sph->setFilter("module_srl",explode(",",$target_mid ), strcmp('include',$target_mode) == 0 ? false : true );
            }
            
	    // 검색 범위 처리 (제목, 내용, 댓글 등)
            if ($search_target == "title_content") {
                $query = "@(title,content)";
            } else {
                $query = "@(" . $search_target . ")";
            }
	    
	    // 검색 범위에 따른 검색 (각각 다른 sphinx index 사용 / 전체 검색시에는 문서와 댓글 모두 검색)
            if ($is_keyword)
            {
                switch($where)
                {
                    case 'document':
                        $result = $sph->query($query. " " . $is_keyword, "idx_document");   
                        $output = $this->getDocuments($result,$page);
                        Context::set('output', $output);
                        $this->setTemplateFile("document", $page);
                        break;

                    case 'comment':
                       
                        $result = $sph->query( $is_keyword, "idx_comment");   
                        $output = $this->getComments($result,$page);
                        Context::set('output', $output);
                        $this->setTemplateFile("comment", $page);
                        break;
                    
                    default :
                        $result = $sph->query($query. " " . $is_keyword, "idx_document");   
                        $output['document'] = $this->getDocuments($result,$page);
                        $result = $sph->query($is_keyword, "idx_comment");   
                        $output['comment'] = $this->getComments($result,$page);
                        Context::set('search_result', $output);
                        $this->setTemplateFile("index", $page);
                        break;
                }

                             
            }
            else
            {
                $this->setTemplateFile("no_keywords");
            }
        }
        
	/**
         * @brief 글의 id 목록으로 글을 가져옴.
         * @param $searchResult sphinx 검색 결과
         * @param $page 페이지
         * @return 글의 id목록 리스트
         **/
        function getDocuments($searchResult,$page) {
            $oModelDocument = &getModel('document');
            
            // 결과가 유효한지 확인
            if (!$searchResult && $searchResult != "null" && $searchResult[total_found] > 0 ) {
		$idList = array();
            } else {
                $idList = $this->result2idArray($searchResult);
            }

            // 결과가 1개 이상이어야 글 본문을 요청함.
            $documents = array();
            $tmpDocuments = $oModelDocument->getDocuments($idList, false, false);

            // 받아온 문서 목록을 sphinx에서 반환한 순서대로 재배열
	    foreach($idList as $id) {
                $documents['doc'.$id] = $tmpDocuments[$id];
            }
	
	    // 페이지 처리
            $page_navigation = new PageHandler($searchResult[total_found], ($searchResult[total_found]) / 30+1, $page, 30);

            $output->total_count = $searchResult[total_found];
            $output->data = $documents;
            $output->page_navigation = $page_navigation;
        
            return $output;
        }

	/**
         * @brief 댓글의 id 목록으로 댓글을 가져옴.
         * @param $searchResult sphinx 검색 결과
         * @param $page 페이지
         * @return 댓글의 id목록 리스트
         **/
	function getComments($searchResult, $page) {

            $oModelComment = &getModel('comment');
            
            // 결과가 유효한지 확인
            if (!$searchResult && $searchResult != "null" && $searchResult[total_found] > 0 ) {
		$idList = array();
            } else {
                $idList = $this->result2idArray($searchResult);
            }


            // 받아온 문서 목록을 sphinx에서 반환한 순서대로 재배열
	    $comments = array();
		
            $tmpComments = $oModelComment->getComments($idList);

            foreach($idList as $id) {
                    $comments['com'.$id] = $tmpComments[$id];
            }
			
	
            $page_navigation = new PageHandler($searchResult[total_found], ($searchResult[total_found]) / 30+1, $page, 30);

            $output->total_count = $searchResult[total_found];
            $output->data = $comments;
            $output->page_navigation = $page_navigation;
        
            return $output;

        }        
        
	/**
         * @brief 검색 결과에서 id의 배열을 추출
         * @param $res 검색결과
         * @return $answer 검색결과 중 id의 리스트
         **/
        function result2idArray($res) {

            $resSet = $res[matches];         
            $answer = array();
            if (count($resSet) > 0) {
                foreach ($resSet as $key=>$val) {
                    $answer[] = $key;
                }
	    }
            return $answer;
       }        
        
        /**
         * @brief 검색 범위가 올바른지 아닌지 체크
         * @param $fieldname 검색 범위
         * @return $answer true/false
         **/
        function isFieldCorrect($fieldname) {
                $fields = array('title', 'content', 'title_content', 'tags');
                $answer = in_array($fieldname, $fields);
                return $answer; 
        }
	
	
	/**
	 * @brief 인기 검색어 가져오기\n
	 * 인기 검색어의 경우 별도의 스크립트로 구현 (getTopSearches.sh) 
	 **/
	function getTopSearch()
	{
	    
	}
	
	 /**
         * @brief 메인 페이지에서 검색하였을 경우 xe_sub_portal 사용
         **/
	 /// @todo 배포시 제거요망
        function setLayout()
        {
            $oLayoutModel = &getModel('layout');
            $module_info = Context::get('module_info');
            if ($module_info->mid == 'main' )
            {
                foreach( $oLayoutModel->getLayoutList() as $layout )
                {
                    if ($layout->layout == 'xe_sub_portal')
                    {
                        $module_info->layout_srl = $layout->layout_srl;
                    }
                }
            }
            
        }

    }
?>