<?php
    /**
     * @file	sphinx.admin.controller.php
     * @class	sphinxAdminController
     * @brief	Sphinx Admin Controller
     * @author	ChoiHeeChul, KimJinHwan, ParkSunYoung
     **/
    class sphinxAdminController extends sphinx {
        /**
	 * @brief 초기화
	 **/
        function init() {

	}
        
        /**
         * @brief 어드민 페이지에서 입력한 옵션 값들 세팅
	 * option values
	 * - usesphinx 스핑크스 사용여부
	 * - servername
	 * - serverport
         **/
	function procSphinxAdminSetConfig() {
	    
	    // 인자로 받은 옵션 값을 모듈 설정에 세팅
            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('sphinx');
            
            $config->useSphinx = Context::get('usesphinx');
            $config->serverName = Context::get('servername');
            $config->serverPort = Context::get('serverport');
           
            $oModuleController = &getController('module');
            
	    // 스핑크스 사용시 기존 통합검색 모듈의 IS 액션을 스핑크스로 포워드
            if (strcmp($config->useSphinx, 'true') == 0) {
                $oModuleController->deleteActionForward('integration_search', 'view', 'IS');
                $oModuleController->insertActionForward('sphinx', 'view', 'IS');
            } else {
                $oModuleController->deleteActionForward('sphinx', 'view', 'IS');
                $oModuleController->insertActionForward('integration_search', 'view', 'IS');
            }
	    $output = $oModuleController->insertModuleConfig('sphinx',$config);

            return $output;	

	}
    }
?>