<?php
/**
 * @file qrcode.addon.php
 * @author 최희철 (ironyjk@embian.com)
 * @brief 해당글 주소의 QRcode 를 이미지로 찍어주는 애드온입니다. 생성된 QRCode 를 인쇄하거나 저장하여 사용하세요.\n
 * 구글 Chart API 를 를 사용하였고 misol 님의 soo_mcrblog_link 애드온을 참고하였습니다. 
 **/

if(!defined('__ZBXE__')) exit();
if(isCrawler()) return; // robot 무시
if($called_position != 'before_display_content') return; // before_display_content type 만 처리
if(Context::getResponseMethod() != 'HTML') return; // HTML 만 처리

// 정렬 기본 값 설정 
if(!$addon_info->btn_align) $addon_info->btn_align = 'right';

// 삽입 내용 설정

$document_srl = intval(Context::get('document_srl')); // url 생성

// blog 모드 등일 경우 document_srl 을 가져올 수 없음
if($document_srl)
{
    $url = getFullUrl('','document_srl',$document_srl);     

    $qrcode_div = "<img src='http://chart.apis.google.com/chart?cht=qr&chs=150x150&chl=".urlencode($url)."'>";

    // 문서 하단 삽입
    $output=preg_replace("/<\!--AfterDocument\(([0-9]*),([0-9\-]*)\)-->/i" , 
					"<div style=\"text-align:".$addon_info->btn_align.";\">".$qrcode_div."</div><!--AfterDocument($1,$2)-->", 
					$output);
}

?>
