<?php
    /**
     * @class minion4
     * @author 럭키 (admin@barch.kr)
     * @brief 미니온4 채팅 - XE연동위젯
     **/

    class minion4 extends WidgetHandler {
        var $alert_list = array("ALL","MEMBER","ADMIN","NICKGUEST");
        var $tool_list = array("icon","text","icontext");
        function proc($args) {
            if(!$args->channel) return;
            if(!$args->api_key) return;

            $logged_info = Context::get('logged_info');
            $obj = null;
            $obj->channel = $args->channel;
            $obj->c_width = (int)$args->c_width;
            $obj->c_height = (int)$args->c_height;
            $obj->_id = "minion".rand(1,500);
            $obj->skin = "default";
            $obj->type = ($args->type=="H")? "H" : "V";
            $obj->isFullSize = ($args->isfullsize=="true")? "true" : "false";
            $obj->viewAlert = ($args->viewalert=="true")? "true" : "false";
            $obj->viewUser = ($args->viewuser=="true")? "true" : "false";
            $obj->viewLog = ($args->viewlog=="true")? "true" : "false";
            $obj->isFrame = ($args->isframe=="true")? "true" : "false";
            $obj->alertLimit = ($this->alert_list[$args->alertlimit])? $this->alert_list[$args->alertlimit] : $this->alert_list[0];
            $obj->alertLimitTime = ($args->alertlimittime)? (int)$args->alertlimittime : 3;
            $obj->splitString = ($args->splitstring)? $args->splitstring : ":";
            $obj->toolType = ($this->tool_list[$args->tooltype])? $this->tool_list[$args->tooltype] : $this->tool_list[0];
            $obj->language = ($args->language=="en")? "en" : "ko";
            $obj->securityCode = $this->GetSecurityCode($args->api_key);
            $obj->notice = $args->notice;
            if(!$obj->c_width) $obj->c_width = 500;
            if(!$obj->c_height) $obj->c_height = 250;


            // 회원일때 처리
            if($logged_info->member_srl) {
                // 닉네임 설정
                $obj->nickname = (in_array($args->nickname_type,array("user_id","user_name")))? $logged_info->{$args->nickname_type} : $logged_info->nick_name;
                // 회원권한 부여
                $obj->memberCode = $this->GetMemberCode($args->api_key);
                // 관리권한 부여
                if($args->admin_id) {
                    $admin_list = explode(",",$args->admin_id);
                    if(in_array($logged_info->user_id,$admin_list)) $obj->adminCode = $this->GetAdminCode($args->api_key);
                }
                // 팝업메뉴 설정
                if($args->popup_menu) {
                    $popup_menu = explode(",",$args->popup_menu);
                    $info = array();
                    $info[0] = (array_search("communication",$popup_menu)===FALSE)? "" : str_replace("&amp;","&",getFullUrl('','module','communication','act','dispCommunicationSendMessage','receiver_srl',$logged_info->member_srl));
                    $info[1] = (array_search("homepage",$popup_menu)===FALSE)? "" : $logged_info->homepage;
                    $info[2] = (array_search("blog",$popup_menu)===FALSE)? "" : $logged_info->blog;
                    $obj->info = implode(",",$info);
                }
                // 아이콘 연동
                if($args->icon_type==1) { // 레벨아이콘
                    // 포인트/레벨을 구함
                    $oModuleModel = &getModel('module');
                    $oPointModel = &getModel('point');
                    $config = $oModuleModel->getModuleConfig('point');
                    $point = $oPointModel->getPoint($logged_info->member_srl);
                    $level = $oPointModel->getLevel($point, $config->level_step);
                    $_nickcon = sprintf('%smodules/point/icons/%s/%d.gif', Context::getRequestUri(), $config->level_icon, $level);
                } elseif($args->icon_type==2) { // 그룹아이콘
                    if($logged_info->group_mark->src) $_nickcon = $logged_info->group_mark->src;
                } elseif($args->icon_type==3) { // 아이콘샵
                    $oIconshopModel = &getModel('iconshop');
                    $icon_image = $oIconshopModel->getMemberIconBySelected($logged_info->member_srl);
                    if($icon_image->file1) $_nickcon = Context::getRequestUri().$icon_image->file1;
                } elseif($args->icon_type==4) { // 회원아이콘
                   if($logged_info->image_mark->src) $_nickcon = $logged_info->image_mark->src;
                }
                // 이미지이름 연동
                if($args->nickimage_type == "true" && $logged_info->image_name->src) {
                    $_image_name = $logged_info->image_name->src;
                }

                if($_nickcon && $_image_name) $obj->nickcon = $_nickcon.",".$_image_name;
                elseif($_nickcon) $obj->nickcon = $_nickcon.",{nickname}";
                elseif($_image_name) $obj->nickcon = $_image_name;
                else $obj->nickcon = "";
            }
            Context::set('minion_info',$obj);

            $act = Context::get('act');
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $obj->skin);
            $tpl_file = ($act == "dispPageAdminContentModify" || $act == "procWidgetGenerateCodeInPage")? "page_modify" : "view";

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }

        function GetMemberCode($apiKey) {
            return md5($apiKey.$_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_HOST']);
        }
        function GetAdminCode($apiKey) {
            return md5($_SERVER['HTTP_HOST'].$apiKey.$_SERVER['REMOTE_ADDR']);
        }
        function GetSecurityCode($apiKey) {
            $thisTime = time(); // Unix Timestamp
            return md5($apiKey.$thisTime).'_'.$thisTime;
        }
    }
?>
