<?php
    /**
     * @class minion4
     * @author 럭키 (admin@barch.kr)
     * @brief 미니온4 채팅 - XE연동위젯
     **/

    class Minion4 extends WidgetHandler {
        var $alert_list = array("ALL","MEMBER","ADMIN");
        function proc($args) {
            $obj = $args;
            $logged_info = Context::get('logged_info');

            if(!$obj->channel) return;
            if(!$obj->api_key) return;
            $obj->c_width = (int)$obj->c_width;
            $obj->c_height = (int)$obj->c_height;
            if(!$obj->c_width) $obj->c_width = 500;
            if(!$obj->c_height) $obj->c_height = 250;
            if($obj->admin_id && $logged_info->user_id) {
                $admin_id_list = explode(",",$obj->admin_id);
                if(in_array($logged_info->user_id,$admin_id_list)) $obj->adminCode = $this->GetAdminCode($obj->api_key);
            }
            $obj->_id = "minion".rand(1,500);
            $obj->skin = "default";
            $obj->type = ($obj->type=="H")? "H" : "V";
            $obj->viewLog = ($obj->viewlog=="true")? "true" : "false";
            $obj->isFrame = ($obj->isframe=="true")? "true" : "false";
            $obj->alertLimit = ($this->alert_list[$obj->alertlimit])? $this->alert_list[$obj->alertlimit] : $this->alert_list[0];
            $obj->language = ($obj->language=="en")? "en" : "ko";
            $obj->securityCode = $this->GetSecurityCode($obj->api_key);
            $obj->nickname = (in_array($obj->nickname_type,array("user_id","user_name")))? $logged_info->{$obj->nickname_type} : $logged_info->nick_name;

            // 아이콘 연동
            if($obj->icon_type==1) { // 레벨아이콘
                // 포인트/레벨을 구함
                $oModuleModel = &getModel('module');
                $oPointModel = &getModel('point');
                $config = $oModuleModel->getModuleConfig('point');
                $point = $oPointModel->getPoint($logged_info->member_srl);
                $level = $oPointModel->getLevel($point, $config->level_step);
                $obj->nickcon = sprintf('%smodules/point/icons/%s/%d.gif,{nickname}', Context::getRequestUri(), $config->level_icon, $level);
            } elseif($obj->icon_type==2) { // 그룹아이콘
                if($logged_info->group_mark->src) $obj->nickcon = $logged_info->group_mark->src.",{nickname}";
            } elseif($obj->icon_type==3) { // 아이콘샵
                $oIconshopModel = &getModel('iconshop');
                $icon_image = $oIconshopModel->getMemberIconBySelected($logged_info->member_srl);
                if($icon_image) $obj->nickcon = sprintf('%s,{nickname}',Context::getRequestUri().$icon_image->file1);
            } elseif($obj->icon_type==4) { // 회원아이콘
               if($logged_info->image_mark->src) $obj->nickcon = $logged_info->image_mark->src.",{nickname}";
            }
            // 이미지네임 연동
            if($obj->nickimage_type == "true" && $logged_info->image_name->src) {
                if($obj->nickcon) $obj->nickcon = str_replace("{nickname}",$logged_info->image_name->src,$obj->nickcon);
                else $obj->nickcon = $logged_info->image_name->src;
            }
            Context::set('minion_info',$obj);

            $act = Context::get('act');
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $obj->skin);
            $tpl_file = ($act == "dispPageAdminContentModify" || $act == "procWidgetGenerateCodeInPage")? "page_modify" : "view";

            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
        function GetAdminCode($apiKey) {
            return md5($apiKey.$_SERVER['REMOTE_ADDR']);
        }
        function GetSecurityCode($apiKey) {
            $thisTime = time(); // Unix Timestamp
            return md5($apiKey.$thisTime).'_'.$thisTime;
        }
    }
?>
