<?php
    /**
     * @class xgenesis_login
     * @author jedison (master@xgenesis.org)
     * @version 0.1
     * @brief 로그인 폼을 출력하는 위젯
     *
     * $logged_info를 이용하며 이는 미리 설정되어 있음
     **/

    class xgenesis_login extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            if(Context::get('is_logged')) $tpl_file = 'login_info';
            else $tpl_file = 'login_form';

            // 회원 관리 정보를 받음
            $oModuleModel = &getModel('module');
            $this->member_config = $oModuleModel->getModuleConfig('member');
            Context::set('member_config', $this->member_config);

            // ssl 사용시 현재 https접속상태인지에 대한 flag및 https url 생성
            $ssl_mode = false;
            if($this->member_config->enable_ssl == 'Y') {
                if(preg_match('/^https:\/\//i',Context::getRequestUri())) $ssl_mode = true;
            }
            Context::set('ssl_mode',$ssl_mode);
			
            // 금연모듈에서 정보를 가져온다.
            $oStopsmokingModel = &getModel('stopsmoking');
            
        	// site_srl, module_srl, member_srl값을 가져온다.
            $site_module_info = Context::get('site_module_info');
            $args->site_srl = (int)$site_module_info->site_srl;
            $module_info = $oStopsmokingModel->getModulesInfo();	            
			$args->module_srl = $module_info->module_srl;
            $member_info = Context::get('logged_info');
            $args->member_srl = $member_info->member_srl;

			// 금연결심을 가져온다.
            $decision = $oStopsmokingModel->getDecision($args);

            // 금연결심이 있다면
            if($decision->data!=null){

            	// 금연일수를 계산한다.
            	$standardDateTime = date('Y-m-d H:i:s');
				$comparisonDateTime = zdate($decision->data->stop_date,"Y-m-d H:i:s");
				$timer = $oStopsmokingModel->getDiffDateTime($standardDateTime,$comparisonDateTime);
				
				// 흡연일수를 계산한다.
				$smokingStandardDateTime = zdate($decision->data->stop_date,"Y-m-d H:i:s");
				$smokingComparisonDateTime = zdate($decision->data->start_date,"Y-m-d H:i:s");
				$smokingDay = $oStopsmokingModel->getDiffDateTime($smokingStandardDateTime,$smokingComparisonDateTime);				
				$decision->data->smoking_day = $smokingDay->diffDate;
				
				// 그룹정보를 가져온다.
				$timer->group = $oStopsmokingModel->getGroup($timer, $module_info);		
				// 참은담배갯수를 계산한다.
				$timer->stop_cigarette_count = $oStopsmokingModel->getStopCigaretteCount($decision->data, $timer);
				// 그동안 사용한 담배값을 구한다.
				$timer->spend_money = $oStopsmokingModel->getSpendMoney($decision->data);
				// 번돈을 구한다.
				$timer->earn_money = $oStopsmokingModel->getEarnMoney($decision->data, $timer);
				// 연장된생명을 구한다.
				$timer->save_life = $oStopsmokingModel->getSaveLife($decision->data, $timer);			
				// 흡연시작일
				$timer->start_date = $decision->data->start_date;
				// 금연시작일
				$timer->stop_date = $decision->data->stop_date;
				// 금연결심
            	$timer->decision = $decision->data->decision;
debugPrint($timer);
            	Context::set('timer', $timer);
            }
            
            // 금연사용정보
            Context::set('use_stopsmoking',$args->use_stopsmoking);
            
            // 금연사용정보
            Context::set('use_favorite',$args->use_favorite);
            
            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }


    }
?>
