<?php
    /**
     * @class  portalpointModel
     * @author 러키군 (admin@barch.kr)
     * @brief  portalpoint 모듈의 Model class
     **/

    class portalpointModel extends portalpoint {
        /**
         * @brief 초기화
         **/
        function init() {
        }
        /**
         * @brief 모듈정보 가져옴
         **/
        function getConfig() {
            // 설정 정보 가져오기
            $oModuleModel = &getModel('module');
            $portal_config = $oModuleModel->getModuleConfig('portalpoint');
            if($portal_config->url_list) $portal_config->url_list = unserialize($portal_config->url_list);

            return $portal_config;
        }
        /**
         * @brief 해당포탈의 쿨타임이 지났는지 검사함
         **/
        function todayClickCheck($member_srl,$obj) {
            if(!$obj['title']) return false;
            if(!$obj['delay']) return true;
            $obj['delay_type'] = (int)$obj['delay_type'];

            $args = null;
            $args->title = $obj['title'];
            $args->member_srl = $member_srl;
            $args->ipaddress_prefix  = preg_replace('/([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)/','$1.$2.$3', $_SERVER['REMOTE_ADDR']);
            $output = executeQuery("portalpoint.getLog",$args);
            if(!$output->data) return true;

            $last_regdate = zDate($output->data->regdate,"Y-m-d h:i:s");
            $now = date("Y-m-d h:i:s");
            $time = strtotime($now) - strtotime($last_regdate);
            $day = floor(($time)/(60*60*24));
            $hour = floor(($time-($day*60*60*24))/(60*60));
            $minute = floor(($time-($day*60*60*24)-($hour*60*60))/(60));

            // 시간비교-분일때
            if($obj['delay_type']==1) {
                if($minute < $obj['delay']) return false;
            } else {
                if($day < $obj['delay']) return false;
            }

            return true;
        }
        /**
         * @brief 클릭한회원의 오늘 획득포인트를 리턴
         **/
        function getTodayTotalPoint($member_srl) {
            $args = null;
            $args->member_srl = $member_srl;
            $args->ipaddress_prefix  = preg_replace('/([0-9]+)\.([0-9]+)\.([0-9]+)\.([0-9]+)/','$1.$2.$3', $_SERVER['REMOTE_ADDR']);
            $args->regdate = date("Ymd");
            $output = executeQuery("portalpoint.getLogWithPoint",$args);

            return (int)$output->data->total_point;
        }
    }
?>
