<?php
    /**
     * @class  portalpointView
     * @author 러키군 (admin@barch.kr)
     * @brief  portalpoint 모듈의 View class
     **/

    class portalpointView extends portalpoint {
        /**
         * @brief 초기화
         **/
        function init() {
            // template path지정
            $this->setTemplatePath($this->module_path.'tpl');
        }
        /**
         * @brief 실제 클릭이벤트 발생
         **/
        function dispPortalpointIndex() {
            global $lang;

            // 권한 체크
            $logged_info = Context::get('logged_info');
            //if(!$logged_info->member_srl) return new Object(-1,'msg_not_permitted');

            // title 존재하는지 검사
            $title = Context::get('title');
            if(!$title) return new Object(-1,'msg_invalid_request');

            // 포탈목록 가져옴
            $oPortalModel = &getModel('portalpoint');
            $portal_config = $oPortalModel->getConfig();
            // 클릭한 포탈정보 구해옴
            if($portal_config->url_list) {
                foreach($portal_config->url_list as $key => $val) {
                    if($title==$val['title']) {
                        $selected = $val;
                        break;
                    }
                }
            }
            if(!$selected) return new Object(-1,'msg_invalid_request');
            Context::set('selected',$selected);

            // 해당포탈을 오늘 클릭했는지 검사함
            if($logged_info->member_srl) {
                $check = $oPortalModel->todayClickCheck($logged_info->member_srl,$selected);
                if($check) {
                    $oPointController = &getController('point');
                    $oPortalController = &getController('portalpoint');
                    $oPointController->setPoint($logged_info->member_srl,$selected['point'], 'add');
                    $args = null;
                    $args->member_srl = $logged_info->member_srl;
                    $args->title = $selected['title'];
                    $args->url = $selected['url'];
                    $args->point = $selected['point'];
                    $oPortalController->insertLog($args);
                    if($selected['use_message1']!='N') {
                        $message = ($selected['click_message1'])? str_replace(array("[point]","[url]","\n"),array($selected['point'],$selected['url'],"\\n"),$selected['click_message1']) : sprintf($lang->click_message1,$selected['point']);
                        Context::set('message',$message);
                    }
                } else {
                    if($selected['use_message2']!='N') {
                        $message = ($selected['click_message2'])? str_replace(array("[point]","[url]","\n"),array($selected['point'],$selected['url'],"\\n"),$selected['click_message2']) : $lang->click_message2;
                        Context::set('message',$message);
                    }
                }
            } else {
                Context::set('message',$lang->guest_message);
            }

            // 템플릿 파일 지정
            $this->setTemplateFile('_result');
        }
    }
?>