<?php
    /**
     * @class  analysisController
     * @author jedison (master@xgenesis.org)
     * @brief  analysis 모듈의 controller class
     **/

    class analysisController extends analysis {

        /**
         * @brief 초기화
         **/
        function init() {
        }
        
        /**
         * @brief 분석을 위해 접속자정보 기록하기 (애드온에서 사용함)
         * 
         * 대상 테이블
         * - analysis_log
         **/
        function procAnalysisInsert() {        	
            $oAnalysisModel = &getModel('analysis');
			
            // Context에 저장된 값 가져오기
            $logged_info        = Context::get('logged_info');
		    $member_srl         = $logged_info->member_srl;
            $site_module_info = Context::get('site_module_info');
            $site_srl = (int)$site_module_info->site_srl;
            
            // 리퀘스트
            $request_uri = $_SERVER["REQUEST_URI"];
            $content = $this->getContent($request_uri);
            
            // 리퍼러
            $referer_array = parse_url($_SERVER["HTTP_REFERER"]);
            $referer_host = $referer_array['host'];
            $referer_url = removeHackTag($_SERVER["HTTP_REFERER"]);
            $search_word = $this->getSearchWord($referer_host, $referer_url);
			
            // analysis_log
            $args->analysis_log_srl = getNextSequence();
            $args->ip_address   = $_SERVER['REMOTE_ADDR'];
            $args->user_agent   = substr($_SERVER['HTTP_USER_AGENT'], 0, 250);
		    $args->referer_host = $referer_host;
		    $args->referer_url  = $referer_url;
		    $args->search_word  = $search_word;
		    $args->member_srl   = $member_srl;
		    
            $args->site_srl     = $site_srl;
            $args->mid          = $content->mid;
            $args->document_srl = $content->document_srl;
            $args->act          = $content->act;
			$args->input_date   = date("YmdHis");
            $output = $oAnalysisModel->insertAnalysisLog($args);
        }
        
        /**
         * 
         * @param $referer_host
         * @param $referer_url
         * @return unknown_type
         */
        function getSearchWord($referer_host, $referer_url){
        	//$referer_host = "cafeblog.search.naver.com";
        	//$referer_url = "/search.naver?where=post&sm=tab_pge&query=400+BAD+REQUEST&st=sim&date_option=-1&date_from=&date_to=&dup_remove=1&post_blogid=&post_blogurl=&post_blogurl_without=&detail_and_query=&detail_not_query=&detail_or_query=&det";
                	
        	// 구글
        	if(
	        	$referer_host == "www.google.co.kr" || 
	        	$referer_host == "www.google.com" ||
	        	$referer_host == "www.google.ca" ||
	        	$referer_host == "www.google.co.uk" ||
	        	$referer_host == "www.google.co.jp" ||
	        	$referer_host == "www.google.com.br"
        	){
	        	$removeTrash = str_replace("/search?","",$referer_url);
				$tempArray = split("&",$removeTrash);
	        	for($i=0;$i<count($tempArray);$i++){
					$tempSearchWord = $this->getValueByKey($tempArray[$i],"q");
					if(strlen($tempSearchWord)>0){
						$tempSearchWord = urldecode($tempSearchWord);
						debugPrint($tempSearchWord);
						$result = $tempSearchWord;
					}
				}
        	}
        	
        	// 네이버
        	if(
	        	$referer_host == "search.naver.com" || 
	        	$referer_host == "m.search.naver.com" || 
	        	$referer_host == "web.search.naver.com" || 
	        	$referer_host == "cafeblog.search.naver.com"
        	){
	        	$removeTrash = str_replace("/search.naver?","",$referer_url);
				$tempArray = split("&",$removeTrash);
	        	for($i=0;$i<count($tempArray);$i++){
					$tempSearchWord = $this->getValueByKey($tempArray[$i],"query");
					if(strlen($tempSearchWord)>0){
						if($referer_host == "m.search.naver.com"){
							$tempSearchWord = urldecode($tempSearchWord);
							debugPrint($tempSearchWord);
						}
						if($referer_host == "search.naver.com"){
							$tempSearchWord = urldecode($tempSearchWord);
							$tempSearchWord = iconv("EUC-KR","UTF-8",$tempSearchWord);
						}
						$result = $tempSearchWord;
					}
				}
        	}

        	// 다음
        	if($referer_host == "search.daum.net"){
	        	$removeTrash = str_replace("/search?","",$referer_url);
				$tempArray = split("&",$removeTrash);
	        	for($i=0;$i<count($tempArray);$i++){
					$tempSearchWord = $this->getValueByKey($tempArray[$i],"q");
					if(strlen($tempSearchWord)>0){
						$tempSearchWord = urldecode($tempSearchWord);
						$tempSearchWord = iconv("EUC-KR","UTF-8",$tempSearchWord);
						debugPrint($tempSearchWord);
						$result = $tempSearchWord;
					}
				}
        	}
        	
        	// 야후
        	if($referer_host == "kr.search.yahoo.com"){
	        	$removeTrash = substr($referer_url, strpos($referer_url, "?"));
				$tempArray = split("&",$removeTrash);
	        	for($i=0;$i<count($tempArray);$i++){
					$tempSearchWord = $this->getValueByKey($tempArray[$i],"p");
					if(strlen($tempSearchWord)>0){
						$tempSearchWord = urldecode($tempSearchWord);
						debugPrint($tempSearchWord);
						$result = $tempSearchWord;
					}
				}
        	}

			return $result;
        }
        
        function getContent($request_uri){
        	// ?mid=xxx&act=xxx 의 형태의 경우
        	if(strpos($request_uri,"?")){
        		$content_array = split("&",$request_uri);
        		for($i=0;$i<count($content_array);$i++){
        			
	        		$tempMid = $this->getValueByKey($content_array[$i],"mid");
	        		if($tempMid != ""){
	        			$output->mid = $tempMid;
	        		}
	        		$tempDocumentSrl = $this->getValueByKey(trim($content_array[$i]),"document_srl");
        			if($tempDocumentSrl != ""){
	        			$output->document_srl = $tempDocumentSrl;
	        		}
	        		$tempAct = $this->getValueByKey($content_array[$i],"act");
        			if($tempAct != ""){
	        			$output->act = $tempAct;
	        		}
        		}
        	} else {
				$content_array = split("/",$request_uri);
				if(count($content_array)==2){
					// $content_array[1]가 숫자일 경우
					if(is_numeric($content_array[1])){
						$output->document_srl = $content_array[1];
					} else {
						$output->mid = $content_array[1];
					}
				} else {
					$output->mid          = $content_array[1];
	        		$output->document_srl = $content_array[2];
				}
	        	
        	}
        	return $output;	
        }
        
        function getValueByKey($keyValue,$key){
        	$removeQuestion = str_replace("?","",$keyValue);
        	$removeSlash = str_replace("/","",$removeQuestion);	
        	$tempArray = split("=",$removeSlash);
        	$tempKey = trim($tempArray[0]);
        	$tempValue = trim($tempArray[1]);
        	if($tempKey==$key){
        		$result = $tempValue;
        	}
        	return $result;
        }
        
        
        
    }
?>