<?php
    /**
     * @class  analysisAdminView
     * @author jedison (master@xgenesis.org)
     * @brief  analysis 모듈의 Admin view class
     **/

    class analysisAdminView extends analysis {

        /**
         * @brief 초기화
         **/
        function init() {
            // 템플릿 경로 지정 
            $this->setTemplatePath($this->module_path.'tpl');
        }

        /**
         * @brief 
         **/
        function dispAnalysisAdminDomain() {
            // 정해진 일자가 없으면 오늘자로 설정
            //$selected_date = Context::get('selected_date');
            //if(!$selected_date) $selected_date = date("Ymd");
            //Context::set('selected_date', $selected_date);
            $oAnalysisAdminModel = &getAdminModel('analysis');
            $oAnalysisAdminController = &getAdminController('analysis');
        	
        	// 목록가져오기
        	$page = Context::get('page');
            if(!$page) $page = 1;
            $args->order_target = "count";	// domain | count
            $args->order_type = "desc";	// desc | asc
            $args->list_count = "20";
            $args->page = $page;
            $output = $oAnalysisAdminModel->getAnalysisDomainList($args);
            
            // 전체count 구하기
            $domain_total_count = 0;
            if($output->data!=null){
	            foreach($output->data as $key=>$val) {
	            	$domain_total_count += $val->count;
	            }
            }
			Context::set('domain_total_count', $domain_total_count);
			Context::set('page', $output->page);
            Context::set('list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
            
            // 표시
            $this->setTemplateFile('domain');
        }
        
    	/**
         * @brief 
         **/
        function dispAnalysisAdminSearchword() {
        	
        	$oAnalysisAdminModel = &getAdminModel('analysis');
            $oAnalysisAdminController = &getAdminController('analysis');

        	// 목록가져오기
        	$page = Context::get('page');
            if(!$page) $page = 1;
            $args->order_target = "count";	// search_word | count
            $args->order_type = "desc";	// desc | asc
            $args->list_count = "20";
            $args->page = $page;
            $output = $oAnalysisAdminModel->getAnalysisSearchwordList($args);

			if(count($output->data)) {
	            // 전체count 구하기
	            $search_word_total_count = 0;
	            foreach($output->data as $key=>$val) {
	            	$search_word_total_count += $val->count;
	            }
	
				Context::set('search_word_total_count', $search_word_total_count);
				Context::set('page', $output->page);
	            Context::set('list', $output->data);
	            Context::set('page_navigation', $output->page_navigation);
			}
            // 표시
            $this->setTemplateFile('search_word');
        }
        
    	/**
         * @brief 
         **/
        function dispAnalysisAdminBrowser() {
        	$oAnalysisAdminModel = &getAdminModel('analysis');
            $oAnalysisAdminController = &getAdminController('analysis');

        	// 목록가져오기
        	$page = Context::get('page');
            if(!$page) $page = 1;
            $args->order_target = "count";	// browser | count
            $args->order_type = "desc";	// desc | asc
            $args->list_count = "20";
            $args->page = $page;
            $output = $oAnalysisAdminModel->getAnalysisBrowserList($args);
       		
            if(count($output->data)) {
	            // 전체count 구하기
	            $browser_total_count = 0;
	            foreach($output->data as $key=>$val) {
	            	$browser_total_count += $val->count;
	            }
	
				Context::set('browser_total_count', $browser_total_count);
				Context::set('page', $output->page);
	            Context::set('list', $output->data);
	            Context::set('page_navigation', $output->page_navigation);
            }
            // 표시
            $this->setTemplateFile('browser');
        }
        
    	/**
         * @brief 
         **/
        function dispAnalysisAdminFavoriteDocument() {
        	$oAnalysisAdminModel = &getAdminModel('analysis');
            $oAnalysisAdminController = &getAdminController('analysis');

        	// 목록가져오기
        	$page = Context::get('page');
            if(!$page) $page = 1;
            $args->order_target = "count";	// title | count
            $args->order_type = "desc";	// desc | asc
            $args->list_count = "20";
            $args->page = $page;
            $output = $oAnalysisAdminModel->getAnalysisFavoriteDocumentList($args);
            
            if(count($output->data)) {
	            // 전체count 구하기
	            $favorite_document_total_count = 0;
	            foreach($output->data as $key=>$val) {
	            	$favorite_document_total_count += $val->count;
	            }
	
				Context::set('favorite_document_total_count', $favorite_document_total_count);
				Context::set('page', $output->page);
	            Context::set('list', $output->data);
	            Context::set('page_navigation', $output->page_navigation);
            }
            // 표시
            $this->setTemplateFile('favorite_document');
        }
        
    	/**
         * @brief 
         **/
        function dispAnalysisAdminFavoriteMenu() {
            $oAnalysisAdminModel = &getAdminModel('analysis');
            $oAnalysisAdminController = &getAdminController('analysis');

        	// 목록가져오기
        	$page = Context::get('page');
            if(!$page) $page = 1;
            $args->order_target = "count";	// name | count
            $args->order_type = "desc";	// desc | asc
            $args->list_count = "20";
            $args->page = $page;
            $output = $oAnalysisAdminModel->getAnalysisFavoriteMenuList($args); 
			
            if(count($output->data)) {
	            // 전체count 구하기
	            $favorite_menu_total_count = 0;
	            foreach($output->data as $key=>$val) {
	            	$favorite_menu_total_count += $val->count;
	            }
	
				Context::set('favorite_menu_total_count', $favorite_menu_total_count);
				Context::set('page', $output->page);
	            Context::set('list', $output->data);
	            Context::set('page_navigation', $output->page_navigation);
            }
            // 표시
            $this->setTemplateFile('favorite_menu');
        }
        
    	/**
         * @brief 
         **/
        function dispAnalysisAdminSetting() {
            // 표시
            $this->setTemplateFile('setting');
        }

    }
?>