<?php
    /**
     * 관리자모듈 업무 처리
     * 
     * @class  analysisAdminController
     * @author jedison (master@xgenesis.org)
     * @brief  analysis 모듈의 admin controller class
     **/

    class analysisAdminController extends analysis {

        /**
         * @brief 초기화
         **/
        function init() {

        }
        
        /**
         * @brief 
         **/
        function procAnalysisAdminAnalyzeDomain() {
            $oAnalysisModel = &getAdminModel('analysis');
			
            // form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
			// analysis_log 에서 데이터 가져오기
			$args->domain_analyze_yn = 'N';
			$output = $oAnalysisModel->getAnalysisLogListAll($args);

            if($output->data) {
				foreach($output->data as $key=>$val) {
					// referer_host값이 있을 경우
					if($val->referer_host!=null){
						// 1.analysis_domain에 입력된 값이 있는지 검사
						$args->domain = $val->referer_host;
						$output = $oAnalysisModel->getAnalysisDomain($args);						
						// 2.입력된 값이 없을 경우
			            if($output->data==null){
			            	$args->count = 1;
			            	$output = $oAnalysisModel->insertAnalysisDomain($args);			            	
			            // 3.입력된 값이 있을 경우            	
			            } else {          	
			            	$args->count = $output->data->count + 1;             	
			            	$output = $oAnalysisModel->updateAnalysisDomain($args);			            	
			            }
					} else {
						// 1.analysis_domain에 입력된 값이 있는지 검사
						$args->domain = "Direct Access"; // 직접접근
						$output = $oAnalysisModel->getAnalysisDomain($args);						
						// 2.입력된 값이 없을 경우
			            if($output->data==null){
			            	$args->count = 1;
			            	$output = $oAnalysisModel->insertAnalysisDomain($args);			            	
			            // 3.입력된 값이 있을 경우            	
			            } else {          	
			            	$args->count = $output->data->count + 1;             	
			            	$output = $oAnalysisModel->updateAnalysisDomain($args);			            	
			            }
					}
					
					// analysis_log의 domain_analyze_yn값을 Y로 변경
					$args->domain_analyze_yn = 'Y';
					$args->analysis_log_srl = $val->analysis_log_srl;
					$output = $oAnalysisModel->updateAnalysisLog($args);	
                }
        	}
        	
        	// filter로 넘겨줄 값설정
            $this->setMessage('success_analyze_domain');
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief 
         **/
        function procAnalysisAdminAnalyzeSearchWord() {
            $oAnalysisModel = &getAdminModel('analysis');
            
            // form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();

			// analysis_log 에서 데이터 가져오기
			$args->search_word_analyze_yn = 'N';
			$output = $oAnalysisModel->getAnalysisLogListAll($args);

            if($output->data) {
				foreach($output->data as $key=>$val) {
					// search_word값이 있을 경우
					if($val->search_word!=null){
						// 1.analysis_searchword에 입력된 값이 있는지 검사
						$args->search_word = $val->search_word;
						$output = $oAnalysisModel->getAnalysisSearchWord($args);
						// 2.입력된 값이 없을 경우
			            if($output->data==null){
			            	$args->count = 1;
			            	$output = $oAnalysisModel->insertAnalysisSearchWord($args);
			            // 3.입력된 값이 있을 경우            	
			            } else {          	
			            	$args->count = $output->data->count + 1;             	
			            	$output = $oAnalysisModel->updateAnalysisSearchWord($args);			            	
			            }
					}
					
					// analysis_log의 search_word_analyze_yn값을 Y로 변경
					$args->search_word_analyze_yn = 'Y';
					$args->analysis_log_srl = $val->analysis_log_srl;
					$output = $oAnalysisModel->updateAnalysisLog($args);	
                }
        	}
        	
        	// filter로 넘겨줄 값설정
            $this->setMessage('success_analyze_search_word');
            //$this->add('ret_act', $args->ret_act);
        }
    	
    	/**
         * @brief 
         **/
        function procAnalysisAdminAnalyzeBrowser() {
            $oAnalysisModel = &getAdminModel('analysis');
            
            // form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
			// analysis_log 에서 데이터 가져오기
			$args->searchword_analyze_yn = 'N';
			$output = $oAnalysisModel->getAnalysisLogListAll($args);

            if($output->data) {
				foreach($output->data as $key=>$val) {
					// search_word값이 있을 경우
					if($val->user_agent!=null){					
						// 1.analysis_browser에 입력된 값이 있는지 검사
						$args->browser = $val->user_agent;
						$output = $oAnalysisModel->getAnalysisBrowser($args);						
						// 2.입력된 값이 없을 경우
			            if($output->data==null){
			            	$args->count = 1;
			            	$output = $oAnalysisModel->insertAnalysisBrowser($args);			            	
			            // 3.입력된 값이 있을 경우            	
			            } else {          	
			            	$args->count = $output->data->count + 1;             	
			            	$output = $oAnalysisModel->updateAnalysisBrowser($args);			            	
			            }
					}
					
					// analysis_log의 searchword_analyze_yn값을 Y로 변경
					$args->browser_analyze_yn = 'Y';
					$args->analysis_log_srl = $val->analysis_log_srl;
					$output = $oAnalysisModel->updateAnalysisLog($args);					
                }
        	}
        	
        	// filter로 넘겨줄 값설정
            $this->setMessage('success_analyze_browser');
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief 
         **/
        function procAnalysisAdminAnalyzeFavoriteDocument() {
            $oAnalysisModel = &getAdminModel('analysis');
            
            // form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
			// analysis_log 에서 데이터 가져오기
			$args->favorite_document_analyze_yn = 'N';
			$output = $oAnalysisModel->getAnalysisLogListAll($args);

            if($output->data) {
				foreach($output->data as $key=>$val) {
					// search_word값이 있을 경우
					if($val->document_srl!=null){					
						// 1.analysis_browser에 입력된 값이 있는지 검사
						$args->document_srl = $val->document_srl;
						$output = $oAnalysisModel->getAnalysisFavoriteDocument($args);						
						// 2.입력된 값이 없을 경우
			            if($output->data==null){
			            	$args->count = 1;
			            	$output = $oAnalysisModel->insertAnalysisFavoriteDocument($args);			            	
			            // 3.입력된 값이 있을 경우            	
			            } else {          	
			            	$args->count = $output->data->count + 1;             	
			            	$output = $oAnalysisModel->updateAnalysisFavoriteDocument($args);			            	
			            }
					}
					
					// analysis_log의 favorite_document_analyze_yn값을 Y로 변경
					$args->favorite_document_analyze_yn = 'Y';
					$args->analysis_log_srl = $val->analysis_log_srl;
					$output = $oAnalysisModel->updateAnalysisLog($args);					
                }
        	}
        	
        	// filter로 넘겨줄 값설정
            $this->setMessage('success_analyze_favorite_document');
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief 
         **/
        function procAnalysisAdminAnalyzeFavoriteMenu() {
            $oAnalysisModel = &getAdminModel('analysis');
            
            // form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars();
            
			// analysis_log 에서 데이터 가져오기
			$args->favorite_menu_analyze_yn = 'N';
			$output = $oAnalysisModel->getAnalysisLogListAll($args);

            if($output->data) {
				foreach($output->data as $key=>$val) {
					// search_word값이 있을 경우
					if($val->mid!=null){					
						// 1.analysis_browser에 입력된 값이 있는지 검사
						$args->mid = $val->mid;
						$output = $oAnalysisModel->getAnalysisFavoriteMenu($args);						
						// 2.입력된 값이 없을 경우
			            if($output->data==null){
			            	$args->count = 1;
			            	$output = $oAnalysisModel->insertAnalysisFavoriteMenu($args);			            	
			            // 3.입력된 값이 있을 경우            	
			            } else {          	
			            	$args->count = $output->data->count + 1;             	
			            	$output = $oAnalysisModel->updateAnalysisFavoriteMenu($args);			            	
			            }
					}

					// analysis_log의 favorite_menu_analyze_yn값을 Y로 변경
					$args->favorite_menu_analyze_yn = 'Y';
					$args->analysis_log_srl = $val->analysis_log_srl;
					$output = $oAnalysisModel->updateAnalysisLog($args);					
                }
        	}
        	
        	// filter로 넘겨줄 값설정
            $this->setMessage('success_analyze_favorite_menu');
            $this->add('ret_act', $args->ret_act);
        }

        /**
         * @brief 
         **/
        function procAnalysisAdminGetRefererLog() {
			
        	// 객체생성
    		$oAnalysisAdminModel = &getAdminModel('analysis');
    		$oAnalysisModel = &getModel('analysis');
    		$oAnalysisController = &getController('analysis');
			
    		// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // referer_log에서 데이터를 가져온다.
            $outputRefererLog = $oAnalysisAdminModel->getRefererLogListAll($args);

            foreach($outputRefererLog->data as $key=>$val) {
            	$referer_host = $val->host;
	            $referer_url = $val->url;
	            
            	// analysis_log에서 데이터를 가져온다.
	            $argsAnalysisLog->referer_url = $referer_url;
	            $argsAnalysisLog->referer_log_yn = "Y";
	            $outputAnalysisLog = $oAnalysisAdminModel->getAnalysisLogListAll($argsAnalysisLog);

				// referer_log에서 가져온 데이터가 analysis_log에 없을 경우에만 입력한다.
            	if(!$outputAnalysisLog->data){
		            $search_word = $oAnalysisController->getSearchWord($referer_host, $referer_url);
	            
	            	// analysis_log
		            $args->analysis_log_srl = getNextSequence();
				    $args->referer_host  = $referer_host; 	 	
				    $args->referer_url   = $referer_url;
				    $args->search_word   = $search_word;
					$args->input_date    = $val->regdate;
					$args->referer_log_yn = "Y";
					$args->act = "";
		
		            $output = $oAnalysisModel->insertAnalysisLog($args);	            
            	}
            			            
	            // referer_log 를 삭제하기전에 백업한다.
	            $argsRefererLog->host = $referer_host;
	            $argsRefererLog->url = $referer_url;
	            $argsRefererLog->regdate = $val->regdate;
	            $output = $oAnalysisAdminModel->insertAnalysisBackupRefererLog($argsRefererLog);

	            // referer_log 를 삭제한다.
	            $output = $oAnalysisAdminModel->deleteRefererLog($argsRefererLog);	
            }

            // filter로 넘겨줄 값설정
            $this->setMessage('success_get_referer_log');
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief 
         **/
        function procAnalysisAdminReturnRefererLog() {
			
        	// 객체생성
    		$oAnalysisAdminModel = &getAdminModel('analysis');
    		$oAnalysisModel = &getModel('analysis');
    		$oAnalysisController = &getController('analysis');
			
    		// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // analysis_log에서 데이터를 가져온다.
            $args->referer_log_yn = "Y";
            $outputAnalysisLog = $oAnalysisAdminModel->getAnalysisLogListAll($args);

            foreach($outputAnalysisLog->data as $key=>$val) {
            	$args->host = $val->referer_host;
	            $args->url = $val->referer_url;
	            $args->regdate = $val->input_date;
	            
	            // referer_log에 입력한다.
	            $output = $oAnalysisAdminModel->insertRefererLog($args);

	            // 입력이 완료된 데이터를 삭제한다.
	            $argsAnalysisLog->analysis_log_srl = $val->analysis_log_srl;
	            $output = $oAnalysisAdminModel->deleteAnalysisLog($argsAnalysisLog);

            }

            // filter로 넘겨줄 값설정
            $this->setMessage('success_return_referer_log');
            $this->add('ret_act', $args->ret_act);
        }
        
    /**
         * @brief 
         **/
        function procAnalysisAdminInitAnalyze() {
			
        	// 객체생성
    		$oAnalysisAdminModel = &getAdminModel('analysis');
    		$oAnalysisModel = &getModel('analysis');
    		$oAnalysisController = &getController('analysis');
			
    		// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // analysis_domain 데이터를 삭제한다.
            $output = $oAnalysisAdminModel->deleteAnalysisDomain();

            // filter로 넘겨줄 값설정
            $this->setMessage('success_init_analyze');
            $this->add('ret_act', $args->ret_act);
        }
        
    	/**
         * @brief 
         **/
        function procAnalysisAdminInitAnalysisLog() {
			
        	// 객체생성
    		$oAnalysisAdminModel = &getAdminModel('analysis');
    		$oAnalysisModel = &getModel('analysis');
    		$oAnalysisController = &getController('analysis');
			
    		// form이나 get으로 요청이 들어온 변수를 할당한다.
            $args = Context::getRequestVars(); 

            // analysis_log 데이터를 삭제한다.
            $output = $oAnalysisAdminModel->deleteAnalysisLog();

            // filter로 넘겨줄 값설정
            $this->setMessage('success_init_analysis_log');
            $this->add('ret_act', $args->ret_act);
        }
    }
?>
