<?php
    /**
     * @class stopsmoking
     * @author jedison (master@xgenesis.org)
     * @version 0.1
     * @brief stopsmoking 모듈의 데이터를 이용하여 금연 현황을 출력
     **/

    class stopsmoking_status extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
        	// 모듈객체생성
        	$oStopsmokingModel = &getModel('stopsmoking');
        	$oMemberModel = &getModel('member');
        	
        	// 금연모듈에 설정된 금연그룹을 모두 가져온다.
            $module_info = $oStopsmokingModel->getModulesInfo();

            // 금연결심을 모두 가져온다.
			$output = $oStopsmokingModel->getDecisionListAll();
			$decision_list = $output->data;
			
			// 금연그룹이름
			$group01 = $oMemberModel->getGroup($module_info->group01);
			$group02 = $oMemberModel->getGroup($module_info->group02);
			$group03 = $oMemberModel->getGroup($module_info->group03);
			$group04 = $oMemberModel->getGroup($module_info->group04);
			$group05 = $oMemberModel->getGroup($module_info->group05);
			$group06 = $oMemberModel->getGroup($module_info->group06);
			$group07 = $oMemberModel->getGroup($module_info->group07);
			$group08 = $oMemberModel->getGroup($module_info->group08);
			$group09 = $oMemberModel->getGroup($module_info->group09);
			$group10 = $oMemberModel->getGroup($module_info->group10);
			$group11 = $oMemberModel->getGroup($module_info->group11);
			$group12 = $oMemberModel->getGroup($module_info->group12);
			$group13 = $oMemberModel->getGroup($module_info->group13);
			$group14 = $oMemberModel->getGroup($module_info->group14);
			$group15 = $oMemberModel->getGroup($module_info->group15);
			
			// 금연그룹별 회원수
			$group01_count = 0;
			$group02_count = 0;
			$group03_count = 0;
			$group04_count = 0;
			$group05_count = 0;
			$group06_count = 0;
			$group07_count = 0;
			$group08_count = 0;
			$group09_count = 0;
			$group10_count = 0;
			$group11_count = 0;
			$group12_count = 0;
			$group13_count = 0;
			$group14_count = 0;
			$group15_count = 0;
			
			// 금연결심이 1개일 경우
			if(count($output->data)==1){
				$stop_date = $output->data->stop_date;
			// 금연결심이 1개이상
			} else {
				foreach($output->data as $key => $val) {
					// 금연일수를 계산한다.
	            	$standardDateTime = date('Y-m-d H:i:s');
					$comparisonDateTime = zdate($val->stop_date,"Y-m-d H:i:s");
					$timer = $oStopsmokingModel->getDiffDateTime($standardDateTime,$comparisonDateTime);
					// 그룹정보를 가져온다.
					$group_info = $oStopsmokingModel->getGroup($timer, $module_info);
					
					// 가져온 그룹정보에 따라 금연그룹별 회원수를 카운트한다.
					if($module_info->group01 == $group_info->group_srl){
						$group01_count++;
					} else if($module_info->group02 == $group_info->group_srl){
						$group02_count++;
					} else if($module_info->group03 == $group_info->group_srl){
						$group03_count++;
					} else if($module_info->group04 == $group_info->group_srl){
						$group04_count++;
					} else if($module_info->group05 == $group_info->group_srl){
						$group05_count++;
					} else if($module_info->group06 == $group_info->group_srl){
						$group06_count++;
					} else if($module_info->group07 == $group_info->group_srl){
						$group07_count++;
					} else if($module_info->group08 == $group_info->group_srl){
						$group08_count++;
					} else if($module_info->group09 == $group_info->group_srl){
						$group09_count++;
					} else if($module_info->group10 == $group_info->group_srl){
						$group10_count++;
					} else if($module_info->group11 == $group_info->group_srl){
						$group11_count++;
					} else if($module_info->group12 == $group_info->group_srl){
						$group12_count++;
					} else if($module_info->group13 == $group_info->group_srl){
						$group13_count++;
					} else if($module_info->group14 == $group_info->group_srl){
						$group14_count++;
					} else if($module_info->group15 == $group_info->group_srl){
						$group15_count++;
					}
				}
			}
			
			Context::set('group01',$group01); Context::set('group01_count',$group01_count);
			Context::set('group02',$group02); Context::set('group02_count',$group02_count);
			Context::set('group03',$group03); Context::set('group03_count',$group03_count);
			Context::set('group04',$group04); Context::set('group04_count',$group04_count);
			Context::set('group05',$group05); Context::set('group05_count',$group05_count);
			Context::set('group06',$group06); Context::set('group06_count',$group06_count);
			Context::set('group07',$group07); Context::set('group07_count',$group07_count);
			Context::set('group08',$group08); Context::set('group08_count',$group08_count);
			Context::set('group09',$group09); Context::set('group09_count',$group09_count);
			Context::set('group10',$group10); Context::set('group10_count',$group10_count);
			Context::set('group11',$group11); Context::set('group11_count',$group11_count);
			Context::set('group12',$group12); Context::set('group12_count',$group12_count);
			Context::set('group13',$group13); Context::set('group13_count',$group13_count);
			Context::set('group14',$group14); Context::set('group14_count',$group14_count);
			Context::set('group15',$group15); Context::set('group15_count',$group15_count);
			
            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            $tpl_file = 'stopsmoking_status';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>
