<?php
    /**
     * @class  pipingxeAdminView
     * @author zirho (zirho6@gmail.com)
     * @brief  pipingxe admin view class
     **/

    class pipingxeAdminView extends pipingxe {

        function init() {

            // set template location
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
            $this->setTemplateFile(str_replace('dispPipingxeAdmin','',$this->act));
        }

        function dispPipingxeAdminIndex() {

            $args->page = Context::get('page');
            $args->list_count = 20;
            $args->page_count = 10;
			
            $PipingtModel = &getModel('pipingxe');
			$output = $PipingtModel->getPipingxeList($args);

            // 템플릿에 쓰기 위해서 context::set
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('board_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
			
            Context::set('pipingxe_list', $output->data);

		}
		
		function in_array_with_valname ($array, $value, $valname) {

			foreach($array as $val){
				if($val->{$valname} == $value) return true;
			}
			
			return false;
		}

        function transWidget($buff) {
            $oXmlParser = new XmlParser();
            $xml_doc = $oXmlParser->parse(trim($buff));
            return $xml_doc;
        }

        function dispPipingxeAdminImport() {

			$oMenuAdminModel = &getAdminModel('menu');
			$menus = $oMenuAdminModel->getMenus();
			Context::set('menus', $menus);

			$oPipingModel = &getModel('pipingxe');
            $pipingxe_srl = Context::get('pipingxe_srl');
            if($pipingxe_srl) {
                $pipingxe_info = $oPipingModel->getPipingxeInfoByPipingxeSrl($pipingxe_srl);
			}	
            Context::set('pipingxe_info',$pipingxe_info);
        }

        function dispPipingxeAdminInsert() {

			$oMenuAdminModel = &getAdminModel('menu');
			$menus = $oMenuAdminModel->getMenus();
			Context::set('menus', $menus);

			$oPipingModel = &getModel('pipingxe');
            $pipingxe_srl = Context::get('pipingxe_srl');
            if($pipingxe_srl) {
                $pipingxe_info = $oPipingModel->getPipingxeInfoByPipingxeSrl($pipingxe_srl);
			}	
            Context::set('pipingxe_info',$pipingxe_info);
        }

        function dispPipingxeAdminDelete($args = null) {
			
			$args->pipingxe_srl = Context::get('pipingxe_srl');
			if(!$args->pipingxe_srl) return $this->dispPipingxeAdminContent();
			$output = executeQuery('pipingxe.getPipingxeList', $args);
			if(!$output->toBool()) return $output;

			$pipingxe_info = $output->data[1];
			if(!$pipingxe_info) return;
            Context::set('pipingxe_info', $pipingxe_info);

			$oMenuAdminModel = &getAdminModel('menu');
			$menu_info = $oMenuAdminModel->getMenu($pipingxe_info->menu_srl);
			Context::set('menu_info', $menu_info);
			
        }
    }
?>