<?php
    /**
     * @class  pipingxe Model
     * @author zirho (zirho6.gmail.com)
     * @brief  pipingxe  View class
     **/

    class pipingxeView extends pipingxe {

        function init() {
            // set template location
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
            $this->setTemplateFile(str_replace('dispPipingxe','',$this->act));

			$this->setLayoutPath(sprintf("%stpl/",$this->module_path));
			$this->setLayoutFile('layout');
        }

		//only for testing
        function dispPipingxeExportTest() {
			$menu_srl = Context::get('menu_srl');

			// get site info
			$oPipingxeModel = &getModel('pipingxe');
			$component_info = $oPipingxeModel->getPipingxeExtractInfo($menu_srl);

			// get list config

			$oBoardModel = &getModel('board');

			foreach($component_info->modules as $val){
				if($val->module == 'board'){
					
					//ddd('do module');
					$listconfig = $oBoardModel->getListConfig($val->module_srl);
					//ddd(array_keys($listconfig));
					$val->listconfig = $listconfig;
				}
			}

			//ddd($component_info->modules);

			require_once 'lib/Serializer.php';
			$options = array(
								XML_SERIALIZER_OPTION_INDENT      => '    ',
								XML_SERIALIZER_OPTION_LINEBREAKS  => "\n",
								XML_SERIALIZER_OPTION_TYPEHINTS   => true
							);

			$serializer = &new XML_Serializer($options);
			$result = $serializer->serialize($component_info);
			if( $result === true ) {
				$xml = $serializer->getSerializedData();
				Context::set('xml', $xml);
			}

			//set response as xml format
            Context::setResponseMethod("XMLRPC");
        }
		
		//export all data on menu srl and show in XML form
		//core function for pipingxe
        function dispPipingxeExportAll() {
			$pipingxe_srl = Context::get('ppid');

			// get site info
			$oPipingxeModel = &getModel('pipingxe');
			$component_info = $oPipingxeModel->getPipingxeExtractInfo($pipingxe_srl);

			//prepare serializing
			require_once 'lib/Serializer.php';
			//set options
			$options = array(
								XML_SERIALIZER_OPTION_INDENT      => '    ',
								XML_SERIALIZER_OPTION_LINEBREAKS  => "\n",
								XML_SERIALIZER_OPTION_TYPEHINTS   => true
							);
			//do serializing
			$serializer = &new XML_Serializer($options);
			$result = $serializer->serialize($component_info);
			if( $result === true ) {
				$xml = $serializer->getSerializedData();
				Context::set('xml', $xml);
			}

			//set response as xml format
            Context::setResponseMethod("XMLRPC");
        }

        function dispPipingxeExport() {

			//set response as xml format
            Context::setResponseMethod("XMLRPC");

			$pipingxe_srl = Context::get('ppid');

			// get site info
			$oPipingxeModel = &getModel('pipingxe');
			$component_info = $oPipingxeModel->getPipingxeComponentsInfo($pipingxe_srl);

			if(!$component_info){
				Context::set('xml', '');
				return;
			}

			require_once 'lib/Serializer.php';
			
			$options = array(
								XML_SERIALIZER_OPTION_INDENT      => '    ',
								XML_SERIALIZER_OPTION_LINEBREAKS  => "\n",
								XML_SERIALIZER_OPTION_TYPEHINTS   => true
							);

			$serializer = &new XML_Serializer($options);
			$result = $serializer->serialize($component_info);
			if( $result === true ) {
				$xml = $serializer->getSerializedData();
				Context::set('xml', $xml);
			} else {
			}
		}

        function dispPipingxeList() {

            $PipingtModel = &getModel('pipingxe');
			$output = $PipingtModel->getPipingxeList();
			if(!$output->toBool()) return;

			$pipingxe_list = $output->data;

			Context::set('pipingxe_list', $pipingxe_list);
		}

		function dispPipingxeSummary(){
			$pipingxe_srl = Context::get('pipingxe_srl');
			
			// get site info
			$oPipingxeModel = &getModel('pipingxe');
			$component_info = $oPipingxeModel->getPipingxeComponentsInfo($pipingxe_srl);
			$piping_info = $oPipingxeModel->getPipingxeInfoByPipingxeSrl($pipingxe_srl);

			Context::set('piping_info', $piping_info);
			Context::set('component_info', $component_info);
            $this->setLayoutPath('common/tpl/');
            $this->setLayoutFile('default_layout');
		}

		function dispPipingxeDone(){
			$pipingxe_srl = Context::get('ppid');
            // get data
            $args->pipingxe_srl = $pipingxe_srl;
            executeQuery('pipingxe.updatePipingxeDone', $args);
		}
	}
?>