<?php
    /**
     * @class  pipingxe Model
     * @author zirho (zirho6.gmail.com)
     * @brief  pipingxe  model class
     **/

    class pipingxeModel extends pipingxe {

        /**
         * @brief ʱȭ
         **/
        function init() {
        }

        function getPipingxeXML($preview_url) {

			$url_info = parse_url($preview_url);
			if(!$url_info['port']) $url_info['port'] = 80;
			if(!$url_info['path']) $url_info['path'] = '/';

			$fd = @fsockopen($url_info['host'], $url_info['port']);
			if(!$fd) return new Object(-1,'msg_no_xml_file');

			$header = sprintf("GET %s?%s HTTP/1.0\r\nHost: %s\r\nReferer: %s://%s\r\nConnection: Close\r\n\r\n", $url_info['path'], $url_info['query'], $url_info['host'], $url_info['scheme'], $url_info['host']);

			@fwrite($fd, $header);
			$buff = '';

			while(!feof($fd)) {
				$buff .= $str = fgets($fd, 1024);
				if(!trim($str)) break;
			}

			while(!feof($fd)) {
				$contents .= $str = fgets($fd, 1024);
			}

			return $contents;
        }

        /**
         * @brief duplication check on source server
         **/
        function getPipingxeImportDuplCheck() {
			//get mid
            $mid = Context::get('mid');
			
			$oModuleModel = &getModel('module');
			$module_info = $oModuleModel->getModuleInfoByMid($mid);
			if($module_info) $dupl = TRUE; else $dupl = FALSE;

			$this->add('dupl',$dupl);
        }

        /**
         * @brief Import MIDs contains mids on source server
         **/
        function getPipingxeImportMIDs() {
			//get source server mids
            $preview_url = Context::get('preview_url');
			$preview_url = str_replace("dispPipingxeExport","dispPipingxeExportAll",$preview_url);
			$contents = $this->getPipingxeXML($preview_url);
			
			require_once 'lib/Unserializer.php';
			$unserializer = &new XML_Unserializer();
			$result = $unserializer->unserialize($contents);    

			if( $result === true ) {
				$component_info = $unserializer->getUnserializedData();
				$component_info = $component_info['stdClass'];

				Context::set('component_modules', $component_info->modules);
				
				//check if each MID exists on destination server
				foreach($component_info->modules as $module)
				{
					$oModuleModel = &getModel('module');
					$module_info = $oModuleModel->getModuleInfoByMid($module->mid);
					if($module_info) $module->have = TRUE; else $module->have = FALSE;
				}
			}

            $oTemplate = &TemplateHandler::getInstance();
            $tpl = $oTemplate->compile($this->module_path.'tpl', 'ImportMIDs');
            $this->add('tpl', str_replace(array("\r\n", "\n", "\r", "\t")," ",$tpl));
        }

        /**
         * @brief Import Preview contains result of comparison of components both source and destination
         **/
        function getPipingxeImportPreview() {
            $preview_url = Context::get('preview_url');
			$contents = $this->getPipingxeXML($preview_url);
			
			require_once 'lib/Unserializer.php';
			$unserializer = &new XML_Unserializer();
			$result = $unserializer->unserialize($contents);    

			if( $result === true ) {
				$component_info = $unserializer->getUnserializedData();
				$component_info = $component_info['stdClass'];
				if(!$component_info) 
					$this->add('result', 'error');
			}
			//get downloaded stuff 
			$oWidgetModel = &getModel('widget');
			$oLayoutModel = &getModel('layout');
			$oModuleModel = &getModel('module');
			$dn_widget_list = $oWidgetModel->getDownloadedWidgetList();
			$dn_widget_style_list = $oWidgetModel->getDownloadedWidgetStyleList();
			$dn_layout_list = $oLayoutModel->getDownloadedLayoutList();
			$dn_module_list = $oModuleModel->getModuleList();
			
			$ready = TRUE;

			//check if destination server has modules needed
			if($component_info->modules)
			foreach($component_info->modules as $val_module){
				$val_module->have = $this->in_array_with_valname($dn_module_list, $val_module->module, 'module');
				$ready &= $val_module->have;
				if($val_module->have && $val_module->skins){
					$module_path = ModuleHandler::getModulePath($val_module->module);
					$skin_list = array_keys($oModuleModel->getSkins($module_path));
					foreach($val_module->skins as $val_skin){
						$val_skin->have = in_array($val_skin->skin, $skin_list);
						$ready &= $val_skin->have;
					}
				}
			}

			//check if destination server has widgets needed
			if($component_info->widgets)
			foreach($component_info->widgets as $val_widget){
				$val_widget->have = $this->in_array_with_valname($dn_widget_list, $val_widget->widget, 'widget');
				$ready &= $val_widget->have;
				
				if($val_widget->have && $val_widget->skins){
					$widget_path = sprintf('./widgets/%s/', $val_widget->widget);
					$skin_list = array_keys($oModuleModel->getSkins($widget_path));
						
					foreach($val_widget->skins as $val_skin){
						$val_skin->have = in_array($val_skin->skin, $skin_list);
						$ready &= $val_skin->have;
					}
				}
			}

			//check if destination server has widget_styles needed
			if($component_info->widget_styles)
			foreach($component_info->widget_styles as $val_widget_style){
				$val_widget_style->have = $this->in_array_with_valname($dn_widget_style_list, $val_widget_style->widget_style, 'widgetStyle');
				$ready &= $val_widget_style->have;
			}

			//check if destination server has layouts needed
			if($component_info->layouts)
			foreach($component_info->layouts as $val_layout){
				$val_layout->have = $this->in_array_with_valname($dn_layout_list, $val_layout->layout, 'layout');
				$ready &= $val_layout->have;
			}

			Context::set('ready', $ready);
			Context::set('component_info', $component_info);

			$oTemplate = &TemplateHandler::getInstance();
			$tpl = $oTemplate->compile($this->module_path.'tpl', 'ImportPreview');
			$this->add('tpl', str_replace(array("\r\n", "\n", "\r", "\t")," ",$tpl));
        }
		
		function in_array_with_valname ($array, $value, $valname) {

			foreach($array as $val){
				if($val->{$valname} == $value) return true;
			}
			
			return false;
		}

        function getPipingxeComponentsInfo($pipingxe_srl) {

			$site_info = $this->getPipingxeExtractInfo($pipingxe_srl);
			if(!$site_info) return null;
			// get components information 
			foreach($site_info->modules as $module){ 
				$modules[$module->module]->module = $module->module;
				if($module->module == 'page') continue;
				$modules[$module->module]->skins[$module->skin]->skin = $module->skin;
			}

			foreach($site_info->layouts as $layout){
				$layouts[$layout->layout]->layout = $layout->layout;
			}

			foreach($site_info->widgets as $widget){ 
				if($widget->img->attrs->widget == 'widgetContent') continue;
				$widgets[$widget->img->attrs->widget]->widget = $widget->img->attrs->widget;
				$widgets[$widget->img->attrs->widget]->skins[$widget->img->attrs->skin]->skin = $widget->img->attrs->skin;
			}

			foreach($site_info->widget_styles as $widget_style){ 
				$widget_styles[$widget_style]->widget_style = $widget_style;
			}

			$component_info->modules = $modules;
			$component_info->layouts = $layouts;
			$component_info->widgets = $widgets;
			$component_info->widget_styles = $widget_styles;

			return $component_info;
		}
		
		//extract all information needed for importing
		//pipingxe core function
        function getPipingxeExtractInfo($pipingxe_srl) {
			
			$pipingxe_info = $this->getPipingxeInfoByPipingxeSrl($pipingxe_srl);
			//ddd($pipingxe_info);
			if(!$pipingxe_info) return null;

			//get piping target menu info
            $oMenuAdminModel = &getAdminModel('menu');
			$menu = $oMenuAdminModel->getMenu($pipingxe_info->menu_srl);
			if(file_exists($menu->php_file)) @include($menu->php_file);

			//get module info to export
			$modules = array();
			$documents = array();
			$layouts = array();
			$widgets = array();
			$widget_styles = array();

			//for board categories
			$oDocumentModel = &getModel('document');
			//for listconfig
			$oBoardModel = &getModel('board');
			//for getting module info
			$oModuleModel = &getModel('module');

			//for layouts
            $oLayoutModel = &getModel('layout');
			$oTemplate = &TemplateHandler::getInstance();
			
			//call recursive function to extract multi-layered items
			$this->extractMenuData($oModuleModel, $oDocumentModel, $oBoardModel, $oLayoutModel, $oTemplate, $menu->list, &$documents, &$modules, &$layouts, &$widgets, &$widget_styles);

			$pipingXE->menu = $menu;
			$pipingXE->modules = $modules;
			$pipingXE->documents = $documents;
			$pipingXE->widgets = $widgets;
			$pipingXE->widget_styles = $widget_styles;
			$pipingXE->layouts = $layouts;
			$pipingXE->root_url = Context::getDefaultUrl();

			return $pipingXE;
		}

		//recursive function for each menu item (extracting modules widgets layouts)
		function extractMenuData($oModuleModel, $oDocumentModel, $oBoardModel, $oLayoutModel, $oTemplate, $menu_items, $documents, $modules, $layouts, $widgets, $widget_styles){
			
			foreach($menu_items as $menu_item){

				//get all module info linked to the menu
				$module_info_temp = $oModuleModel->getModuleInfoByMid($menu_item['url']);

				if($module_info_temp) {
							
					//get extra information for board modules
					if($module_info_temp->module == 'board'){

						//do categories
						$categories = $oDocumentModel->getCategoryList($module_info_temp->module_srl);
						$module_info_temp->categories = $categories;

						//do extra keys
						$extrakeys = $oDocumentModel->getExtraKeys($module_info_temp->module_srl);
						foreach($extrakeys as $ext_key => $ext_val){
							$ext_val->value = null;
							$extrakeys[$ext_key] = $this->arrayToObject((array)$ext_val);
						}
						$module_info_temp->extrakeys = $extrakeys;

						//do listconfig
						$listconfig = $oBoardModel->getListConfig($module_info_temp->module_srl);
						$module_info_temp->listconfig = array_keys($listconfig);

						//do skin vars
						$skinvars = $oModuleModel->getModuleSkinVars($module_info_temp->module_srl);
						$module_info_temp->skinvars = $skinvars;
					}

					//get document_srls for page modules
					if($module_info_temp->module == 'page'){
						//find "widgetContent" document_srl
						preg_match_all("/document_srl=\"[[:digit:]]+\"/", $module_info_temp->content, $doc_matches);
						foreach($doc_matches[0] as $doc_val){
							//find document_srl
							preg_match_all("/[[:digit:]]+/", $doc_val, $doc_matches2);
							//get document_data
							$documents[$doc_matches2[0][0]] = $oDocumentModel->getDocument($doc_matches2[0][0]);
						}
					}					

					$modules[] = $module_info_temp;

					//get layout info to export from module info
					//this can be two or more					
					if($module_info_temp->layout_srl > 0 
						&& !$layouts[$module_info_temp->layout_srl]) {

						$layout_srl = $module_info_temp->layout_srl;
						$layout_info = $oLayoutModel->getLayout($layout_srl);
						$layouts[$module_info_temp->layout_srl] = $layout_info;

						//get widget info (widget name and skin name) in layout
						$layout_path = $oLayoutModel->getUserLayoutPath($layout_srl);
						if(!file_exists(sprintf("%slayout.html", $layout_path))){
							$layout_path = $layout_info->path;
						} 

						$layout_file = "layout";
						//find widgets in layout
						$layout_html = $oTemplate->compile($layout_path, $layout_file, '');
						preg_match_all('!<img([^\>]*)widget=([^\>]*?)\>!is', $layout_html, $widgets_temp);
						
						//stack widget info
						foreach($widgets_temp[0] as $widget_item){
							$xml_doc = $this->transWidget($widget_item);
							$widgets[] = $xml_doc;
							if($xml_doc->img->attrs->widgetstyle) $widget_styles[] = $xml_doc->img->attrs->widgetstyle;
						}
						
						//unset variables to reuse
						unset($layout_srl);
						unset($layout_info);
						unset($layout_path);
						unset($layout_file);
						unset($layout_html);
					}
					
					//get widget info (widget name and skin name) in page contents
					if($module_info_temp->module == 'page'){
						preg_match_all('!<img([^\>]*)widget=([^\>]*?)\>!is', $module_info_temp->content, $widgets_temp);

						foreach($widgets_temp[0] as $widget_item){
							$xml_doc = $this->transWidget($widget_item);
							$widgets[] = $xml_doc;
							if($xml_doc->img->attrs->widgetstyle) $widget_styles[] = $xml_doc->img->attrs->widgetstyle;
						}
					}
				}

				if(is_array($menu_item['list'])){
					$this->extractMenuData($oModuleModel, $oDocumentModel, $oBoardModel, $oLayoutModel, $oTemplate, $menu_item['list'], &$documents, &$modules, &$layouts, &$widgets, &$widget_styles);
				}
			}
		}
		
		//helper function for ExtraItem to stdClass
		function arrayToObject($array) {
			if(!is_array($array)) return $array;			
			$object = new stdClass();
			if (is_array($array) && count($array) > 0) {
				foreach ($array as $name=>$value) {
					$name = strtolower(trim($name));
					if (!empty($name)) $object->{$name} = $value;
				}
				return $object; 
			}
			else return FALSE;
		}

        function transWidget($buff) {
            $oXmlParser = new XmlParser();
            $xml_doc = $oXmlParser->parse(trim($buff));
            return $xml_doc;
        }

        function getPipingxeList($args = null) {
			if($args && $args->pipingxe_srl) {
				return $this->getPipingxeInfoByPipingxeSrl($args->pipingxe_srl);
			} else {
				$args->page = 1;
				$args->list_count = 99999;
				$args->page_count = 1;
				$output = executeQuery('pipingxe.getPipingxeList', $args);

				if(!$output->toBool()) return $output;
				else return $output;
			}
		}

        function getPipingxeInfoByPipingxeSrl($pipingxe_srl) {
            // get data
            $args->pipingxe_srl = $pipingxe_srl;
            $output = executeQuery('pipingxe.getPipingxeInfo', $args);
			//ddd($output);
			if(!$output->toBool()) return false;
			else return $output->data[1];
		}
	}
?>