<?php
    /**
     * @class  pipingxeAdminController
     * @author zirho (zirho6@gmail.com)
     * @brief  pipingxe  admin controller class
     **/

    class pipingxeAdminController extends pipingxe {

        /**
         * @brief init
         **/
        function init() {
        }
		
		function insertingMenus($mid_map, $srl_map, $menu_list, $new_srl, $menuAdminController){
			
			foreach($menu_list as $key => $val){
				Context::set('menu_srl', $new_srl, true);
				Context::set('menu_item_srl', getNextSequence(), true);
				//replace mid to be organized
				if($srl_map[$val['parent_srl']]) Context::set('parent_srl', $srl_map[$val['parent_srl']], true);
				else Context::set('parent_srl', $val['parent_srl'], true);
				Context::set('menu_name', $val['text'], true);
				//replace mid to be organized
				if($mid_map[$val['url']]) 
					Context::set('menu_url', str_replace($val['url'], $mid_map[$val['url']]->new_mid, $val['url']) , true);
				else Context::set('menu_url', $val['url'], true);
				Context::set('menu_open_window', $val['open_window'], true);
				Context::set('menu_expand', $val['expand'], true);
				Context::set('normal_btn', $val['normal_btn'], true);
				Context::set('hover_btn', $val['hover_btn'], true);
				Context::set('active_btn', $val['active_btn'], true);
				$menuAdminController->procMenuAdminInsertItem();
				
				//$val['new_srl'] = $menuAdminController->get('menu_item_srl');
				//$menu_list[$key] = $val;
				$srl_map[$key] = $menuAdminController->get('menu_item_srl');
	
				//recursive menu creation
				if(is_array($val['list'])) $this->insertingMenus($mid_map, &$srl_map, $val['list'], $new_srl, $menuAdminController);
			}
		}

		// import piping data (making new website)
		function procPipingxeAdminImport(){
			
			//create map for mids changed
            $args = Context::getRequestVars();
			unset($args->preview_url);
			unset($args->module);
			unset($args->act);
			$mid_map = array();
			$srl_map = array();

			foreach($args as $key => $val){
				
				if(!$this->endsWith($key, '_srl')) {
					$mid_map[$key]->new_mid = $val;
					$mid_map[$key]->old_srl = $args->{$key.'_srl'};
				}
			}

			//get source server mids
            $oPipingxeModel = &getModel('pipingxe');
            $count_url = Context::get('count_url');
			$oPipingxeModel->getPipingxeXML($count_url);

            $preview_url = Context::get('preview_url');
			$preview_url = str_replace("dispPipingxeExport","dispPipingxeExportAll",$preview_url);
			$contents = $oPipingxeModel->getPipingxeXML($preview_url);
			require_once 'lib/Unserializer.php';
			$unserializer = &new XML_Unserializer();
			$result = $unserializer->unserialize($contents);   

			if( $result === true ) {
				$component_info = $unserializer->getUnserializedData();
				$component_info = $component_info['stdClass'];
				$rooturl = $component_info->root_url;
				//ddd($component_info);

				//0-0 make new menu
				$menu = $component_info->menu;

				Context::set('title', $menu->title);
				$menuAdminController = &getAdminController('menu');
				$menuAdminController->procMenuAdminInsert();
				$menu->new_srl = $menuAdminController->get('menu_srl');

				//0-1 make new menu items
				$this->insertingMenus($mid_map, &$srl_map, $menu->list, $menu->new_srl, $menuAdminController);

				//1-0 make new layout
				$layouts = $component_info->layouts;

				foreach($layouts as $key => $val){

					//1-1 insert layout
					Context::set('layout', $val->layout, true);
					Context::set('title', $val->title, true);
					Context::set('layout_type', $val->layout_type, true);
					$layoutAdminController = &getAdminController('layout');
					$layoutAdminController->procLayoutAdminInsert();
					$srl_map[$val->layout_srl] = $layoutAdminController->get('layout_srl');

					//1-2 update extra vars and menus
					foreach($val->menu as $key2 => $val2){
						$extra_vars->{$key2} = $menu->new_srl;
					}

					//1-3 image process 
					foreach($val->extra_var as $key2 => $val2){
						if($val2->type == 'image'){
							$source_url = $rooturl.$val2->value;
							$dest_location = $this->insertAttachedFileLayout($source_url, $srl_map[$val->layout_srl]);
							$extra_vars->{$key2} = $dest_location;
						}
					}
					
					$layout_args->layout_srl = $srl_map[$val->layout_srl];
					$layout_args->extra_vars = serialize($extra_vars);
					$output = $layoutAdminController->updateLayout($layout_args);

					//1-4 update layout later for mids changed
					$layout_needed_update[$layout_args->layout_srl]->extra_vars_from = $val->extra_var;
					$layout_needed_update[$layout_args->layout_srl]->extra_vars_to = $extra_vars;
				}

				//2-0 make modules
				$modules = $component_info->modules;
				$documents = $component_info->documents;

				$boardAdminController = &getAdminController('board');

				//make instances of model/controller 
				//for board list config 
				$oModuleController = &getController('module');
				$oModuleModel = &getModel('module');
				//for category, extrakey, inserting documents
				$oDocumentController = &getController('document');
				//for documentItem to stdClass
				$oPipingxeModel = &getModel('pipingxe');

				//2-1 make boards
				//do for board modules
				foreach($modules as $key => $val){
					//init for replacing srl
					$category_srl_map = array();

					if($val->module == 'board') {
						
						//clone the values
						$args = clone($val);

						//init module info to make
						$args->mid = $mid_map[$val->mid]->new_mid;
						$args->layout_srl = $srl_map[$args->layout_srl];
						unset($args->module_srl);

						if($args->use_category!='Y') $args->use_category = 'N';
						if($args->except_notice!='Y') $args->except_notice = 'N';
						if($args->use_anonymous!='Y') $args->use_anonymous= 'N';
						if($args->consultation!='Y') $args->consultation = 'N';
						if(!in_array($args->order_target,$boardAdminController->order_target)) $args->order_target = 'list_order';
						if(!in_array($args->order_type,array('asc','desc'))) $args->order_type = 'asc';
						
						//2-1-0 insert boards
						//do inserting module
						$output = $oModuleController->insertModule($args); 
						
						//skip on error
						if(!$output->toBool()) continue;//return $output;
						$srl_map[$val->module_srl] = $output->get('module_srl');

						//2-1-1 insert board categories
						if($val->categories)
						foreach($val->categories as $cate_val){
							//clone the values
							$cate_temp = clone($cate_val);
							//init category data
							unset($cate_val->category_srl);
							$cate_val->module_srl = $srl_map[$val->module_srl];
							$cate_val->parent_srl ? $category_srl_map[$cate_val->parent_srl] : $cate_val->parent_srl;
							$cate_output = $oDocumentController->insertCategory($cate_val);
							$category_srl_map[$cate_temp->category_srl] = $cate_output->get('category_srl');
							
							//dispose
							unset($cate_temp);
							unset($cate_output);
						}

						//2-1-2 insert board extrakeys
						if($val->extrakeys)
						foreach($val->extrakeys as $ext_val){
							//init extrakey data
							
							$ext_val->module_srl = $srl_map[$val->module_srl];
							$ext_output = $oDocumentController->insertDocumentExtraKey($ext_val->module_srl, $ext_val->idx, $ext_val->name, $ext_val->type, $ext_val->is_required, $ext_val->search, $ext_val->default, $ext_val->desc, $ext_val->eid);
							
							//skip on error
							if(!$ext_output->toBool()) continue; //return $output;
							
							//dispose
							unset($ext_output);
						}

						//2-1-3 do board list config
						if($val->listconfig && is_array($val->listconfig)){
				            $oModuleController->insertModulePartConfig('board', $srl_map[$val->module_srl], $val->listconfig);
						}

						//2-1-4 do board skin vars
						if($val->skinvars && is_array($val->skinvars)){

							foreach($val->skinvars as $skin_val){
								$skin_obj[$skin_val->name] = $skin_val->value;
							}

							$oModuleController->insertModuleSkinVars($srl_map[$val->module_srl], $skin_obj);
							unset($skin_val);
						}
					}

					//dispose
					unset($category_srl_map);
				}

				//2-2 make page modules
				foreach($modules as $key => $val){
					if($val->module == 'page') {

						//clone the values
						$args = clone($val);

						//init module info to make
						unset($args->module_srl);
						$args->mid = $mid_map[$val->mid]->new_mid;			
						$args->layout_srl = $srl_map[$args->layout_srl];

						//2-2-0 change old srls to new ones in contents of page
						//get srl-relative attributes
						preg_match_all("/[^ ]*srl[^ ]*/", $args->content, $matches);	
						$srl_matches = str_replace('%2C', ',' ,$matches[0]);	
						
						//2-2-1 **start to find things for srl replacing
						foreach($srl_matches as $key3 => $val3){
							//get old srls
							preg_match_all("/[[:digit:]]+/", $val3, $inner_srl_matches);
							//finding and saving matching srls
							foreach($inner_srl_matches[0] as $key2 => $val2){
								//if srl replacement exists, do save
								if($srl_map[$val2]) {
									//saving new srl
									$val2 = $srl_map[$val2];
									$inner_srl_matches[0][$key2] = $val2;
								}
							}
							
							//2-2-2 replacing *
							$val3 = preg_replace("/[[:digit:],]+/", implode(",", $inner_srl_matches[0]), $val3);	
							$srl_matches[$key3] = $val3;
						}
						
						//eliminate commas 
						$srl_matches = str_replace(',', '%2C' ,$srl_matches);
						
						//2-2-3 insert documents in pages
						$needed_module_srl_update = array();
						foreach($matches[0] as $key4 => $val4){
							//find "widgetContent" document_srl
							if(preg_replace("/[[:digit:],]+/", "", $val4) == 'document_srl=""'){
								preg_match("/[[:digit:]]+/", $val4, $doc_matches);
								//got document_srl
								if($documents[$doc_matches[0]]){
									$document = $oPipingxeModel->arrayToObject($documents[$doc_matches[0]]->variables);
									//2-2-4 insert document and get new document_srl
									$old_document_srl = $document->document_srl;
									unset($document->document_srl);
									$doc_output = $oDocumentController->insertDocument($document);
									
									$srl_map[$old_document_srl] = $doc_output->get('document_srl');
									//save this for module_srl update
									$needed_module_srl_update[] = $doc_output->get('document_srl');
									$srl_matches[$key4] = str_replace($old_document_srl, $srl_map[$old_document_srl], $val4);

									//2-2-5 insert attached files in page document
									preg_match_all("/files\/attach[^\"]*/", $document->content, $attach_matches);
									$attach_matches[0] = array_unique($attach_matches[0]);
									foreach($attach_matches[0] as $attach_val){
										//2-2-6 insert attached file
										$inserted_file = $this->insertAttachedFile($rooturl.$attach_val, $srl_map[$old_document_srl]);
										$uploaded_filename = $inserted_file->get('uploaded_filename');
										$uploaded_filename_arr = explode("/", $uploaded_filename);
										$uploaded_filename_arr[count($uploaded_filename_arr)-1] = rawurlencode($uploaded_filename_arr[count($uploaded_filename_arr)-1]);
										$uploaded_filename = substr(implode("/", $uploaded_filename_arr), 2);
										
										//2-2-7 replace attached file url
										$document->content = str_replace($attach_val, $uploaded_filename, $document->content);
										
										//update document content
										$attach_args->document_srl = $srl_map[$old_document_srl];
										$attach_args->content = $document->content;
										$attach_output = executeQuery('pipingxe.updateDocumentContent', $attach_args);
									}
								}
							}
						}

						//do replacing *
						foreach($matches[0] as $key4 => $val4){
							$args->content = str_replace($val4, $srl_matches[$key4] ,$args->content);
						}
						//**end srl replacing

						$output = $oModuleController->insertModule($args);
						if(!$output->toBool()) continue; //$output;
						
						//save new srl on map
						$srl_map[$val->module_srl] = $output->get('module_srl');

						//2-2-8 update module_srl on documents in pages
						$needed_args->module_srl = $srl_map[$val->module_srl];
						foreach($needed_module_srl_update as $doc_update_val){
							$needed_args->document_srl = $doc_update_val;
							$needed_output = executeQuery('pipingxe.updateDocumentModule', $needed_args);

							//update attached file data (update_target_srl, module_srl)
							$attached_output = executeQuery('pipingxe.updateFileSrls', $needed_args);
						}
						unset($needed_module_srl_update);
					}
				}

				//3-0 laytout update
				foreach($layout_needed_update as $layout_key => $layout_val){
					foreach($layout_val->extra_vars_from as $layout_key2 => $layout_val2){
						if($layout_val2->type != 'image'){
							if($mid_map[$layout_val2->value]){
								$layout_val->extra_vars_to->{$layout_key2} = $mid_map[$layout_val2->value]->new_mid;
							} else {
								$layout_val->extra_vars_to->{$layout_key2} = $layout_val2->value;
							}
						}
					}
					
					$layout_args->layout_srl = $layout_key;
					$layout_args->extra_vars = serialize($layout_val->extra_vars_to);
					$output = $layoutAdminController->updateLayout($layout_args);
				}
			}

            $this->add('piping_message',Context::getLang('done'));
            $this->add('url', getUrl());
			return;
        }

		//insert attached file in layout
		function insertAttachedFileLayout($target_file_path, $layout_srl){
			
            if(!file_exists(_XE_PATH_.'files/attach/images/'.$layout_srl)) FileHandler::makeDir(_XE_PATH_.'files/attach/images/'.$layout_srl);

			$file_name_arr = explode("/", $target_file_path);
			$file_name = $file_name_arr[count($file_name_arr)-1];
			$target_filename = rawurlencode($file_name_arr[count($file_name_arr)-1]);
			$file_name_arr[count($file_name_arr)-1] = $target_filename;
			$target_file_path = implode("/", $file_name_arr);
            $temp_file = _XE_PATH_.'files/attach/images/'.$layout_srl.'/'.$file_name;
			
            $oPipingxeModel = &getModel('pipingxe');
			$debug_output = $oPipingxeModel->getPipingxeXML($target_file_path);
            if(@!$fp = fopen($temp_file, 'wb')){ return; }
            fwrite($fp, $debug_output);
            fclose($fp);
			return str_replace(_XE_PATH_, './', $temp_file);
		}

		//insert attached file in document in page module
		function insertAttachedFile($target_file_path, $document_srl){
			
            if(!file_exists(_XE_PATH_.'files/pipingxe/')) FileHandler::makeDir(_XE_PATH_.'files/pipingxe/');

			$file_name_arr = explode("/", $target_file_path);
			$target_filename = rawurldecode($file_name_arr[count($file_name_arr)-1]);
            $temp_file = _XE_PATH_.'files/pipingxe/'.$target_filename;
			
            $oPipingxeModel = &getModel('pipingxe');
			$debug_output = $oPipingxeModel->getPipingxeXML($target_file_path);
            if(@!$fp = fopen($temp_file, 'wb')){ return; }
            fwrite($fp, $debug_output);
            fclose($fp);
			
			$file_info['name'] = $target_filename;
			$file_info['tmp_name'] = $temp_file;
            $oFileController = &getController('file');
            $inserted_file = $oFileController->insertFile($file_info, $document_srl, $document_srl, 0, true);
			
			//remove temp file
			if(file_exists($temp_file)) @unlink($temp_file);

			return $inserted_file;
		}
		
		//find haystack endswith needle
		//credit to : http://snipplr.com/view/13213/check-if-a-string-ends-with-another-string/
		function endsWith($haystack,$needle,$case=true) {
			if($case){return (strcmp(substr($haystack, strlen($haystack) - strlen($needle)),$needle)===0);}
			return (strcasecmp(substr($haystack, strlen($haystack) - strlen($needle)),$needle)===0);
		}
		
		// init module data
		function procPipingxeAdminInsertPipingxeData(){
			
			$oModuleModel = &getModel('module');
			$ouput = $oModuleModel->isIDExists($this->module);
			if(!$output){
				// module  pipingxe  Է
				$site_module_info = Context::get('site_module_info');
				$args->site_srl = $site_module_info->site_srl;
				$args->mid = $this->module;
				$args->module = $this->module;
				$args->browser_title = 'pipingxeXE';
				$args->open_rss = 'N';

				$oModuleController = &getController('module');
				$output = $oModuleController->insertModule($args);
			}
		}
		
		// insert/update pipingxe site open
        function procPipingxeAdminInsert() {
			
            $args = Context::getRequestVars();
            $oPipingxeController = &getController('pipingxe');
            $oPipingxeModel = &getModel('pipingxe');
			
			if($args->pipingxe_srl) {
                $pipingxe_info = $oPipingxeModel->getPipingxeInfoByPipingxeSrl($args->pipingxe_srl);
                if($pipingxe_info->pipingxe_srl != $args->pipingxe_srl) unset($args->pipingxe_srl);
            }

            // insert/update with pipingxe_srl
            if(!$args->pipingxe_srl) {
                $args->pipingxe_srl = getNextSequence();
                $output = $oPipingxeController->procPipingxeInsertPipingxe($args);
                $msg_code = 'success_registed';
                $pipingxe_info = $oPipingxeModel->getPipingxeInfoByPipingxeSrl($args->pipingxe_srl);
            } else {
                $output = $oPipingxeController->procPipingxeUpdatePipingxe($args);
                $msg_code = 'success_updated';
            }

			//ddd($args);
            if(!$output->toBool()) return $output;
            $this->add("pipingxe_srl", $args->pipingxe_srl);
            $this->setMessage($msg_code);

			$image_obj = $args->thumbnail;
			$old_file = $pipingxe_info->thumbnail;
            $del_var = $args->del_thumbnail;

			unset($args->title);
			unset($args->description);
			unset($args->menu_srl);
			unset($args->module);
			unset($args->act);

			if($del_var == 'Y' || $image_obj['tmp_name']) {
				FileHandler::removeFile($old_file);
				$args->thumbnail = '';
			} 

			if ( $image_obj['tmp_name'] && is_uploaded_file($image_obj['tmp_name']) 
				&& preg_match("/\.(jpg|jpeg|gif|png|swf)$/i", $image_obj['name'])) {

				$path = sprintf("./files/attach/images/%s/", $args->pipingxe_srl);
				if(!FileHandler::makeDir($path)) continue;
				$filename = $path.$image_obj['name'];
				if(!move_uploaded_file($image_obj['tmp_name'], $filename)) continue;
				$args->thumbnail = $filename;
			}

			$output = $oPipingxeController->procPipingxeUpdatePipingxe($args);

            Context::set('pipingxe_srl', $args->pipingxe_srl);
            Context::set('message', $this->getMessage());
            $this->setLayoutPath('./common/tpl');
            $this->setLayoutFile('default_layout.html');
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile("top_refresh.html");
        }
		
		// delete pipingxe site open
        function procPipingxeAdminDelete() {
			
			$args->pipingxe_srl = Context::get('pipingxe_srl');

            $oPipingxeController = &getController('pipingxe');
            $output = $oPipingxeController->procPipingxeDeletePipingxe($args);
            if(!$output->toBool()) return $output;
            $this->add('page',Context::get('page'));
            $this->setMessage('success_deleted');
        }
    }
?>