<?php
    /**
     * @class  pipingxeAdminView
     * @author zirho (zirho6@gmail.com)
     * @brief  pipingxe admin view class
     **/

    class pipingxeAdminView extends pipingxe {

        function init() {

            // set template location
            $template_path = sprintf("%stpl/",$this->module_path);
            $this->setTemplatePath($template_path);
            $this->setTemplateFile(str_replace('dispPipingxeAdmin','',$this->act));
        }

        function dispPipingxeAdminIndex() {

            $args->page = Context::get('page');
            $args->list_count = 20;
            $args->page_count = 10;
			
            $PipingtModel = &getModel('pipingxe');
			$output = $PipingtModel->getPipingxeList($args);
			//ddd($output);

            // 템플릿에 쓰기 위해서 context::set
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('board_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);
			
            Context::set('pipingxe_list', $output->data);

		}

        function dispPipingxeAdminExport2() {
			//temp data for developing
			$menu_srl = 671; //at work

			//get piping target menu info
            $oMenuAdminModel = &getAdminModel('menu');
			$menu = $oMenuAdminModel->getMenu($menu_srl);
			//ddd($menu);
			if(file_exists($menu->php_file)) @include($menu->php_file);
			//ddd($menu);

			//get module info to export
			$modules = array();
			$layouts = array();
			$widgets = array();

            $oLayoutModel = &getModel('layout');
			$oTemplate = &TemplateHandler::getInstance();

			foreach($menu->list as $menu_item)
			{
				///ddd($menu_item);
				//get module info
				$oModuleModel = &getModel('module');
				$module_info_temp = $oModuleModel->getModuleInfoByMid($menu_item['url']);
				//ddd($module_info_temp);
				if($module_info_temp) {
					$modules[] = $module_info_temp;

					//make module table for further replacement
					$module_table[$module_info_temp->module_srl] = $module_info_temp;

					//get layout info to export
					//this can be two or more
					
					if($module_info_temp->layout_srl > 0 
						&& !$layouts[$module_info_temp->layout_srl]) {

						$layout_srl = $module_info_temp->layout_srl;
						$layout_info = $oLayoutModel->getLayout($layout_srl);
						$layouts[$module_info_temp->layout_srl] = $layout_info;

						//get widget info (widget name and skin name) in layout
						$layout_path = $oLayoutModel->getUserLayoutPath($layout_srl);
						if(!file_exists(sprintf("%slayout.html", $layout_path))){
							$layout_path = $layout_info->path;
						} 

						$layout_file = "layout";
						$layout_html = $oTemplate->compile($layout_path, $layout_file, '');
						preg_match_all('!<img([^\>]*)widget=([^\>]*?)\>!is', $layout_html, $widgets_temp);
						///ddd($widgets_temp);

						foreach($widgets_temp[0] as $widget_item){
							$xml_doc = $this->transWidget($widget_item);
							//ddd($xml_doc);
							$widgets[] = $xml_doc;
						}

						unset($layout_srl);
						unset($layout_info);
						unset($layout_path);
						unset($layout_file);
						unset($layout_html);
					}
					
					//get widget info (widget name and skin name) in page contents
					if($module_info_temp->module == 'page'){
						//ddd($module_info_temp);
						preg_match_all('!<img([^\>]*)widget=([^\>]*?)\>!is', $module_info_temp->content, $widgets_temp);
						//ddd($widgets_temp);
						foreach($widgets_temp[0] as $widget_item){
							$xml_doc = $this->transWidget($widget_item);
							//ddd($xml_doc);
							$widgets[] = $xml_doc;
						}
						//break;
					}
				}
			}

			//ddd($module_table);
			//ddd($modules);
			//ddd($layouts);
			//ddd($widgets);


			//get downloaded stuff 
            $oWidgetModel = &getModel('widget');
            $dn_widget_list = $oWidgetModel->getDownloadedWidgetList();
            $dn_layout_list = $oLayoutModel->getDownloadedLayoutList();
            $oModuleModel = &getModel('module');
            $dn_module_list = $oModuleModel->getModuleList();

			//ddd($dn_widget_list);
			//ddd($dn_layout_list);
			//ddd($dn_module_list[0]);
			
			//ddd($modules[0]);
			//ddd($dn_module_list[0]);

			foreach($modules as $val_module){
				//ddd( $val_module->module );
				//ddd( $this->in_array_with_valname($dn_module_list, $val_module->module, 'module') );
			}
			
			//ddd($widgets[0]);
			//ddd($dn_widget_list[0]);

			foreach($widgets as $val_widget){
				if('widgetContent' == $val_widget->img->attrs->widget) continue;
				//ddd( $val_widget->img->attrs->widget );
				//ddd( $this->in_array_with_valname($dn_widget_list, $val_widget->img->attrs->widget, 'widget') );
			}
			
			//ddd($layouts);
			//ddd($dn_layout_list[0]);

			foreach($layouts as $val_layout){
				//ddd( $val_layout->layout );
				//ddd( $this->in_array_with_valname($dn_layout_list, $val_layout->layout, 'layout') );
			}
			
			$pipingXE->menu = $menu;
			$pipingXE->modules = $modules;
			$pipingXE->widgets = $widgets;
			$pipingXE->layouts = $layouts;

			//ddd($menu);
			
            Context::setResponseMethod("XMLRPC");

			
			require_once 'lib/Serializer.php';
			
			$options = array(
								XML_SERIALIZER_OPTION_INDENT      => '    ',
								XML_SERIALIZER_OPTION_LINEBREAKS  => "\n",
								XML_SERIALIZER_OPTION_TYPEHINTS   => true
							);

			$serializer = &new XML_Serializer($options);
			//ddd($pipingXE);

			$result = $serializer->serialize($pipingXE);
			if( $result === true ) {
				$xml = $serializer->getSerializedData();
				//ddd($xml);
				Context::set('xml', $xml);
	
				require_once 'lib/Unserializer.php';
				$unserializer = &new XML_Unserializer();
				$result = $unserializer->unserialize($xml);    
				if( $result === true ) {
					$unserialized = $unserializer->getUnserializedData();
					//ddd($unserialized);
				}
			}
		}
		
		function in_array_with_valname ($array, $value, $valname) {

			foreach($array as $val){
				if($val->{$valname} == $value) return true;
			}
			
			return false;
		}

        function transWidget($buff) {
            $oXmlParser = new XmlParser();
            $xml_doc = $oXmlParser->parse(trim($buff));
            return $xml_doc;
        }

        function dispPipingxeAdminImport() {

			$oMenuAdminModel = &getAdminModel('menu');
			$menus = $oMenuAdminModel->getMenus();
			Context::set('menus', $menus);

			$oPipingModel = &getModel('pipingxe');
            $pipingxe_srl = Context::get('pipingxe_srl');
            if($pipingxe_srl) {
                $pipingxe_info = $oPipingModel->getPipingxeInfoByPipingxeSrl($pipingxe_srl);
			}	
            Context::set('pipingxe_info',$pipingxe_info);
        }

        function dispPipingxeAdminInsert() {

			$oMenuAdminModel = &getAdminModel('menu');
			$menus = $oMenuAdminModel->getMenus();
			Context::set('menus', $menus);

			$oPipingModel = &getModel('pipingxe');
            $pipingxe_srl = Context::get('pipingxe_srl');
            if($pipingxe_srl) {
                $pipingxe_info = $oPipingModel->getPipingxeInfoByPipingxeSrl($pipingxe_srl);
			}	
            Context::set('pipingxe_info',$pipingxe_info);
        }

        function dispPipingxeAdminDelete($args = null) {
			
			$args->pipingxe_srl = Context::get('pipingxe_srl');
			if(!$args->pipingxe_srl) return $this->dispPipingxeAdminContent();
			$output = executeQuery('pipingxe.getPipingxeList', $args);
			if(!$output->toBool()) return $output;

			$pipingxe_info = $output->data[1];
			if(!$pipingxe_info) return;
            Context::set('pipingxe_info', $pipingxe_info);

			$oMenuAdminModel = &getAdminModel('menu');
			$menu_info = $oMenuAdminModel->getMenu($pipingxe_info->menu_srl);
			Context::set('menu_info', $menu_info);
			
        }
    }
?>