<?
	/** simple_lib.php
	 * simple_lib.php 파일은 심플챗을 사용하기 위한 기본함수를 모아둔 파일입니다.
	 * 현재 get_user_info 함수 하나만 존재합니다. 차후 추가될 예정입니다.
	*/

	function get_user_info($userid = "") {
		/**
		 * member 테이블에서 사용자 정보를 가져온다.
		 * 보드 종류 또는 사이트 성격에 따라 필드명이 틀리거나, 정보가 틀릴수 있음으로
		 * 이를 쿼리를 통해 처리하도록 한다.
		 * 예를 들어 나이와 같은 경우 주민번호 앞자리나, 생년월일을 통해서 알수 있다.
		 * area 의 경우 지역정보가 들어간다. 
		 * gender 의 경우 필드 저장값을 확인하여 남자면 M, 여자면 F값으로 설정되도록 한다.
		 * board_name 은 simple_config 에서 설정됨.
		 */
		global $board_name, $member_id, $member_name;
		

		$user_info = array();
		
		//$query = "SELECT userid, name, nick, age, gender, area, user_level FROM simple_member WHERE userid='$userid'";
		if($board_name == "simple_chat") {
			$query = "SELECT userid user_id, name, nick, age, gender, area, user_level level FROM simple_member WHERE userid='$member_id'";
		} else if($board_name == "zboard") {
			$query = "SELECT user_id userid, name, name nick, date_format(now(), '%Y') - date_format(birth, '%Y') +1 age, 'M' gender, home_address area, level FROM zetyx_member_table WHERE user_id='$member_id'";
		} else if($board_name == "gnuboard4") {
			$query = "SELECT mb_id userid, mb_name name, mb_nick nick, mb_sex gender, date_format(now(), '%Y') - date_format(mb_birth, '%Y') +1 age, mb_addr1 area, mb_level level FROM g4_member where mb_id='$member_id'";
			$row = sql_fetch($query);
			
		} else if($board_name == "rgboard") {
			$query = "SELECT mb_id user_id, mb_name name, mb_nick nick, mb_sex gender, date_format(now(), '%Y') - date_format(mb_birth, '%Y') +1 age, mb_address1 area, mb_level level FROM rg_member where mb_id='$member_id'";
		}  else if($board_name = "xe") {
			$row = array();
			$row["userid"] = $member_id; 
			$row["name"] = 	$member_name;
			$row["nick"] = 	$member_name;
		
		}
		
		//주민번호에서 나이와 성별을 추출 할 경우
		//if($age < 1) $age += 100;
		//$gender = substr($row["jumin"], 6, 1) == "2" : "F" : "M";
		//$age = date("Y") - $age +1;
	

		$user_info["userid"] = $row["userid"];
		$user_info["name"] = (!isset($row["nick"]) || $row["nick"] == "") ? $row["userid"] : $row["nick"]; //이름이 없을경우 아이디값으로 설정
		$user_info["nick"] = (!isset($row["nick"]) || $row["nick"] == "") ? $row["userid"] : $row["nick"]; //이름이 없을경우 아이디값으로 설정
		$user_info["age"] = ($row["age"]!= "") ? $row["age"] : "99"; //2자리 정수
		$user_info["gender"] = ($row["gender"] == "2") ?  "F" : "M"; // M : 남자, F : 여자 default : 남자
		$user_info["level"] = ($row["level"] != "") ? $row["level"] : "0"; // 1 ~ 10 사이
		$user_info["area"] = $row["area"]; //area 는 서울,경기도 처럼 지역만 가져오도록 한다.
		
		
		return $user_info;
	}

	// 현재페이지, 총페이지수, 한페이지에 보여줄 행, URL
	function simple_paging($write_pages, $cur_page, $total_page, $url, $add="") {
		$str = "";
		if ($cur_page > 1) {
			$str .= "<a href='" . $url . "1{$add}'>◀◀</a>";
			//$str .= "[<a href='" . $url . ($cur_page-1) . "'>이전</a>]";
		}

		$start_page = ( ( (int)( ($cur_page - 1 ) / $write_pages ) ) * $write_pages ) + 1;
		$end_page = $start_page + $write_pages - 1;

		if ($end_page >= $total_page) $end_page = $total_page;

		if ($start_page > 1) $str .= " &nbsp;<a href='" . $url . ($start_page-1) . "{$add}'>◀</a>";

		if ($total_page > 1) {
			for ($k=$start_page;$k<=$end_page;$k++) {
				if ($cur_page != $k)
					$str .= " &nbsp;<a href='$url$k{$add}'><span>$k</span></a>";
				else
					$str .= " &nbsp;<b>$k</b> ";
			}
		}

		if ($total_page > $end_page) $str .= " &nbsp;<a href='" . $url . ($end_page+1) . "{$add}'>▶</a>";

		if ($cur_page < $total_page) {
			//$str .= "[<a href='$url" . ($cur_page+1) . "'>다음</a>]";
			$str .= " &nbsp;<a href='$url$total_page{$add}'>▶▶</a>";
		}
		$str .= "";

		return $str;
	}

	function kstrcut($str, $len, $suffix = "") {
		if ($len >= strlen($str)) return $str;
		$klen = $len - 1;
		while(ord($str[$klen]) & 0x80) $klen--;
		return substr($str, 0, $len - (($len + $klen + 1) % 2)) . $suffix;
	}

	


?>
