<?
	
	/** simple_config.php
	 * simple_config.php 파일은 웹톡 서버에 접속하기 위한 기본적인 설정변수가 위치하여 있고,
	 * 인증정보를 xclient 에 맞게 재설정하는 Auth_User 클래스를 포함하고 있다.
	*/
	
	$simple_path = dirname(dirname(__FILE__))."/"; //simple_client가 설치된 서버의 절대경로
	$xclient_path = dirname(dirname(__FILE__))."/"; //simple_client가 설치된 서버의 절대경로
	$simple_url = "/xclient/"; 
	$xclient_url = "/xclient/"; 
	$server_host = "webtalk.kr";
	$server_port = "3000"; //채팅서버의 port
	$websocket_server_port = "3001"; //웹소켓용 서버 포트
	$site_key = "your.site.domain"; // webtalk.kr에서 발급받은 사이트 key 를 입력하세요. 보안채널 사용시 필요
	

	//site_id를 도메인 이름으로 자동 변환한다.
	$temp = explode(".", $_SERVER["SERVER_NAME"]);
	if(strtolower($temp[0]) == "www") {
		array_shift($temp);
		$site_id = implode(".", $temp);
	} else {
		$site_id = $_SERVER["SERVER_NAME"];
	}
	
	//site_id를 별도로 사용하실 경우에 변경하세요.

	//사이트 설정부분
	$server_charset = "utf-8";
	if(!$_GET["is_allow_guest"]) {
		$is_allow_guest = "Y"; //손님 접속 여부 {Y:허용, N:거부, default:Y} 
		$is_allow_guest_chat = "Y" ; //손님 채팅 가능 여부 {Y:허용, N:거부, default:Y}
		$is_display_inout = "Y"; //출입표시
	} else {
		$is_allow_guest = $_GET["is_allow_guest"]; //손님 접속 여부 {Y:허용, N:거부, default:Y} 
		$is_allow_guest_chat =  $_GET["is_allow_guest_chat"] ; //손님 채팅 가능 여부 {Y:허용, N:거부, default:Y}
		$is_display_inout =  $_GET["is_display_inout"]; //출입표시
	}
	
	global $member_id, $member_name, $board_name;
	$board_name = "xe";
	switch ($board_name) {
		case "gnuboard4" :
			$g4_path = "..";
			include_once($g4_path."/common.php");
			$server_charset = $g4['charset'];
			
			$member_id = $_SESSION["ss_mb_id"]; //그누보드 기본 세션
			$member_name = $_SESSION["ss_mb_id"]; //login_check.php에서 세션 추가
			break;
		
		case "zboard" :
			$_zb_path = "../bbs/";
			include_once("../bbs/lib.php");
			$member_id = $_SESSION["simple_member_id"]; //제로보드 bbs/login_check.php에 로그인시 해당 세션 추가
			$member_name = $_SESSION["simple_member_name"];//제로보드 bbs/login_check.php에 로그인시 해당 세션 추가
			break;

		case "rgboard" :
			$site_path = "../rgboard/"; //세션값을 제대로 가져오지 못하면, 절대경로로 입력한다.
			include_once("../rgboard/include/lib.inc.php");
			$member_id = $_SESSION["ss_mb_id"];
			$member_name = $_SESSION["ss_mb_name"]; //알지보드 rgboard/mb_login.php 에 추가한 세션값
			break;

		case "simple_chat" :
			session_start();
			$member_id = $_SESSION["member_id"];
			$member_name = $_SESSION["member_name"];
			break;
		case "xe" :
			define('__ZBXE__', true);
			 /**
			 * @brief 필요한 설정 파일들을 include
			 **/
			require('../../config/config.inc.php');

			/**
			 * @brief Context 객체를 생성하여 초기화
			 * 모든 Request Argument/ 환경변수등을 세팅
			 **/

			$oContext = &Context::getInstance();
			$oContext->init();
			$oModuleModel = &getModel('module');
			$member_config = $oModuleModel->getModuleConfig('member');
			$logged_info = Context::get('logged_info');
			$member_id = $logged_info->user_id; 
			$member_name = $logged_info->nick_name;
		
			break;
		default :
			session_start();
			$member_id = $_SESSION["member_id"];
			$member_name = $_SESSION["member_name"];
			break;
	}

	Header("Content-Type: text/html; Charset=utf-8");	
	
	
class Auth_User {
	//세션을 시작하고 인증과 관련된 정보를 담을 변수를 등록한다.
	var $userid;
	var $name;
	var $age;
	var $gender;
	var $area;
	var $level;

	function Auth_User() {
		global $member_id, $member_name, $member_age, $member_sex, $member_area, $member_level; 
		global $encrypt_key;
	
		$this->userid = $member_id;
		$this->name = $member_name;
		$this->age = $member_age;
		$this->gender = $member_sex;
		$this->area = $member_area;
		$this->level = $member_level;
		
	}

	//인증된 상태인지 아닌지 판별한다.
	function isAuth() {
		if(!isset($this->userid) || $this->userid == "") {
			return false;
		}
		return true;
	}

	function getUserid() {
		return $this->userid;
	}

	function getName() {
		return $this->name;
	}

	function getAge() {
		return $this->age;
	}

	function getGender() {
		return $this->gender;
	}

	function getArea() {
		return $this->area;
	}

	function getKey() {
		global $encrypt_key;
		//키값을 생성한다.
		return md5($this->userid.$site_key);
	}

	function setName($name) {
		$this->name = $name;
	}

	function setAge($age) {
		$this->age = $age;
	}

	function setGender($sex) {
		$gen = ($sex == "f" || $sex == "F" || $sex=="2") ? "F" : "M"; 
		$this->gender = $gen;
	}

	function setArea($area) {
		$this->area = $area;
	}

	function setLevel($level) {
		$this->level = $level;
	}

	function getLevel() {
		return $this->level;
	}
	
}
?>