<?
	/*********************************************************
	 * 설명 : 범용적으로 db를 컨트롤 할수 있는 class
	 * 홈페이지 : http://www.mjava.net 
	 * 만든사람 : 명랑폐인™ merong@hanmir.com (MSN id 동일)
	 * 저작권 : 없으니까 맘대로 쓰세요. (만든사람 이름정도는 써주세요.^^)
     ********************************************************/

	/*
		php에서는 메소드 오버라이딩이 지원되지 않습니다.
		따라서 클래스 생성자는 단하나만 가능합니다.
		mysql_db가 아닌 mssql 이나 오라클일경우에 각가의 클래스 멤버 함수에 맞게
		구현을 해주면 됩니다. 누가 만들거든 올려주세요..저도 좀 쓰게요..
		아마 class Mssql_DB나 class Oracle_DB가 되겠죠....
		이 파일을 다시 common_db.php 에서 클래스별로 만들어주면 됩니다.
		
		db를 클래스를 이용하여 접근하는 이유는 각 db별로 접근하는 함수명이 틀리기 때문에
		동일한 접근 방법을 지원하여 사용자가 사용시 혼란스럽지 않게 하는겁니다.
		새로운 걸 만들때마다 common.inc.php 파일부터 만드는 번거로움을 줄이자는 것이죠.
	*/

	class Mysql_DB {
		var $db;   //db conncion 
		var $result;  //result set
			
		function Mysql_DB ($db_host, $db_user, $db_pass, $db_name) {
			
			$this->connect_db($db_host, $db_user, $db_pass);
			$this->select_db($db_name);

		}

		/*
			connect_db() 와 select_db()에서 파라메타에 의한 호출이 없다.
			생성자 이외에 방법으로 db를 변경하지 못하도록 한다.
		*/

		function connect_db($db_host, $db_user, $db_pass) {
			$this->db = @mysql_connect($db_host, $db_user, $db_pass);
			if(is_resource($this->db) == false) {
				$this->trace_error($db_host."에 접속할수 없습니다.");
			} 
		
		}
		
		function select_db($db_name) {
			@mysql_select_db($db_name, $this->db) or $this->trace_error($db_name."을 선택할수 없습니다.");
			mysql_query("set names euckr");
		}

		/*
			db에서 select 쿼리를 실행하는 함수
		*/
		function execute_query($query) {

			if(is_resource($this->db) == false) {
				$this->trace_error("execute_query error. db 접속이 유효하지 않습니다.");
				return;
			} 
			$this->result = @mysql_query($query, $this->db) or $this->trace_error("쿼리문에 문제가 있습니다.");
		}

		/*
			db 에서 insert, delect, update 쿼리를 실행하는 함수
			return : 적용된 rows 수, 에러가 있다면, -1를 반환
		*/
		function execute_update($query) {
			$result = mysql_query($query, $this->db); //
			if(is_resource($result)) return mysql_affected_rows($result); 
			return -1;
		}

		/*
			select query된 result set을 반환한다. 
			꼭 필요한 경우 사용하고 보통은 next_fetch()를 사용하도록 한다. 
		*/
		function get_result() {
			return $this->result;
		}

		/*
			execute_count() 함수는 select count(*) 등과 같은 단순 select 쿼리를 fetch하여 
			결과값을 반환하는 함수이다. 솔직히 이런거 가져올때 이것저것 호출하면 귀찮다.
			return : 정상정인 값은 0 이상이며, select 된 row가 없으면, -1을 반환
		*/
		function execute_simple_query($query) {
			$result = mysql_query($query, $this->db); 
			if(!is_resource($result)) return -1;
			$ret =  mysql_result($result, 0, 0);
			return $ret;
		}
		
		/*
			select 쿼리된 개수를 반환한다.
			return : 정상적 쿼리가 아니면, -1 을 return
		*/
		function get_num_rows() {
			if(is_resource($this->result)) return mysql_num_rows($this->result); 
			return -1;
		}

		/* 
			$result를 하나 fetch 한다.
			db간의 호환성을 높이기 위해 함수를 따로 만든다.
		*/
		function next_fetch() {
			return mysql_fetch_assoc($this->result);
		}
		
		/*
			next_fetch()와 동일 함수이다. 취향대로 쓰기 바랍니다.
		*/
		function next_row() {
			return mysql_fetch_assoc($this->result);
		}

		function next_row2() {
			return mysql_fetch_row($this->result);
		}

		/*
			에러 메세지를 출력한다.
		*/
		function trace_error($msg) {
			echo "</UL></DL></OL>\n";
			echo "</TABLE></SCRIPT>\n";
			$text  = "<FONT COLOR=\"#ff0000\"><P>Error: $msg : </p>";
			$text .= mysql_error();
			$text .= "</FONT>\n";
			die($text);
		}

		/*
			db 와 연결된 자원을 반납한다.
			페이지 output이 끝나면 자동적으로 접속이 끊기지만, 명시적으로
			db접속이 끊기는걸 넣어주는게 좋습니다.
		*/
		function destroy() {
			if(is_resource($this->result)) mysql_free_result($this->result); 
			mysql_close($this->db);
		}
		
		/*
			destroy()라는 이름보다 close()를 선호하실거 같아 넣었습니다.
		*/
		function close() {
			$this->destroy();
		}
	}

?>