<?php
    /**
     * @class xclient
     * @author 명랑폐인 (merong@hanmir.com)
     * @brief 웹톡 클라이언트 위젯
     **/

    class xclient extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
        function proc($args) {
            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);
						
			$site_id = $args->site_id;
			$xwidth = $args->xwidth;
			$xheight = $args->xheight;
			$skin_type = $args->skin_type;

			if(strlen($args->xheight) > 2)  {
				$xheight  = $args->xheight;
			}
			else  {
				$xheight  = 450;
			}
			if(strlen($args->xheight) > 2)  {
				$xheight  = $args->xheight;
			}
			else  {
				$xheight  = "100%";
			}
			
			$temp = explode(".", $_SERVER["SERVER_NAME"]);
			if(count($temp) <= 2) {
				$site_id = $_SERVER["SERVER_NAME"];
			} else {
				$site_id = $temp[count($temp)-2].".".$temp[count($temp)-1];
			} 

			Context::set('site_id', $site_id);
			Context::set('xwidth', $xwidth);
			Context::set('xheight', $xheight);
			Context::set('skin_type', $skin_type);
			Context::set('widget_path', $this->widget_path);

			$oTemplate = &TemplateHandler::getInstance();

			$tpl_file = 'xclient';
			$tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
			Context::set('colorset', $args->colorset);
			$output = $oTemplate->compile($tpl_path, $tpl_file);
			return $output;
					
		}
	}
?>
