<?php
    /**
     * @class  lunarModel
     * @author 난다날아 (sinsy200@gmail.com)
     * @brief  lunar 모듈의 Model class
     **/

    require_once('class.calendar.php');
    require_once('class.lunar.php');
    
    class lunarModel extends lunar {
        
        function getConfig() {
            $oModuleModel = &getModel('module');
            return $oModuleModel->getModuleConfig("lunar");
        }
        
        function getLunarBirthday($member_srl){
            if (!$member_srl) return;
            
            if (!$GLOBALS['__lunar_birthday__'][$member_srl]){
                $args->member_srl = $member_srl;
                $output = executeQuery('lunar.getLunarBirthday', $args);
                $GLOBALS['__lunar_birthday__'][$member_srl] = $output->data;
            }
            
            return $GLOBALS['__lunar_birthday__'][$member_srl];
        }
        
        function isValidRangeSolar($year, $month, $day){
            if ($year < 1902)   return false;
            if ($year > 2038)   return false;
            if ($month < 1 || $month > 12)  return false;
            if ($year == 1902 && $month == 1 && $day < 10)  return false;
            if ($year == 2038 && $month > 1)    return false;
            if ($year == 2038 && $month == 1 && $day > 18)  return false;
            return true;
        }
        
        function isValidRangeLunar($year, $month, $day){
            if ($year < 1901)   return false;
            if ($year > 2037)   return false;
            if ($month < 1 || $month > 12)  return false;
            if ($year == 1901 && $month < 12)   return false;
            if ($year == 2037 && $month == 12 && $day > 14) return false;
            return true;
        }
        
        function isValidLunar($year, $month, $day, $leap) {
            $result = $this->isValidRangeLunar($year, $month, $day);
            if (!$result)   return false;
            $solar = $this->tosolar($year, $month, $day, $leap);
            return $solar[1];
        }
        
        function isValidSolar($year, $month, $day){
            $last_day = array(0, 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);
            
            $result = $this->isValidRangeSolar($year, $month, $day);
            if (!$result)   return false;
            
            if (date("L", mktime(1, 1, 1, 1, 1, $year))) $last_day[2] = 29;
            if ($day < 1 || $day > $last_day[$month])   return false;
            
            return true;
        }

        function transSolarLunar(){
            $date = Context::get('date');
            $lunar = Context::get('lunar');
            $leap = Context::get('leap');
            
            if ($lunar == 'Y')  $lunar = true;
            else                $lunar = false;
            if ($leap == 'Y')   $leap = true;
            else                $leap = false;
            
            $regexp = "/^[0-9]{4}-[0-9]{2}-[0-9]{2}$/";
            if (!preg_match($regexp, $date)){
                return $this->stop('msg_invalid_format');
            }
            
            $year = (int)substr($date, 0, 4);
            $month = (int)substr($date, 5, 2);
            $day = (int)substr($date, 8, 2);
            
            $weekday = Context::getLang('weekday');
            
            if ($lunar){
                if (!$this->isValidLunar($year, $month, $day, $leap)){
                    return $this->stop('msg_invalid_date');
                }
                
                $solar = $this->tosolar($year, $month, $day, $leap);
                
                $solar_date = $solar[0] . ' (' . $weekday[$solar[5]] . ')';
                
                $lunar = $this->tolunar($solar[2], $solar[3], $solar[4]);
                
                $lunar_date = $lunar[0];
                if ($lunar[1][3])  $leap_value = Context::getLang('leap');
                else               $leap_value = Context::getLang('no_leap');
                
            }else{
                if (!$this->isValidSolar($year, $month, $day)){
                    return $this->stop('msg_invalid_date');
                }
                
                $lunar = $this->tolunar($year, $month, $day);
                
                $lunar_date = $lunar[0];
                if ($lunar[1][3])   $leap_value = Context::getLang('leap');
                else                $leap_value = Context::getLang('no_leap');
                
                $solar = $this->tosolar($lunar[1][0], $lunar[1][1], $lunar[1][2], $lunar[1][3]);

                $solar_date = $solar[0] . ' (' . $weekday[$solar[5]] . ')';
            }
            
            $str = Context::getLang('solar') . ' : ' . $solar_date . '<br/>';
            $str .= Context::getLang('lunar') . ' : ' . $lunar_date . ', ' . $leap_value;
            
            $this->add('trans_result', $str);
        }
        
        function &moon($utime=0){
            return _lunar::moon($utime);
        }
        
        function &solareclipse($y, $m, $d){
            return _lunar::solareclipse($y, $m, $d);
        }
        
        function &lunareclipse($y, $m, $d){
            return _lunar::lunareclipse($y, $m, $d);
        }
        
        function &tolunar($_y, $_m, $_d){
            return _lunar::tolunar($_y, $_m, $_d);
        }
        
        function &tosolar($_y, $_m, $_d, $_leap=0){
            return _lunar::tosolar($_y, $_m, $_d, $_leap=0);
        }
        
        function &zodiac($y, $m, $d, $lunar=0, $leap=0){
            return _lunar::zodiac($y, $m, $d, $lunar=0, $leap=0);
        }
    }
?>
