<?php
    /**
     * @class  lunarController
     * @author 난다날아 (sinsy200@gmail.com)
     * @brief  lunar 모듈의 controller class
     **/

    class lunarController extends lunar {

        function init() {
        }

        function triggerInsertMemberBefore(&$obj) {
            $output = $this->transSolarLunarBirthday($obj);
            if (!$output->toBool())  return $output;
            return new Object();
        }
        
        function triggerInsertMemberAfter(&$obj) {
            return $this->insertLunarBirthDay($obj->member_srl);
        }
        
        function triggerUpdateMemberBefore(&$obj) {
            $output = $this->transSolarLunarBirthday($obj);
            if (!$output->toBool())  return $output;
            return new Object();
        }
        
        function triggerUpdateMemberAfter(&$obj) {
            return $this->UpdateLunarBirthDay($obj->member_srl);
        }
        
        function triggerDeleteMemberAfter(&$obj) {
            return $this->deleteLunarBirthDay($obj->member_srl);
        }
        
        function transSolarLunarBirthday(&$obj) {
            $oLunarModel = &getModel('lunar');
            $config = $oLunarModel->getConfig();
            if ($config->use_lunar_birthday != "Y") return new Object();
            
            $date = $obj->birthday;
            $lunar = Context::get('lunar');
            $leap = Context::get('leap');

            if (empty($date))   return new Object();
            
            $regexp = "/^[0-9]{4}-[0-9]{2}-[0-9]{2}$/";
            if (!preg_match($regexp, $date)){
                return new Object(-1, 'msg_invalid_format_birthday');
            }
            
            $year = (int)substr($date, 0, 4);
            $month = (int)substr($date, 5, 2);
            $day = (int)substr($date, 8, 2);
            
            if ($lunar != "Y"){
                $result = $oLunarModel->isValidSolar($year, $month, $day);
                if (!$result)   return new Object(-1, 'msg_invalid_date_birthday');
                $obj->birthday = sprintf("%04d%02d%02d", $year, $month, $day);
                return new Object();
            }
            
            $result = $oLunarModel->isValidRangeLunar($year, $month, $day);
            if (!$result){
                return new Object(-1, 'msg_invalid_date_birthday');
            }
            
            $solar = $oLunarModel->tosolar($year, $month, $day, $leap);
            if ($solar[1] == 0){
                return new Object(-1, 'msg_invalid_date_birthday');
            }
            
            $lunar = $oLunarModel->tolunar($solar[2], $solar[3], $solar[4]);
            
            if ($lunar[1][3] == 1)
                $leap = "Y";
            else
                $leap = "N";
                
            $obj->birthday = sprintf("%04d%02d%02d", $solar[2], $solar[3], $solar[4]);
            Context::set('lunar_birthday', sprintf("%04d%02d%02d", $lunar[1][0], $lunar[1][1], $lunar[1][2]));
            Context::set('leap', $leap);
            
            return new Object();
        }
        
        function insertLunarBirthDay($member_srl){            
            $lunar_birthday = Context::get('lunar_birthday');
            $leap = Context::get('leap');
            
            if (!$lunar_birthday)   return new Object();
            
            $args->member_srl = $member_srl;
            $args->lunar_birthday = Context::get('lunar_birthday');
            $args->leap = Context::get('leap');
            return executeQuery('lunar.insertLunarBirthday', $args);
        }
        
        function updateLunarBirthDay($member_srl){            
            $lunar_birthday = Context::get('lunar_birthday');
            $leap = Context::get('leap');
            
            if (!$lunar_birthday)   return new Object();
            
            $args->member_srl = $member_srl;
            $args->lunar_birthday = Context::get('lunar_birthday');
            $args->leap = Context::get('leap');
            return executeQuery('lunar.updateLunarBirthday', $args);
        }
        
        function deleteLunarBirthday($member_srl){
            $args->member_srl = $member_srl;
            return executeQuery('lunar.deleteLunarBirthday', $args);
        }
    }
?>
