<?php
    /**
     * @class  lunar
     * @author 난다날아 (sinsy200@gmail.com)
     * @brief  lunar 모듈의 high class
     **/

    class lunar extends ModuleObject {

        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            // 회원가입 트리거 추가
            $oModuleController = &getController('module');
            $oModuleController->insertTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberBefore', 'before');
            $oModuleController->insertTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberAfter', 'after');
            
            // 정보수정 트리거 추가
            $oModuleController->insertTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberBefore', 'before');
            $oModuleController->insertTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberAfter', 'after');
        
            // 회원탈퇴 트리거 추가
            $oModuleController->insertTrigger('member.deleteMember', 'lunar', 'controller', 'triggerDeleteMemberAfter', 'after');
            
            return new Object();
        }

        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oModuleModel = &getModel('module');
            
            // 트리거 체크
            if(!$oModuleModel->getTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberBefore', 'before'))   return true;
            if(!$oModuleModel->getTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberAfter', 'after'))   return true;
            if(!$oModuleModel->getTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberBefore', 'before'))   return true;
            if(!$oModuleModel->getTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberAfter', 'after'))   return true;
            if(!$oModuleModel->getTrigger('member.deleteMember', 'lunar', 'controller', 'triggerDeleteMemberAfter', 'after'))   return true;

            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            
            // 트리거 추가
            if(!$oModuleModel->getTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberBefore', 'before'))
                $oModuleController->insertTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberBefore', 'before');
            if(!$oModuleModel->getTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberAfter', 'after'))
                $oModuleController->insertTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberAfter', 'after');
            if(!$oModuleModel->getTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberBefore', 'before'))
                $oModuleController->insertTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberBefore', 'before');
            if(!$oModuleModel->getTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberAfter', 'after'))
                $oModuleController->insertTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberAfter', 'after');
            if(!$oModuleModel->getTrigger('member.deleteMember', 'lunar', 'controller', 'triggerDeleteMemberAfter', 'after'))
                $oModuleController->insertTrigger('member.deleteMember', 'lunar', 'controller', 'triggerDeleteMemberAfter', 'after');
            
            return new Object(0, 'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }
        
        /**
         * @brief 모듈 삭제
         **/
        function moduleUninstall() {
            $oModuleController = &getController('module');
            
            // 트리거 삭제
            $oModuleController->deleteTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberBefore', 'before');
            $oModuleController->deleteTrigger('member.insertMember', 'lunar', 'controller', 'triggerInsertMemberAfter', 'after');
            $oModuleController->deleteTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberBefore', 'before');
            $oModuleController->deleteTrigger('member.updateMember', 'lunar', 'controller', 'triggerUpdateMemberAfter', 'after');
            $oModuleController->deleteTrigger('member.deleteMember', 'lunar', 'controller', 'triggerDeleteMemberAfter', 'after');
            
            return new Object();
        }
    }

?>