<?php
    if(!defined("__ZBXE__")) exit();

    /**
     * @file refhide.addon.php
     * @author J.R
     * @brief insert refhide.com service script
     *
     **/

    // 게시글 본문이 처리되지 않았거나, 관리 메뉴에서는 동작을 중지한다.(after_module_proc에서만 동작)
    if( $called_position != 'after_module_proc' || Context::get('module') == 'admin') {
        return;
    }

    // 애드온 설정 페이지와, 페이지 모듈에서 동작하지 않게끔 함
    if ( Context::get('module') == 'addon' || Context::get('module') == 'document' ) {
        return;
    }

    // 추가할 스크립트
    $script_to_added = "<script src=\"http://js.refhide.com/refhide.js\" type=\"text/javascript\"></script>\n"
        . "<script type=\"text/javascript\">\n"
        . "<!--\n"
        . "protected_links = \"\";\n"
        . "auto_anonymize();\n"
        . "//--></script>\n";

    if($addon_info->resource_script == "Y") {
        $script_to_added = str_replace("http://js.refhide.com/refhide.js", "./addons/refhide/js/refhide.unescaped.js", $script_to_added);
    }

    // autolink 기능 사용이 활성화 된 경우 수정된 autolink 스크립트 파일을 추가해준다.(기존 애드온은 사용중지로 바꿈)
    if($addon_info->use_autolink_script == "Y") {
        $script_to_added = $script_to_added."<script src=\"./addons/refhide/js/autolink.js\" type=\"text/javascript\"></script>\n";
        
        /* TODO : 자신의 모듈 상태를 체크하고, mid_list가 완전 공백인 경우(체크된 모듈이 없는경우, 모듈 체크를 해줄것을 경고) */

        // autolink 애드온 상태를 얻어온다
        $statusaddon_args->addon = 'autolink';
        $autolinkAddonStatus = executeQueryArray('addons.refhide.getAddonInfo', $statusaddon_args);
        
        if (count($autolinkAddonStatus->data) == 1) {
            // autolink 애드온이 설치되어 있다.
            foreach ($autolinkAddonStatus->data as $data) {
                if ( $data->is_used == 'Y' || $data->is_used_m == 'Y' ) {
                    // 현재 mid에 활성화 되어 있으면 애드온에 의해 삽입된 스크립트 파일을 비활성화처리 한다
					Context::unloadJsFile('./addons/autolink/autolink.js');
                }
            }
        }

    }

    // 본문 내용 추가
    Context::addHtmlFooter($script_to_added);
?>
