<?php
	/**
	 * @class analytics_flash_counter
	 * @author devjin (devjin@nhn.com)
	 * @version 0.1
	 * @brief analytics수집된 방문자 현황 그래프 출력
	 **/

	 class analytics_flash_counter extends WidgetHandler {
		var $api_url = 'http://analytics.openapi.naver.com/?method=visit&apikey=%s&start_date=%s&end_date=%s';

		/**
         * @brief 위젯의 실행 부분
         * ./widgets/위젯/conf/info.xml에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/
		 function proc($args) {
			$oModuleModel = &getModel('module');
			$module_config = $oModuleModel->getModuleConfig('analytics');
			$api_key = $module_config->api_key;
			if (!$api_key)
			{
				return;
			}

			// 어제 날짜까지의 집계정보를 위한 날짜 생성
			$_end_date = date('Y-m-d', time()-60*60*24);
			$_start_date = date('Y-m-d', strtotime('-5 day', time()));
			
			$url = $this->_getApiUrl($api_key, $_start_date, $_end_date);
			$data = FileHandler::getRemoteResource($url, null, 3, 'GET', '');
            if (!$data) return new Object(-1, 'msg_invalid_request');

            $oParser = new XmlParser;
            $xml_obj = $oParser->parse($data);
			$response_obj = $xml_obj->response->data;
			
			$sXML = '';
			$aXML_data = array();
		
			foreach($response_obj as $key => $val)
			{
				$aXML_data[] = 'id="'.preg_replace('/-/', '', $val->day->body).'" cnt="'.$val->visit_count->body.'"';
			}
			
			$sXML = '<visitorcnts><visitorcnt '.join(' /><visitorcnt ', $aXML_data).' /></visitorcnts>';

			debugPrint($sXML);

			Context::set('xmlStr', $sXML);
			
			// 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);
            Context::set('colorset', $args->colorset);

            // 템플릿 파일을 지정
            $tpl_file = 'analytics_flash_counter';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
		 }

		 function _getApiUrl($api_key, $start_date, $end_date)
		 {
			$url = sprintf($this->api_url, $api_key, $start_date, $end_date);
			return $url;
		 }
	}
?>
