﻿/*  ================================================================================
 *  
 *  JavaScript -Page Scroller version 2.0.1
 *  (c) 2004-2007 coliss.com
 *
 *  この作品は、クリエイティブ・コモンズの表示 2.1 日本ライセンスの下で
 *  ライセンスされています。
 *  この使用許諾条件を見るには、http://creativecommons.org/licenses/by/2.1/jp/を
 *  チェックするか、クリエイティブ･コモンズに郵便にてお問い合わせください。
 *  住所は：559 Nathan Abbott Way, Stanford, California 94305, USA です。
 *
================================================================================  */


/*  ================================================================================
TOC
====================================================================================
Set Up Object
Get Attribute
Page Scroller
Setup Attribute
================================================================================  */


/*  ================================================================================
Set Up Object
================================================================================  */
	
bAgent = navigator.userAgent;
bName = navigator.appName;
bPlugins = navigator.plugins;

w = window;
s = w.screen;
d = document;

usrUrl = location.href;

function sniffer(){
/* OS */
	this.Win = bAgent.indexOf("Win",0) != -1 ? 1 : 0;
	this.WinVista = bAgent.indexOf("Windows NT 6.0",0) != -1 ? 1 : 0;
	this.Mac = bAgent.indexOf("Mac",0) != -1 ? 1 : 0;
	this.MacOSX = ((bAgent.indexOf("Mozilla") != -1) && (bAgent.indexOf("Mac OS X") != -1)) ? 1 : 0;
	if(bPlugins){for(i = 0 ;i < bPlugins.length;i++){if(this.Mac && (bPlugins[i].filename.indexOf("QuickTime Plugin.plugin") != -1)){this.MacOSX = true;}}}

/* Browser */
	this.IE        = ((bAgent.indexOf("MSIE") != -1) && (bAgent.indexOf("Opera") == -1)) ? 1 : 0;
	this.NS        = ((bName == "Netscape") && (bAgent.indexOf("Opera") == -1)) ? 1 : 0;
	this.NC        = ((bName == "Netscape") && (bAgent.indexOf("Gecko") == -1) && (bAgent.indexOf("Opera") == -1)) ? 1 : 0;
	this.Gecko     = (bAgent.indexOf("Gecko") != -1) ? 1 : 0;
	this.Moz       = ((bAgent.indexOf("Gecko") != -1) && (bAgent.indexOf("Safari",0) == -1)) ? 1 : 0;
	this.OPERA     = bAgent.indexOf("Opera",0) != -1 ? 1 : 0;
	this.Firefox   = (bAgent.indexOf("Firefox") != -1) ? 1 : 0;
	this.SAFARI    = bAgent.indexOf("Safari",0) != -1 ? 1 : 0;
	this.ICAB      = bAgent.indexOf("iCab",0) != -1 ? 1 : 0;

/* Object */
/* SAFARI,Firefox,NS6+,OPERA6=4, IE5+,OPERA5,7+=3, IE4=2, NS4=1, others=0 */
	this.checkObj      = d.all ? (d.getElementById ? 3 : 2) : (d.getElementById ? 4 : (d.layers ? 1 : 0));
	this.checkObj4     = (d.getElementById && !d.all) ? 1 : 0;
	this.checkObj3     = (d.getElementById && d.all) ? 1 : 0;
	this.checkObj2     = (d.all && !d.getElementById) ? 1 : 0;
	this.checkObj1     = d.layers ? 1 : 0;
	this.allObj        = ((this.checkObj == 3) || (this.checkObj == 4));

/* Compat Mode */
	this.modeStandard  = d.compatMode == "CSS1Compat" ? 1 : 0;
	this.modeQuirks    = d.compatMode == "BackCompat" ? 1 : 0;

/* Each Browser */
	this.IE5           = (this.Win && this.IE && (bAgent.indexOf('MSIE 5.',0) != -1));
	this.IE55          = (this.Win && this.IE && (bAgent.indexOf('MSIE 5.5.',0) != -1));
	this.IE55later     = (this.Win && this.IE && (w.createPopup != -1));
	this.IE6           = (this.Win && this.IE && (bAgent.indexOf('MSIE 6.',0) != -1));
	this.IE6below      = (this.IE5 && this.IE55 && this.IE6);
	this.IE7           = (this.Win && this.IE && (bAgent.indexOf('MSIE 7.',0) != -1));

	this.WinIEs        = (this.Win && this.IE && this.modeStandard);
	this.WinIEq        = (this.Win && this.IE && this.modeQuirks);

	this.MacFirefox    = (this.Mac && this.Firefox);
	this.MacOPERA      = (this.Mac && this.OPERA);

	return this;
}
var usr = new sniffer;


/*  ================================================================================
Get Attribute
================================================================================  */
function setObj(idName){
	return d.getElementById ? d.getElementById(idName) : d.all(idName);
}

function getScreenSize(type){
	if(type == "width"){
		if(usr.allObj){
			return(window.screen.width);
		}
	}else if(type == "height"){
		if(usr.allObj){
			return(window.screen.height);
		}
	}
}

function getBrowseSize(type){
	if(type == "width"){
		if(w.innerWidth){
			return(w.innerWidth);
		}else if(usr.modeStandard && d.documentElement.clientWidth){
			return(d.documentElement.clientWidth);
		}else{
			return(d.body.clientWidth);
		}
	}else if(type == "height"){
		if(w.innerHeight){
			return(w.innerHeight);
		}else if(usr.modeStandard && d.documentElement.clientHeight){
			return(d.documentElement.clientHeight);
		}else{
			return(d.body.clientHeight);
		}
	}
}

function getBodySize(type){
	if(type == "width"){
		if(usr.allObj){
			return(d.body.scrollWidth);
		}
	}else if(type == "height"){
		if(usr.allObj){
			return(d.body.scrollHeight);
		}
	}
}

function getDocumentSize(type){
	if(type == "width"){
		if(usr.allObj){
			return(d.getElementById('container_site').offsetWidth);
		}
	}else if(type == "height"){
		if(usr.allObj){
			return(d.getElementById('container_site').offsetHeight);
		}
	}
}

function getWindowOffset(type){
	if(type == "x"){
		if(usr.SAFARI){
			return(window.pageXOffset);
		}else if((usr.checkObj == 3) && (!usr.WinIEs)){
			return(d.body.scrollLeft);
		}else if((usr.checkObj == 4) || (usr.WinIEs)){
			return(d.body.parentNode.scrollLeft);
		}
	}else if(type == "y"){
		if(usr.SAFARI){
			return(window.pageYOffset);
		}else if((usr.checkObj == 3) && (!usr.WinIEs)){
			return(d.body.scrollTop);
		}else if((usr.checkObj == 4) || (usr.WinIEs)){
			return(d.body.parentNode.scrollTop);
		}
	}
}

function getScrollRange(type){
	if(type == "x"){
		if(usr.allObj){
			return (getDocumentSize('width') - getBrowseSize('width'));
		}
	}else if(type == "y"){
		if(usr.allObj){
			return (getDocumentSize('height') - getBrowseSize('height'));
		}
	}
}

function getElementPosition(type,idName){
	var obj = setObj(idName);
	var tagCoords = new Object();
	if(type == "left"){
		if(usr.allObj){
			tagCoords.x = obj.offsetLeft;
			while((obj = obj.offsetParent) != null){
				tagCoords.x += obj.offsetLeft;
			}
		}if((tagCoords.x * 0) == 0){
			return(tagCoords.x);
		}else{
			return(idName);
		}
	}else if(type == "top"){
		if(usr.allObj){
			tagCoords.y = obj.offsetTop;
			while((obj = obj.offsetParent) != null){
				tagCoords.y += obj.offsetTop;
			}
		}if((tagCoords.y * 0) == 0){
			if(usr.Mac && usr.SAFARI){		// temp
				return(tagCoords.y + 0);
			}else{
				return(tagCoords.y);
			}
		}else{
			return(idName);
		}
	}
}

function getElementSize(type,idName){
	if(type == "width"){
		if(usr.allObj){
			return(d.getElementById(idName).clientWidth);
		}
	}else if(type == "height"){
		if(usr.allObj){
			return(d.getElementById(idName).clientHeight);
		}
	}
}


/*  ================================================================================
Page Scroller
================================================================================  */
var pageScrollTimer;
function pageScroll(toX,toY,frms,frX,frY){
	if(pageScrollTimer)clearTimeout(pageScrollTimer);
	var spd = usr.Mac?14:16;
	var actX = getWindowOffset('x');
	var actY = getWindowOffset('y');
	if(!toX || toX < 0)toX = 0;
	if(!toY || toY < 0)toY = 0;
	if(!frms)frms = (usr.Win&&usr.SAFARI)?6:(usr.Mac&&(usr.OPERA||usr.NS6))?3:usr.NS6?4:usr.NS?7:5;
	if(!frX)frX = 0 + actX;
	if(!frY)frY = 0 + actY;

	frX += (toX - actX) / frms;
	if(frX < 0)frX = 0;
	frY += (toY - actY) / frms;
	if(frY < 0)frY = 0;
	var posX = Math.ceil(frX);
	var posY = Math.ceil(frY);
	w.scrollTo(posX, posY);
	if((Math.floor(Math.abs(actX - toX)) < 1) && (Math.floor(Math.abs(actY-toY)) < 1)){
		clearTimeout(pageScrollTimer);
		w.scroll(toX,toY);
	}else if((posX != toX) || (posY != toY)){
		pageScrollTimer = setTimeout("pageScroll("+toX+","+toY+","+frms+","+frX+","+frY+")",spd);
	}else{
		clearTimeout(pageScrollTimer);
	}
}

function toAnchor(idName,longitudinalAdj,traverser){
	if(usr.allObj){
		if(!!idName){
			var anchorX = traverser ? getElementPosition('left',idName) : 0;
			var anchorY = longitudinalAdj ? getElementPosition('top',idName) - longitudinalAdj : getElementPosition('top',idName) - 0;
			var dMaxX = getScrollRange('x');
			var dMaxY = getScrollRange('y');
			if(((anchorX*0) == 0) || ((anchorY*0) == 0)){
				var setX = (anchorX < 1) ? 0 : (anchorX > dMaxX) ? dMaxX : anchorX;
				var setY = (anchorY < 1) ? 0 : (anchorY > dMaxY) ? dMaxY : anchorY;
				pageScroll(setX,setY);
			}else{
				location.hash = idName;
			}
		}else{
			pageScroll(0,0);
		}
	}else{
		!!idName ? location.hash = idName : location.hash = "top";
	}
}

var checkAnchor = usrUrl.indexOf("#",0);
var checkPageScroller = usrUrl.match("pSc");
function initializePage(){
	if(!!checkPageScroller){
		anchorId = usrUrl.substring(usrUrl.lastIndexOf("?pSc")+4,usrUrl.length);
		timerID=setTimeout("toAnchor(anchorId,13)",400);
	}
	if(!checkAnchor){
		window.scroll(0,0);
	}else return true;
}


/*  ================================================================================
Setup Attribute
================================================================================  */
function initializeScript(){
	screenSizeWidth     = getScreenSize('width');
	screenSizeHeight    = getScreenSize('height');
	browseSizeWidth     = getBrowseSize('width');
	browseSizeHeight    = getBrowseSize('height');
	bodySizeWidth       = getBodySize('width');
	bodySizeHeight      = getBodySize('height');
	documentSizeWidth   = getDocumentSize('width');
	documentSizeHeight  = getDocumentSize('height');
	windowOffsetX       = getWindowOffset('x');
	windowOffsetY       = getWindowOffset('y');
	scrollRangeX        = getScrollRange('x');
	scrollRangeY        = getScrollRange('y');
}

window.onload = function(e){
	if(usr.allObj)initializeScript();
}
window.onresize = function(e){
	if(usr.allObj)initializeScript();
}
