<?php
    /**
     * @file   function_simple.php   planner_simple용 function: function_calendar_month.php 소스
     * @author keysung Chung
     * @brief  calender function
     **/

//--------------------------------------------------------------------------------
    /**
     * @function: fn_leapmonth($pYear)
     * @return:   boolean
     * @brief:    그해의 윤달 여부 (윤년)
     **/
function fn_leapmonth($pYear){
 
    /*연도를 100으로 나눠떨어지지 않으면서 4로 나누어 떨어지면 윤달있음.
     *또는
     *연도를 100으로 나눠떨어지는 경우는 연도를 400으로 나눠떨어지면 윤달있음.
	**/

    if (($pYear % 100 <> 0 && $pYear % 4 == 0) || $pYear % 400 == 0) {
        $fn_leapmonth = true;
	}
    else {
        $fn_leapmonth = false;
	}
	return $fn_leapmonth;

	// 또는 단순히 date()를 이용 하거나....("L" : 윤년여부 윤년엔 1, 그 외엔 0)
	// return date("L", mktime(0, 0, 0, $pMonth, 1, $pYear)); 
}
 
//--------------------------------------------------------------------------------

    /**
     * @function: fn_monthcount($pYear,$pMonth)
     * @return  : integer
     * @brief:    해당월의 마지막 일을 반환한다 
     **/
function fn_monthcount($pYear,$pMonth) {
    $aMonthNum = explode("-","31-0-31-30-31-30-31-31-30-31-30-31-");
     //2월달은 예외

    if (fn_leapmonth($pYear)) {
        $aMonthNum[1] = 29;
	}
    else {
        $aMonthNum[1] = 28;
	}   
//    return $aMonthNum;  
    return $aMonthNum[$pMonth-1];  

	// 또는 단순히 date()를 이용 하거나....("t" : 주어진 월의 일수)
	// return date("t", mktime(0, 0, 0, $pMonth, 1, $pYear)); 
}
 
//--------------------------------------------------------------------------------

    /**
     * @function: fn_firstweek($pYear,$pMonth)
     * @return  : integer
     * @brief:    해당년/월의 첫번째일의 위치를 반환 ("w" : 0=일요일, 6=토요일)
     **/
function fn_firstweek($pYear,$pMonth) {
    return date("w", mktime(0, 0, 0,$pMonth, 1, $pYear));
}

//--------------------------------------------------------------------------------

    /**
     * @function: fn_nowweek($pYear,$pMonth,$pDay)
     * @return  : integer
     * @brief:    해당년/월/일의 요일 위치를 반환 ("w" : 0=일요일, 6=토요일)
     **/
function fn_nowweek($pYear,$pMonth,$pDay) {
    return date("w", mktime(0, 0, 0,$pMonth, $pDay, $pYear));
}

//------------------------------------------------------------------------------
    /**
     * @function: fn_lastweek($pYear,$pMonth)
     * @return  : integer
     * @brief:    해당년/월의 마지막날 위치를 반환  ("w" : 0=일요일, 6=토요일)
     **/
function fn_lastweek($pYear,$pMonth) {
    return date("w", mktime(0, 0, 0,$pMonth, fn_monthcount($pYear,$pMonth), $pYear));
}
//-----------------------------------------------------------------------------------
    /**
     * @function: fn_blankweekfirst($pYear,$pMonth)
     * @return  : integer
     * @brief:    해당년/월의 첫번째주 빈값을 구한다.
	 * @brief:    해당 년/월의 일수시작이 수요일(3) 이라면 일(0)/월(1)/화(2) 즉 3개는 빈값이다.
     **/
function fn_blankweekfirst($pYear,$pMonth) {
    return fn_firstweek($pYear,$pMonth);
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_blankweeklast($pYear,$pMonth)
     * @return  : integer
     * @brief:    해당년/월의 마지막주 빈값을 구한다.
	 * @brief:    해당 년/월의 일수끝이 목요일(4) 이라면 금(5)/토(6) 즉 2개는 빈값이다.
     **/
function fn_blankweeklast($pYear,$pMonth) {
    return 6 - fn_lastweek($pYear,$pMonth);
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_weekcountofmonth($pYear,$pMonth,$pDay)
     * @return  : integer
     * @brief:    해당 년/월/일이 당월 몇번째 주에 해당 되는지를 구한다.
	 * @brief:    해당 년/월/일이 당월 2번째 주에 포함된다면 2를 반환.
     **/
function fn_weekcountofmonth($pYear,$pMonth,$pDay) {
    $wrkday = $pDay + date("w", mktime(0, 0, 0,$pMonth, 1, $pYear)); //1일의 요일번호(일=0, 토=6)
	$weekcount = floor($wrkday/7);	//소숫점이하 절사
	if ( $wrkday % 7 > 0 ) {
		$weekcount = $weekcount + 1;	
	}
    return $weekcount;		// n번째 주
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_weekdaycountofmonth($pYear,$pMonth,$pDay)
     * @return  : integer
     * @brief:    해당 년/월/일의 요일이 당월 몇번째 요일에 해당되는지 구한다.
	 * @brief:    해당 년/월/일의 요일이 당월 2번째요일 이면 2를 반환.
     **/
function fn_weekdaycountofmonth($pYear,$pMonth,$pDay) {
	$k=0;		// 카운터
    $pYoil = date("w", mktime(0, 0, 0,$pMonth, $pDay, $pYear)); //해당일의 요일번호(일=0, 토=6)

	for ($i=1; $i<=$pDay; $i++) {								// 1일 부터 말일까지 수행
		$wrk1 = date("w", mktime(0, 0, 0,$pMonth, $i, $pYear));
		if ($wrk1 == $pYoil) {				// 요일 일치
			$k=$k+1;
		}
	}
    return $k;		// n번째 요일
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_nsweekday($pYear, $pMonth, $pCount, $pYoil)
     * @return  : string
     * @brief:    해당년/월 n번째 x요일의 일자를 구한다
	 * @brief:     pCount: 숫자, pYoil: 숫자 (일요일(0) ... 토요일(6)).
     **/
function fn_nsweekday($pYear, $pMonth, $pCount, $pYoil) {
	$k=0;		// 카운터
	$j = date("t", mktime(0, 0, 0, $pMonth, 1, $pYear));	// 해당월의 날자수(말일) 값
	for ($i=1; $i<=$j; $i++) {								// 1일 부터 말일까지 수행
		$wrk1 = date("w", mktime(0, 0, 0,$pMonth, $i, $pYear));
		if ($wrk1 == $pYoil) {				// 요일 일치
			$k=$k+1;
			if ($k == $pCount) {			// 횟수 일치
				$wrkYmd =date("Y-n-j", mktime(0, 0, 0,$pMonth, $i, $pYear));
			}
		}
	}
    return $wrkYmd;
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_nsweeknsweekday($pYear, $pMonth, $pCount, $pYoil)
     * @return  : string
     * @brief:    해당년/월 n번째 주 x요일의 일자를 구한다
	 * @brief:    pCount: 숫자, pYoil: 숫자 (일요일(0) ... 토요일(6)).
     **/
function fn_nsweeknsweekday($pYear, $pMonth, $pCount, $pYoil) {
	$k=1;		//  주 카운터
	$j = date("t", mktime(0, 0, 0, $pMonth, 1, $pYear));	// 해당월의 날자수(말일) 값
	for ($i=1; $i<=$j; $i++) {								// 1일 부터 말일까지 수행
		$wrk1 = date("w", mktime(0, 0, 0,$pMonth, $i, $pYear));	// 요일
		if ($i != 1 && $wrk1==0) {			// 첫날이 아니면서 일요일 이면 주 카운터 증가
			$k = $k + 1;
		}
		if ($wrk1 == $pYoil) {				// 요일 일치
			if ($k == $pCount) {			// 횟수 일치
				$wrkYmd =date("Y-n-j", mktime(0, 0, 0,$pMonth, $i, $pYear));
			}
		}
	}
    return $wrkYmd;
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_weekdaycountofmonth_end($pYear,$pMonth,$pDay)
     * @return  : integer
     * @brief:    해당 년/월/일의 요일이 당월 끝에서 몇번째 요일에 해당되는지 요일차를 구한다.
     * @brief:    해당 년/월/일의 요일이 당월 끝에서 2번째요일 이면 2를 반환.
     **/
function fn_weekdaycountofmonth_end($pYear,$pMonth,$pDay) {
    $k=0;       // 카운터
    $pYoil = date("w", mktime(0, 0, 0,$pMonth, $pDay, $pYear)); //해당일의 요일번호(일=0, 토=6)
    $j = date("t", mktime(0, 0, 0, $pMonth, 1, $pYear));    // 해당월의 날자수(말일) 값
    for ($i=$j; $i>=$pDay; $i--) {                          // 말일 부터 당일까지 수행
        $wrk1 = date("w", mktime(0, 0, 0,$pMonth, $i, $pYear));
        if ($wrk1 == $pYoil) {              // 요일 일치
            $k=$k+1;
        }
    }
    return $k;      // n번째 요일
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_nslastweekday($pYear, $pMonth, $pCount, $pYoil)
     * @return  : string
     * @brief:    해당년/월 끝에서 n번째 x요일의 일자를 구한다
	 * @brief:     pCount: 숫자, pYoil: 숫자 (일요일(0) ... 토요일(6)).
     **/
function fn_nslastweekday($pYear, $pMonth, $pCount, $pYoil) {
	$k=0;		//  주 카운터
	$j = date("t", mktime(0, 0, 0, $pMonth, 1, $pYear));	// 해당월의 날자수(말일) 값
	for ($i=$j; $i>=1; $i--) {								// 말일 부터 1일까지 수행
		$wrk1 = date("w", mktime(0, 0, 0,$pMonth, $i, $pYear));	// 요일
		if ($wrk1 == $pYoil) {				// 요일 일치
			$k = $k + 1;
			if ($k == $pCount) {			// 횟수 일치
				$wrkYmd =date("Y-n-j", mktime(0, 0, 0,$pMonth, $i, $pYear));
			}
		}
	}
    return $wrkYmd;
}

//--------------------------------------------------------------------------------
    /**
     * @function: fn_CalMain($pYear,$pMonth)
     * @return  : array
     * @brief:    주어진 년/월의 달력을 만든다.
	 * @brief:     2차원배열을 사용하여 틀을 만든다.
     * @brief:     가로(1주)는 무조건 7이 되므로 세로값만 알면 된다.
     * @brief:     빈칸은 null 값으로한다
     * @brief:     형태예제
     * @brief:     |일|월|화|수|목|금|토|
     * @brief:     | n| n| n| n| n| n| 1|
     * @brief:     | 2| 3| 4| 5| 6| 7| 8|
     * @brief:     | 9|10|11|12|13|14|15|
     * @brief:     |16|17|18|19|20|21|22|
     * @brief:     |23|24|25|26|27|28|29|
     * @brief:     |30|31| n| n| n| n| n|
     **/
function fn_CalMain($pYear,$pMonth) {
 
    //$aCal[][];       //달력의 틀을 위한 2차원배열
    //$intVertical;  //세로줄값
    //$intWeekcnt;   //주일수
    //$i;
	//$j; 
    //$k;            //루프전체 합
    //$intDay;       //일수 값
 
    //초기값 셋팅
    $k=0;
    $intDay=1;      //일

	//세로값얻는 방법 (그달의 일수 + 첫째주빈값 + 마지막주빈값)/7=세로값
    $intVertical = (fn_monthcount($pYear,$pMonth)+fn_blankweekfirst($pYear,$pMonth)+fn_blankweeklast($pYear,$pMonth))/7;
    $intWeekcnt = 7;
 
    //배열셋팅
    // array[세로사이즈][가로사이즈]
    $aCal[$intVertical][$intWeekcnt];
 
    //배열에 값 삽입
    for ($i=0; $i<$intVertical; $i++ ) { 
        for ($j=0; $j<$intWeekcnt; $j++ ){
            $k=$k+1;
            //k의값이 첫번째주 빈값보다 작거나 같을경우는 *을 삽입
            if ($k<=fn_blankweekfirst($pYear,$pMonth)) {
                $aCal[$i][$j] = "*";
			}
            //k의값이 첫번째주빈값이상이며, 일자가 해당월의 마지막 일자 값과 작거나같을경우는 일수를 삽입
            else {
				if ($intDay<=fn_monthcount($pYear,$pMonth)) {
                $aCal[$i][$j] = $intDay;
                $intDay = $intDay+1;
				}

				//이외의 값은 *로 채운다
				else {
					$aCal[$i][$j] = "*";
				}
			}
		}
	}
    return $aCal;
}

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_smallcalendar()
     * @return  : string
     * @brief:    소형 당월 칼런다 HTML코드 출력
	 * @brief:     
     **/

function fn_smallcalendar(){
    $year = date("Y");
    $month = date("n");
    $day = date("d");
    $day_max = date("t",mktime(0,0,0,$month,1,$year));
    $week_start = date("w",mktime(0,0,0,$month,1,$year));
    $i = 0;
    $j = 0;
    $html = "<div class='calendar_box'><div class='calendar_title B'>".sprintf("%d-%02d-%02d",$year,$month,$day)."</div>";
    while ($j<$day_max){
        if ($i<$week_start) {
            $html .= "<div class='calendar_text'>·</div>";
        } else {
            if ($i%7==0) $font_color = " RED";
            else if ($i%7==6) $font_color = " BLUE";
            else $font_color = "";
            if ($day == ($j+1)) $font_weight = " B"; else $font_weight = "";
            $html .= "<div class='calendar_text$font_color$font_weight'>" . ($j+1) . "</div>";
            $j ++;
        }
        $i ++;
    }
    while ($i%7!==0){
        $html .= "<div class='calendar_text'>·</div>";
        $i ++;
    }
    $html .= "<div class='calendar_tail'></div></div>";
    return $html;
}


//--------------------------------------------------------------------------------------
    /**
     * @function: fn_sunlunar_data()
     * @return  : string(13자리-13자리-... 170개)
     * @brief:    음력-양력 변환위한 자료
     **/
function fn_sunlunar_data() { 
return "1212122322121-1212121221220-1121121222120-2112132122122-2112112121220-2121211212120-2212321121212-2122121121210-2122121212120-1232122121212-1212121221220-1121123221222-1121121212220-1212112121220-2121231212121-2221211212120-1221212121210-2123221212121-2121212212120-1211212232212-1211212122210-2121121212220-1212132112212-2212112112210-2212211212120-1221412121212-1212122121210-2112212122120-1231212122212-1211212122210-2121123122122-2121121122120-2212112112120-2212231212112-2122121212120-1212122121210-2132122122121-2112121222120-1211212322122-1211211221220-2121121121220-2122132112122-1221212121120-2121221212110-2122321221212-1121212212210-2112121221220-1231211221222-1211211212220-1221123121221-2221121121210-2221212112120-1221241212112-1212212212120-1121212212210-2114121212221-2112112122210-2211211412212-2211211212120-2212121121210-2212214112121-2122122121120-1212122122120-1121412122122-1121121222120-2112112122120-2231211212122-2121211212120-2212121321212-2122121121210-2122121212120-1212142121212-1211221221220-1121121221220-2114112121222-1212112121220-2121211232122-1221211212120-1221212121210-2121223212121-2121212212120-1211212212210-2121321212221-2121121212220-1212112112210-2223211211221-2212211212120-1221212321212-1212122121210-2112212122120-1211232122212-1211212122210-2121121122210-2212312112212-2212112112120-2212121232112-2122121212110-2212122121210-2112124122121-2112121221220-1211211221220-2121321122122-2121121121220-2122112112322-1221212112120-1221221212110-2122123221212-1121212212210-2112121221220-1211231212222-1211211212220-1221121121220-1223212112121-2221212112120-1221221232112-1212212122120-1121212212210-2112132212221-2112112122210-2211211212210-2221321121212-2212121121210-2212212112120-1232212122112-1212122122110-2121212322122-1121121222120-2112112122120-2211231212122-2121211212120-2122121121210-2124212112121-2122121212120-1212121223212-1211212221220-1121121221220-2112132121222-1212112121220-2121211212120-2122321121212-1221212121210-2121221212120-1232121221212-1211212212210-2121123212221-2121121212220-1212112112220-1221231211221-2212211211220-1212212121210-2123212212121-2112122122120-1211212322212-1211212122210-2121121122120-2212114112122-2212112112120-2212121211210-2212232121211-2122122121210-2112122122120-1231212122212-1211211221220-2121121321222-2121121121220-2122112112120-2122141211212-1221221212110-2121221221210-2114121221221";   //1881-2050
} 

//------------------------------------------------------------------------

    /**
     * @function: fn_lun2sol($pYear,$pMonth,$pDay)
     * @return  : string(yyyy-mm-dd-요일)
     * @brief:    음력을 양력으로 변환하는 함수
     **/
function fn_lun2sol($pYear,$pMonth,$pDay) { 
$getYEAR = (int)$pYear; 
$getMONTH = (int)$pMonth; 
$getDAY = (int)$pDay; 
//$getYEAR = (int)substr($yyyymmdd,0,4); 
//$getMONTH = (int)substr($yyyymmdd,4,2); 
//$getDAY = (int)substr($yyyymmdd,6,2); 

$arrayDATASTR = fn_sunlunar_data(); 
$arrayDATA = explode("-",$arrayDATASTR); 

$arrayLDAYSTR="31-0-31-30-31-30-31-31-30-31-30-31"; 
$arrayLDAY = explode("-",$arrayLDAYSTR); 

$arrayYUKSTR="갑-을-병-정-무-기-경-신-임-계"; 
$arrayYUK = explode("-",$arrayYUKSTR); 

$arrayGAPSTR="자-축-인-묘-진-사-오-미-신-유-술-해"; 
$arrayGAP = explode("-",$arrayGAPSTR); 

$arrayDDISTR="쥐-소-호랑이-토끼-용-뱀-말-양-원숭이-닭-개-돼지"; 
$arrayDDI = explode("-",$arrayDDISTR); 

$arrayWEEKSTR="일-월-화-수-목-금-토"; 
$arrayWEEK = explode("-",$arrayWEEKSTR); 

if ($getYEAR <= 1881 || $getYEAR >= 2050) { //년수가 해당일자를 넘는 경우 
$YunMonthFlag = 0; 
return false; //년도 범위가 벗어남.. 
} 
if ($getMONTH > 12) { // 달수가 13이 넘는 경우 
$YunMonthFlag = 0; 
return false; //달수 범위가 벗어남.. 
} 
$m1 = $getYEAR - 1881; 
if (substr($arrayDATA[$m1],12,1) == 0) { // 윤달이 없는 해임 
$YunMonthFlag = 0; 
} else { 
if (substr($arrayDATA[$m1],$getMONTH, 1) > 2) { 
$YunMonthFlag = 1; 
} else { 
$YunMonthFlag = 0; 
} 
} 
//------------- 
$m1 = -1; 
$td = 0; 

if ($getYEAR > 1881 && $getYEAR < 2050) { 
$m1 = $getYEAR - 1882; 
for ($i=0;$i<=$m1;$i++) { 
for ($j=0;$j<=12;$j++) { 
$td = $td + (substr($arrayDATA[$i],$j,1)); 
} 
if (substr($arrayDATA[$i],12,1) == 0) { 
$td = $td + 336; 
} else { 
$td = $td + 362; 
} 
} 
} else { 
$gf_lun2sol = 0; 
} 

$m1++; 
$n2 = $getMONTH - 1; 
$m2 = -1; 

while(1) { 
$m2++; 
if (substr($arrayDATA[$m1], $m2, 1) > 2) { 
$td = $td + 26 + (substr($arrayDATA[$m1], $m2, 1)); 
$n2++; 
} else { 
if ($m2 == $n2) { 
if ($gf_yun) { 
$td = $td + 28 + (substr($arrayDATA[$m1], $m2, 1)); 
} 
break; 
} else { 
$td = $td + 28 + (substr($arrayDATA[$m1], $m2, 1)); 
} 
} 
} 

$td = $td + $getDAY + 29; 
$m1 = 1880; 
while(1) { 
$m1++; 
if ($m1 % 400 == 0 || $m1 % 100 != 0 && $m1 % 4 == 0) { 
$leap = 1; 
} else { 
$leap = 0; 
} 

if ($leap == 1) { 
$m2 = 366; 
} else { 
$m2 = 365; 
} 

if ($td < $m2) break; 

$td = $td - $m2; 
} 
$syear = $m1; 
$arrayLDAY[1] = $m2 - 337; 

$m1 = 0; 

while(1) { 
$m1++; 
if ($td <= $arrayLDAY[$m1-1]) { 
break; 
} 
$td = $td - $arrayLDAY[$m1-1]; 
} 
$smonth = $m1; 
$sday = $td; 
$y = $syear - 1; 
$td = intval($y*365) + intval($y/4) - intval($y/100) + intval($y/400); 

if ($syear % 400 == 0 || $syear % 100 != 0 && $syear % 4 == 0) { 
$leap = 1; 
} else { 
$leap = 0; 
} 

if ($leap == 1) { 
$arrayLDAY[1] = 29; 
} else { 
$arrayLDAY[1] = 28; 
} 
for ($i=0;$i<=$smonth-2;$i++) { 
$td = $td + $arrayLDAY[$i]; 
} 
$td = $td + $sday; 
$w = $td % 7; 

$sweek = $arrayWEEK[$w]; 
$gf_lun2sol = 1; 

return($syear."-".$smonth."-".$sday."-".$sweek."-".$YunMonthFlag);
} 

//--------------------------------------------------------------------------------------

    /**
     * @function: fn_sol2lun($pYear,$pMonth,$pDay)
     * @return  : string(yyyy-mm-dd-간지-띠)
     * @brief:    양력을 음력으로 변환하는 함수
     **/
function fn_sol2lun($pYear,$pMonth,$pDay) {
$getYEAR = $pYear;
$getMONTH = $pMonth;
$getDAY = $pDay;
//$getYEAR = (int)substr($yyyymmdd,0,4);
//$getMONTH = (int)substr($yyyymmdd,4,2);
//$getDAY = (int)substr($yyyymmdd,6,2);

$arrayDATASTR = fn_sunlunar_data();
$arrayDATA = explode("-",$arrayDATASTR);

$arrayLDAYSTR="31-0-31-30-31-30-31-31-30-31-30-31";
$arrayLDAY = explode("-",$arrayLDAYSTR);

$arrayYUKSTR="갑-을-병-정-무-기-경-신-임-계";
$arrayYUK = explode("-",$arrayYUKSTR);

$arrayGAPSTR="자-축-인-묘-진-사-오-미-신-유-술-해";
$arrayGAP = explode("-",$arrayGAPSTR);

$arrayDDISTR="쥐-소-호랑이-토끼-용-뱀-말-양-원숭이-닭-개-돼지";
$arrayDDI = explode("-",$arrayDDISTR);

$arrayWEEKSTR="일-월-화-수-목-금-토";
$arrayWEEK = explode("-",$arrayWEEKSTR);

$dt = $arrayDATA;

for ($i=0;$i<=168;$i++) {
    $dt[$i] = 0;
    for ($j=0;$j<12;$j++) {
        switch (substr($arrayDATA[$i],$j,1)) {
        case 1:
        $dt[$i] += 29;
        break;
        case 3:
        $dt[$i] += 29;
        break;
        case 2:
        $dt[$i] += 30;
        break;
        case 4:
        $dt[$i] += 30;
        break;
        }
    }

    switch (substr($arrayDATA[$i],12,1)) {
    case 0:
    break;
    case 1:
    $dt[$i] += 29;
    break;
    case 3:
    $dt[$i] += 29;
    break;
    case 2:
    $dt[$i] += 30;
    break;
    case 4:
    $dt[$i] += 30;
    break;
    }
}


$td1 = 1880 * 365 + (int)(1880/4) - (int)(1880/100) + (int)(1880/400) + 30;
$k11 = $getYEAR - 1;

$td2 = $k11 * 365 + (int)($k11/4) - (int)($k11/100) + (int)($k11/400);

if ($getYEAR % 400 == 0 || $getYEAR % 100 != 0 && $getYEAR % 4 == 0) {
    $arrayLDAY[1] = 29;
    }
    else {
    $arrayLDAY[1] = 28;
    }

if ($getMONTH > 13) {
    $gf_sol2lun = 0;
}

if ($getDAY > $arrayLDAY[$getMONTH-1]) {
    $gf_sol2lun = 0;
}

for ($i=0;$i<=$getMONTH-2;$i++) {
    $td2 += $arrayLDAY[$i];
}

$td2 += $getDAY;
$td = $td2 - $td1 + 1;
$td0 = $dt[0];

for ($i=0;$i<=168;$i++) {
    if ($td <= $td0) {
    break;
    }
    $td0 += $dt[$i+1];
}

$ryear = $i + 1881;
$td0 -= $dt[$i];
$td -= $td0;

if (substr($arrayDATA[$i], 12, 1) == 0) {
    $jcount = 11;
    }
    else {
        $jcount = 12;
    }
$m2 = 0;

for ($j=0;$j<=$jcount;$j++) { // 달수 check, 윤달 > 2 (by harcoon)
    if (substr($arrayDATA[$i],$j,1) <= 2) {
        $m2++;
        $m1 = substr($arrayDATA[$i],$j,1) + 28;
        $gf_yun = 0;
        $yundal = null;     // add ksc
    }
    else {
        $m1 = substr($arrayDATA[$i],$j,1) + 26;
        $gf_yun = 1;
        $yundal = "윤달"; // add ksc
    }
    if ($td <= $m1) {
    break;
    }
    $td = $td - $m1;
}

$k1=($ryear+6) % 10;
$syuk = $arrayYUK[$k1];
$k2=($ryear+8) % 12;
$sgap = $arrayGAP[$k2];
$sddi = $arrayDDI[$k2];

$gf_sol2lun = 1;

return ($ryear."-".$m2."-".$td."-".$syuk.$sgap."년-".$sddi."띠-".$yundal);
}

//------------------------------------------------------------------------
    /**
     * @function: fn_sol2lun_ary($pYear, $pMonth)
     * @return  : array
     * @brief:    년간 양력 일자에 대응되는 음력일자 어레이 리턴
     **/
Function fn_sol2lun_ary($pYear, $pMonth) {
    /******************************************************
    *년간 양력 일자에 대응되는 음력일자 어레이 (예:2009-7-15-윤달)
    *******************************************************/

//  For ($i = 0; $i<13; $i++) {
//      For ($j = 0; $j <32; $j++ ) {
//          $aHoli[$i][$j] = null;
//      }
//  }
    $aHoli = null;

    for ($i=$pMonth; $i < $pMonth+1; $i++ ) {   //당월만
        for ($j=0; $j < 32; $j++ ) {
            if ($i > 0 && $j>0 && $j < 32) {      // 1-12
                $temp01 = explode("-",fn_sol2lun($pYear,$i,$j));
                $iSunYmd =$temp01[0]."-".$temp01[1]."-".$temp01[2];

                if ($temp01[5] != null) {   //윤달일 경우 - 붙여서 출력
                $Yundal = "-".$temp01[5];
                }
                else {
                    $Yundal = null;
                }

                $aHoli[$i][$j] = $iSunYmd.$Yundal;
            }
        }
    }
    return $aHoli;
}

//-----------------------------------------------------------------------------------
     /**
     * @function: fn_easterday($pYear)
     * @return  : string
     * @brief:    해당년 부활절 일자를 구한다
     **/
function fn_easterday($pYear) {
    $k=easter_days($pYear);
    if ($k>10) {
        $wrkYmd =date("Y-n-j", mktime(0, 0, 0,4, $k-10, $pYear));
    }
    else   {
        $wrkYmd =date("Y-n-j", mktime(0, 0, 0,3, $k+21, $pYear));
    }
    return $wrkYmd;
}

//-----------------------------------------------------------------------------------
	 /**
     * @function: fn_easterday_2($pYear)
     * @return  : string
     * @brief:    해당년 부활절 일자를 구한다 (가우스공식이용) - 간혹 PHP에서 부활절함수 지원 안될때 이용
     **/
function fn_easterday_2($pYear) {
 $M = 24; // 1900-2099 년도분만 사용
 $N = 5;  // 1900-2099 년도분만 사용
    $A = $pYear % 19;
    $B = $pYear % 4;
    $C = $pYear % 7;
    $D = (19 * $A + $M) % 30;
    $E = ((2 * $B) + (4 * $C) + (6 * $D) + $N) % 7;
    $Tag1 = (22 + $D + $E);
    $Tag2 = ($D + $E - 9);

 if($Tag1 <= 31 ) {
   $easterday = mktime(0, 0, 0, 3, $Tag1, $pYear); // 3월 부활절 일자 타임스탬프
   $wrkYmd =date("Y-n-j", $easterday);
  }
  else {
   $easterday = mktime(0, 0, 0, 4, $Tag2, $pYear); // 4월 부활절 일자 타임스탬프
   $wrkYmd =date("Y-n-j", $easterday);
  }

    return $wrkYmd;
}
//--------------------------------------------------------------------------------------

//--------------------------------------------------------------------------------------
    /**
     * @function: fn_HolidayChk($pYear, $pMonth)
     * @function: fn_MemdayChk($pYear, $pMonth)
     * @brief:    휴일 기념일 함수는 별도로 분리함
     **/
//------------------------------------------------------------------------

//------------------------------------------------------------------------
	/**
     * @function: fn_repeat_schedule($pYear, $pMonth, $plan_start, $plan_end, $plan_repeat_cycle, $plan_repeat_unit)
     * @return  : array
     * @brief:    반복일정이 적용되는 양력일자 어레이 리턴
     **/
Function fn_repeat_schedule($pYear, $pMonth, $plan_start, $plan_end, $plan_repeat_cycle, $plan_repeat_unit) {
	/******************************************************
	* 반복일정이 적용되는 일자에 "*" 삽입
	* 반복일정은 일정시작일을 기준으로 반복되며, 모든 반복일정은 일정 자체의 기간은 1일 간으로한다.
	* 그렇지 않을경우 일정자체의 기간을 지정할 2개의 추가 확장변수가 필요하게 되어 실익이 없다.
	*******************************************************/

	$aHoli = null;

	if ($plan_start == null ) {	
		return $aHoli;
	}

	$startYY = substr($plan_start,0,4);
	$startMM = ltrim(substr($plan_start,4,2), "0" );	//  앞의 "0" 제거
	$startDD = ltrim(substr($plan_start,6,2), "0" );	//  앞의 "0" 제거
	$plnstartYY = $startYY;
	$plnstartMM = $startMM;	
	$plnstartDD = $startDD;	

	$endYY = substr($plan_end,0,4);
	$endMM = ltrim(substr($plan_end,4,2), "0" );	// 일자 앞의 "0" 제거
	$endDD = ltrim(substr($plan_end,6,2), "0" );	// 일자 앞의 "0" 제거
	$plnendYY = $endYY;
	$plnendMM = $endMM;	
	$plnendDD = $endDD;	

	$plan_startdate = mktime(0, 0, 0, $startMM, $startDD, $startYY);	// 일정시작 일자 타임스탬프
	$plan_enddate = mktime(0, 0, 0, $endMM, $endDD, $endYY);			// 일정종료 일자 타임스탬프

	$k = 12;		// 1년간 반복일정 처리 (월 반복일정)

	if ($plnstartYY == $pYear && $plnstartMM == $pMonth) {				// 당월 시작 이면서 당월 이후 종료
		if ($plnendYY > $pYear || $plnendYY == $pYear && $plnendMM > $pMonth) {
					$plnendYY = $pYear;
					$plnendMM = $pMonth;
					$plnendDD = 31;
		}
	}
	elseif ($plnstartYY < $pYear || $plnstartYY == $pYear && $plnstartMM < $pMonth) {	// 당월 이전 시작 이면서 당월 종료
		if ($plnendYY == $pYear && $plnendMM == $pMonth) {
					$plnstartYY = $pYear;
					$plnstartMM = $pMonth;
					$plnstartDD = 1;
		}
		if ($plnendYY > $pYear || $plnendYY == $pYear && $plnendMM > $pMonth) { // 당월 이전시작 이면서 당월 이후 종료
					$plnstartYY = $pYear;
					$plnstartMM = $pMonth;
					$plnstartDD = 1;
					$plnendYY = $pYear;
					$plnendMM = $pMonth;
					$plnendDD = 31;
		}
	}

	// plan_repeat_cycle 또는 plan_repeat_unit 값이 null 일때********************
	if ($plan_repeat_unit == null || $plan_repeat_cycle == null ) {	
		if ( $plnstartYY == $pYear && $plnstartMM == $pMonth) {	
			For	($i = $plnstartMM; $i <= $plnendMM; $i++) {
				For ($j = $plnstartDD; $j <= $plnendDD; $j++ ) {
					$aHoli[$i][$j] =  "*";	
				}
			}
		}
	}

	// unit 값이 1.일(간격) : 몇일 간결으로 반복***********************************
	elseif (substr($plan_repeat_unit,0,1) == "1" && $plan_repeat_cycle != null ) {	
		$k = date("t", mktime(0, 0, 0, $pMonth, 1, $pYear));	// 당월 마지막 날자
		For	($i = 1; $i <= $k; $i++ ) {
			if(!(((mktime(0, 0, 0, $pMonth, $i, $pYear)-$plan_startdate)/86400)%$plan_repeat_cycle)) { 
				$wrkday= $startDD + ($plan_repeat_cycle * $i);
				$wrkYY = date("Y", mktime(0, 0, 0, $pMonth, $i, $pYear));	// 반복될 일자-년
				$wrkMM = date("n", mktime(0, 0, 0, $pMonth, $i, $pYear));	// 반복될 일자-월
				$wrkDD = date("j", mktime(0, 0, 0, $pMonth, $i, $pYear));	// 반복될 일자-일
				$work_date = mktime(0, 0, 0, $wrkMM, $wrkDD, $wrkYY);				// 반복 일자 타임스탬프
				if( $work_date >= $plan_startdate && $work_date <= $plan_enddate && $pYear == $wrkYY) {	
					$aHoli[$wrkMM][$wrkDD] =  "*";	
				}
			}
		}
	}
	// 2.개월(날자): 반복월 같은 날자**********************************************
	elseif (substr($plan_repeat_unit,0,1) == "2" && $plan_repeat_cycle != null ) {
		if(!((($pYear*12 + $pMonth)-($startYY*12 + $startMM))%$plan_repeat_cycle)) { 
			$wrkYY = date("Y", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-년
			$wrkMM = date("n", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-월
			$wrkDD = date("j", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-일
			$work_date = mktime(0, 0, 0, $wrkMM, $wrkDD, $wrkYY);				// 반복 일자 타임스탬프
			if( $work_date >= $plan_startdate && $work_date <= $plan_enddate && $pYear == $wrkYY) {	
				$aHoli[$wrkMM][$wrkDD] =  "*";	
			}
		}
	}
	// 3.개월(요일): 반복월 같은번째 요일*******************************************
	elseif (substr($plan_repeat_unit,0,1) == "3" && $plan_repeat_cycle != null ) {	
		$pYoil = date("w", mktime(0, 0, 0,$startMM, $startDD, $startYY));	//해당일의 요일번호(일=0, 토=6)
		$yoilcount = fn_weekdaycountofmonth($startYY,$startMM,$startDD);		// n번째 요일 숫자
		if(!((($pYear*12 + $pMonth)-($startYY*12 + $startMM))%$plan_repeat_cycle)) { 
			$wrkYY = date("Y", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-년
			$wrkMM = date("n", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-월
			$wrkDD = date("j", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-일
			$temp01 = explode("-",fn_nsweekday($wrkYY, $wrkMM, $yoilcount, $pYoil));	// 해당n번째요일에 대응되는 일자 얻기
			$work_date = mktime(0, 0, 0, $temp01[1], $temp01[2], $temp01[0]);			// 반복 일자 타임스탬프
			if( $work_date >= $plan_startdate && $work_date <= $plan_enddate && $pYear == $wrkYY) {	
				$aHoli[$temp01[1]][$temp01[2]] =  "*";	
			}
		}
	}
	// 4.개월(주): 반복월 같은번째 주 같은요일**************************************
	elseif (substr($plan_repeat_unit,0,1) == "4" && $plan_repeat_cycle != null ) {	
		$pYoil = date("w", mktime(0, 0, 0,$startMM, $startDD, $startYY));	//해당일의 요일번호(일=0, 토=6)
		$weekcount = fn_weekcountofmonth($startYY,$startMM,$startDD);			//n번째 주 숫자
		if(!((($pYear*12 + $pMonth)-($startYY*12 + $startMM))%$plan_repeat_cycle)) { 
			$wrkYY = date("Y", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-년
			$wrkMM = date("n", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-월
			$wrkDD = date("j", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-일
			$temp01 = explode("-",fn_nsweeknsweekday($wrkYY, $wrkMM, $weekcount, $pYoil));	// 해당주/요일에 대응되는 일자 얻기
			$work_date = mktime(0, 0, 0, $temp01[1], $temp01[2], $temp01[0]);				// 반복 일자 타임스탬프
			if( $work_date >= $plan_startdate && $work_date <= $plan_enddate && $pYear == $wrkYY) {	
				$aHoli[$temp01[1]][$temp01[2]] =  "*";	
			}
		}
	}
	// 5.개월(말일): 반복월 말일****************************************************
	elseif (substr($plan_repeat_unit,0,1) == "5" && $plan_repeat_cycle != null ) {	
		if(!((($pYear*12 + $pMonth)-($startYY*12 + $startMM))%$plan_repeat_cycle)) { 
			$wrkYY = date("Y", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-년
			$wrkMM = date("n", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-월
			$wrkDD = date("j", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-일
			$wrklastday= date("t", mktime(0, 0, 0, $wrkMM, 1, $wrkYY));	// 반복될 마지막 날자
			$work_date = mktime(0, 0, 0, $wrkMM, $wrklastday, $wrkYY);			// 반복 일자 타임스탬프
			if( $work_date >= $plan_startdate && $work_date <= $plan_enddate && $pYear == $wrkYY) {	
				$aHoli[$wrkMM][$wrklastday] =  "*";	
			}
		} 
	} 
    // 6.개월(월말부터요일차): 반복월 끝에서부터 같은번째 요일****************************************************
    elseif (substr($plan_repeat_unit,0,1) == "6" && $plan_repeat_cycle != null ) {
        $pYoil = date("w", mktime(0, 0, 0,$startMM, $startDD, $startYY));    //해당일의 요일번호(일=0, 토=6)
        $yoilcount = fn_weekdaycountofmonth_end($startYY,$startMM,$startDD); //해당일의 말일에서부터의 n번째 요일 숫자
		if(!((($pYear*12 + $pMonth)-($startYY*12 + $startMM))%$plan_repeat_cycle)) { 
			$wrkYY = date("Y", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-년
			$wrkMM = date("n", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-월
			$wrkDD = date("j", mktime(0, 0, 0, $pMonth, $startDD, $pYear));	// 반복될 일자-일
            $temp01 = explode("-",fn_nslastweekday($wrkYY, $wrkMM, $yoilcount, $pYoil)); // 끝에서 n번째요일에 대응되는 일자 얻기
            $work_date = mktime(0, 0, 0, $temp01[1], $temp01[2], $temp01[0]);           // 반복 일자 타임스탬프
            if( $work_date >= $plan_startdate && $work_date <= $plan_enddate && $pYear == $wrkYY) {
                $aHoli[$temp01[1]][$temp01[2]] =  "*";
            }
        }
    }

	return $aHoli;
}

//------------------------------------------------------------------------
    /**
     * @brief XE에 설정된 타임존을 반영한 시간값을 구함
     * @param none,  XE함수 zgap() 사용
     * @return int
     **/
function fn_xetimestamp() {
	$localtimestamp = mktime(date("H"), date("i"), date("s")+zgap(), date("m"), date("d"), date("Y"));
	return $localtimestamp;
}

?>
