<?php
    /**
     * @class  couponItem
     * @author SMaker (dowon2308@paran.com)
     * @brief  coupon 객체
     **/

    class couponItem extends Object {

        var $coupon_srl = 0;

        function couponItem($coupon_srl = 0) {
            $this->coupon_srl = $coupon_srl;

            $this->_loadFromDB();
        }

        function setCoupon($coupon_srl) {
            $this->coupon_srl = $coupon_srl;
            $this->_loadFromDB();
        }

        function setCode($code) {
            $this->code = $code;
            $this->_loadFromDB();
        }

        function _loadFromDB() {
            if(!$this->coupon_srl && !$this->code) return;

            if($this->coupon_srl) $args->coupon_srl = $this->coupon_srl;
            $args->code = $this->code;
            $output = executeQuery('coupon.getCoupon', $args);

            $this->setAttribute($output->data);
        }

        function setAttribute($attribute) {
            if(!$attribute->coupon_srl) {
                $this->coupon_srl = null;
                return;
            }
            $this->coupon_srl = $attribute->coupon_srl;
            $this->member_srl = $attribute->member_srl;
            $this->code = $attribute->code;
            $this->point = $attribute->point;
            $this->extra_vars = $attribute->extra_vars;
            $this->adds($attribute);

            $GLOBALS['XE_COUPON_LIST'][$this->coupon_srl] = $this;
            $GLOBALS['XE_COUPON_LIST'][$attribute->code] = $this;
        }

        /**
         * @brief 쿠폰이 존재하는 지 확인하는 method
         */
        function isExists() {
            return $this->coupon_srl ? true : false;
        }

        /**
         * @brief 쿠폰을 사용한 적이 있는 지 확인하는 method
         **/
        function isUsed() {
            $logged_info = Context::get('logged_info');
            if(!$logged_info) return;

            //쿠폰 사용 기록이 있는지 확인
            $args->coupon_srl = $this->coupon_srl;
            $args->member_srl = $logged_info->member_srl;
            $output = executeQuery('coupon.getCouponUsedLogCount', $args);
            if($output->data->count) return true;

            // 사용 제한이 있다면
            if($this->get('limit') > 0) {
                $args->coupon_srl = $this->coupon_srl;
                $output = executeQuery('coupon.getCouponUsedLogCount', $args);
                if($output->data->count >= $this->get('limit')) return true;
            }

            return false;
        }

        /**
         * @brief 쿠폰을 사용할 수 있는지 확인하는 method
         */
        function isUseable() {
            // 존재하지 않는 쿠폰이면 return false
            if(!$this->isExists()) return false;

            // 사용 권한이 없는 쿠폰이면 return false
            if(!$this->isGranted()) return false;

            // 쿠폰을 사용한 적이 있다면 return false
            if($this->isUsed()) return false;

            // 만료일이 지났으면 return false
            if($this->get('expire_date') && date('Ymd') > $this->get('expire_date')) return false;

            return true;
        }

        /**
         * @brief 쿠폰 사용 권한이 있는지 확인하는 method
         */
        function isGranted() {
            $logged_info = Context::get('logged_info');

            if(!$this->member_srl) return true;
            if($this->member_srl == $logged_info->member_srl) return true;

            return false;
        }

        /**
         * @brief 쿠폰이 만료되었는지 확인하는 method
         */
        function isExpired() {
            return $this->get('expire_date') && date('Ymd') > $this->get('expire_date') ? true : false;
        }

        function getPoint() {
            return $this->get('point');
        }

        function getExpireDate($format = 'Y-m-d') {
            return zdate($this->get('expire_date'), $format);
        }
    }
?>
