<?php
    /**
     * @class  couponAdminController
     * @author zero (zero@nzeo.com)
     * @brief  coupon module의 admin controller class
     **/

    class couponAdminController extends coupon {

        /**
         * @brief 초기화
         **/
        function init() {
        }

        /**
         * @brief 설정 저장
         */
        function procCouponAdminInsertConfig() {
            $config = Context::getRequestVars();
            if(!$config->skin) $config->skin = 'default';

            $oModuleController = &getController('module');
            $oModuleController->insertModuleConfig('coupon', $config);

            $this->setMessage('success_saved');
        }

        /**
         * @brief 쿠폰 발급
         **/
        function procCouponAdminInsertCoupon() {
            // 필수 정보들을 미리 추출
            $args = Context::gets('coupon_code','coupon_code2','coupon_code3','point','coupon_limit','expire_date');

            // 쿠폰 코드가 정상적으로 넘어왔는지 확인
            if(!$args->coupon_code || !$args->coupon_code2 || !$args->coupon_code3) return new Object(-1, 'msg_input_coupon_code');

            $args->code = sprintf('%s-%s-%s', $args->coupon_code, $args->coupon_code2, $args->coupon_code3);

            // 발급된 쿠폰 코드인지 확인
            $oModel = &getModel('coupon');
            $oCoupon = $oModel->getCouponByCode($args->code);

            // 발급된 쿠폰 코드일 경우 에러
            if($oCoupon->isExists()) return new Object(-1, 'msg_exists_coupon_code');

            // 확장 변수만 골라냄
            $extra_vars = Context::getRequestVars();
            unset($extra_vars->_filter);
            unset($extra_vars->module);
            unset($extra_vars->act);
            unset($extra_vars->body);
            unset($extra_vars->code);
            unset($extra_vars->point);
            unset($extra_vars->coupon_code);
            unset($extra_vars->coupon_code2);
            unset($extra_vars->coupon_code3);
            unset($extra_vars->coupon_limit);
            unset($extra_vars->expire_date);

            // 쿠폰 등록
            $oController = &getController('coupon');
            $oController->insertCoupon($args, $extra_vars);

            // 메시지 지정
            $this->setMessage('success_coupon_inserted');
        }

        function procCouponAdminGenerateCode() {
            // 비정상적인 접근 방지를 위해 XMLRPC로 요청된 것만 받아들임
            if(Context::getResponseMethod() != 'XMLRPC') return new Object(-1, 'msg_invalid_request');

            // 코드 생성
            $oModel = &getModel('coupon');
            $code = $oModel->generateCode();

            // 생성된 코드를 분리
            list($code1, $code2, $code3) = explode('-', $code);

            // 각각의 분리된 코드를 넘겨줌
            $this->add('code', $code1);
            $this->add('code2', $code2);
            $this->add('code3', $code3);
        }
    }
?>
