<?php
    /**
     * @class  commentModel
     * @author NHN (developers@xpressengine.com)
     * @brief  comment  model class
     **/

    class commentModel extends comment {

        /**
         * @brief ʱȭ
         **/
        function init() {
        }

        /**
         * @brief õ Խù ˾޴ ǥ
         *
         * μ, ũ, õ, õ, Ű  ߰
         **/
        function getCommentMenu() {

            // û Խù ȣ  α  
            $comment_srl = Context::get('target_srl');
            $mid = Context::get('cur_mid');
            $logged_info = Context::get('logged_info');
            $act = Context::get('cur_act');
            
            // menu_list  "ǥұ,target,url"  迭 ִ´
            $menu_list = array();

            // trigger ȣ
            ModuleHandler::triggerCall('comment.getCommentMenu', 'before', $menu_list);

            $oCommentController = &getController('comment');

            // ȸ̾߸  
            if($logged_info->member_srl) {

                // õ ư ߰
                $url = sprintf("doCallModuleAction('comment','procCommentVoteUp','%s')", $comment_srl);
                $oCommentController->addCommentPopupMenu($url,'cmd_vote','./modules/document/tpl/icons/vote_up.gif','javascript');

                // õ ư ߰
                $url = sprintf("doCallModuleAction('comment','procCommentVoteDown','%s')", $comment_srl);
                $oCommentController->addCommentPopupMenu($url,'cmd_vote_down','./modules/document/tpl/icons/vote_down.gif','javascript');

                // Ű  ߰
                $url = sprintf("doCallModuleAction('comment','procCommentDeclare','%s')", $comment_srl);
                $oCommentController->addCommentPopupMenu($url,'cmd_declare','./modules/document/tpl/icons/declare.gif','javascript');
            }

            // trigger ȣ (after)
            ModuleHandler::triggerCall('comment.getCommentMenu', 'after', $menu_list);

            //   ip  ã
            if($logged_info->is_admin == 'Y') {
                $oCommentModel = &getModel('comment');
                $oComment = $oCommentModel->getComment($comment_srl);

                if($oComment->isExists()) {
                    // ipּҿ شϴ  ã
                    $url = getUrl('','module','admin','act','dispCommentAdminList','search_target','ipaddress','search_keyword',$oComment->get('ipaddress'));
                    $icon_path = './modules/member/tpl/images/icon_management.gif';
                    $oCommentController->addCommentPopupMenu($url,'cmd_search_by_ipaddress',$icon_path,'TraceByIpaddress');

                    $url = sprintf("var params = new Array(); params['ipaddress']='%s'; exec_xml('spamfilter', 'procSpamfilterAdminInsertDeniedIP', params, completeCallModuleAction)", $oComment-> getIpAddress());
                    $oCommentController->addCommentPopupMenu($url,'cmd_add_ip_to_spamfilter','./modules/document/tpl/icons/declare.gif','javascript');
                }
            }

            // ˾޴  
            $menus = Context::get('comment_popup_menu_list');
            $menus_count = count($menus);
            for($i=0;$i<$menus_count;$i++) {
                $menus[$i]->str = Context::getLang($menus[$i]->str);
            }

            //   ˾޴  
            $this->add('menus', $menus);
        }


        /**
         * @brief comment_srl  ִ üũ
         *
         *   ̿
         **/
        function isGranted($comment_srl) {
            return $_SESSION['own_comment'][$comment_srl];
        }

        /**
         * @brief ڽ   
         **/
        function getChildCommentCount($comment_srl) {
            $args->comment_srl = $comment_srl;
            $output = executeQuery('comment.getChildCommentCount', $args);
            return (int)$output->data->count;
        }

        /**
         * @brief  
         **/
        function getComment($comment_srl=0, $is_admin = false) {
            $oComment = new commentItem($comment_srl);
            if($is_admin) $oComment->setGrant();

            return $oComment;
        }

        /**
         * @brief  ۵  (¡ ƴ)
         **/
        function getComments($comment_srl_list) {
            if(is_array($comment_srl_list)) $comment_srls = implode(',',$comment_srl_list);

            // DB 
            $args->comment_srls = $comment_srls;
            $output = executeQuery('comment.getComments', $args);
            if(!$output->toBool()) return;
            $comment_list = $output->data;
            if(!$comment_list) return;
            if(!is_array($comment_list)) $comment_list = array($comment_list);

            $comment_count = count($comment_list);
            foreach($comment_list as $key => $attribute) {
                if(!$attribute->comment_srl) continue;
                $oComment = null;
                $oComment = new commentItem();
                $oComment->setAttribute($attribute);
                if($is_admin) $oComment->setGrant();

                $result[$attribute->comment_srl] = $oComment;
            }
            return $result;
        }

        /**
         * @brief document_srl  شϴ  ü  
         **/
        function getCommentCount($document_srl) {
            $args->document_srl = $document_srl;
            $output = executeQuery('comment.getCommentCount', $args);
            $total_count = $output->data->count;
            return (int)$total_count;
        }


        /**
         * @brief module_srl  شϴ  ü  
         **/
        function getCommentAllCount($module_srl) {
            $args->module_srl = $module_srl;
			$output = executeQuery('comment.getCommentCount', $args);
			$total_count = $output->data->count;
			
            return (int)$total_count;
        }


        /** 
         * @brief mid  شϴ  
         **/
        function getNewestCommentList($obj) {
            if($obj->mid) {
                $oModuleModel = &getModel('module');
                $obj->module_srl = $oModuleModel->getModuleSrlByMid($obj->mid);
                unset($obj->mid);
            }

            // Ѿ module_srl array  ֱ⿡ array üũ 
            if(is_array($obj->module_srl)) $args->module_srl = implode(',', $obj->module_srl);
            else $args->module_srl = $obj->module_srl;
            $args->list_count = $obj->list_count;

            $output = executeQuery('comment.getNewestCommentList', $args);
            if(!$output->toBool()) return $output;

            $comment_list = $output->data;
            if($comment_list) {
                if(!is_array($comment_list)) $comment_list = array($comment_list);
                $comment_count = count($comment_list);
                foreach($comment_list as $key => $attribute) {
                    if(!$attribute->comment_srl) continue;
                    $oComment = null;
                    $oComment = new commentItem();
                    $oComment->setAttribute($attribute);

                    $result[$key] = $oComment;
                }
                $output->data = $result;
            }
            return $result;
        }

        /** 
         * @brief document_srl شϴ    
         **/
        function getCommentList($document_srl, $page = 0, $is_admin = false, $count = 0) {
            // ش  ⿡ شϴ   
            $oDocumentModel = &getModel('document');
            $oDocument = $oDocumentModel->getDocument($document_srl);

            //    return~
            if(!$oDocument->isExists()) return;

            // ۼ  return~
            if($oDocument->getCommentCount()<1) return;

            //  ۼ    
            $module_srl = $oDocument->get('module_srl');

            if(!$count) {
                $comment_config = $this->getCommentConfig($module_srl);
                $comment_count = $comment_config->comment_count;
                if(!$comment_count) $comment_count = 50;
            } else {
                $comment_count = $count;
            }

            //      
            if(!$page) $page = (int)( ($oDocument->getCommentCount()-1) / $comment_count) + 1;                

            //     ؿ
            $args->document_srl = $document_srl;
            $args->list_count = $comment_count;
            $args->page = $page;
            $args->page_count = 10;

			// sejin7940 (101105) -       ҽ  ()
            $oModuleModel = &getModel('module');
			$board_info = $oModuleModel -> getModuleSkinVars($module_srl);
			$use_comment_reverse = $board_info[use_comment_reverse]->value;

			if($use_comment_reverse=="Y") $output = executeQueryArray('comment.getCommentPageListReverse', $args);
            else $output = executeQueryArray('comment.getCommentPageList', $args);
			// sejin7940 (101105) -       ҽ  ()




            //     ׳ return
            if(!$output->toBool()) return;

            //  ؿ   ۼ ٸٸ  ͷ Ǵϰ   ̺  Է
            if(!$output->data) {
                $this->fixCommentList($oDocument->get('module_srl'), $document_srl);
                $output = executeQueryArray('comment.getCommentPageList', $args);
                if(!$output->toBool()) return;
            }

            return $output;
        }
            
        /**
         * @brief document_srl شϴ   
         * Ĺ  Ǵ ͸  ó
         **/
        function fixCommentList($module_srl, $document_srl) {
            // ϰ ۾̶ lock  Ͽ ߺ ۾  ʵ Ѵ
            $lock_file = "./files/cache/tmp/lock.".$document_srl;
            if(file_exists($lock_file) && filemtime($lock_file)+60*60*10<time()) return;
            FileHandler::writeFile($lock_file, '');

            //  
            $args->document_srl = $document_srl;
            $args->list_order = 'list_order';
            $output = executeQuery('comment.getCommentList', $args);
            if(!$output->toBool()) return $output;

            $source_list = $output->data;
            if(!is_array($source_list)) $source_list = array($source_list);

            // ۸   
            $comment_count = count($source_list);

            $root = NULL;
            $list = NULL;
            $comment_list = array();

            // α   α  ϴ  
            $logged_info = Context::get('logged_info');


            // loop 鼭 ڸƮ    
            for($i=$comment_count-1;$i>=0;$i--) {
                $comment_srl = $source_list[$i]->comment_srl;
                $parent_srl = $source_list[$i]->parent_srl;
                if(!$comment_srl) continue;

                //  
                $list[$comment_srl] = $source_list[$i];

                if($parent_srl) {
                    $list[$parent_srl]->child[] = &$list[$comment_srl];
                } else {
                    $root->child[] = &$list[$comment_srl];
                }
            }
            $this->_arrangeComment($comment_list, $root->child, 0, null);

            //   db Է
            if(count($comment_list)) {
                foreach($comment_list as $comment_srl => $item) {
                    $comment_args = null;
                    $comment_args->comment_srl = $comment_srl;
                    $comment_args->document_srl = $document_srl;
                    $comment_args->head = $item->head;
                    $comment_args->arrange = $item->arrange;
                    $comment_args->module_srl = $module_srl;
                    $comment_args->regdate = $item->regdate;
                    $comment_args->depth = $item->depth;

                    executeQuery('comment.insertCommentList', $comment_args);
                }
            }

            //  lock 
            FileHandler::removeFile($lock_file);
        }

        /**
         * @brief   ġ
         **/
        function _arrangeComment(&$comment_list, $list, $depth, $parent = null) {
            if(!count($list)) return;
            foreach($list as $key => $val) {

                if($parent) $val->head = $parent->head;
                else $val->head = $val->comment_srl;
                $val->arrange = count($comment_list)+1;

                if($val->child) {
                    $val->depth = $depth;
                    $comment_list[$val->comment_srl] = $val;
                    $this->_arrangeComment($comment_list,$val->child,$depth+1, $val);
                    unset($val->child);
                } else {
                    $val->depth = $depth;
                    $comment_list[$val->comment_srl] = $val;
                }
            }
        }

        /**
         * @brief  ۸ ð   (ڿ)
         **/
        function getTotalCommentList($obj) {
            $query_id = 'comment.getTotalCommentList';

            //  
            $args->sort_index = 'list_order';
            $args->page = $obj->page?$obj->page:1;
            $args->list_count = $obj->list_count?$obj->list_count:20;
            $args->page_count = $obj->page_count?$obj->page_count:10;
            $args->s_module_srl = $obj->module_srl;
            $args->exclude_module_srl = $obj->exclude_module_srl;

            // ˻ ɼ 
            $search_target = $obj->search_target?$obj->search_target:trim(Context::get('search_target'));
            $search_keyword = $obj->search_keyword?$obj->search_keyword:trim(Context::get('search_keyword'));
            if($search_target && $search_keyword) {
                switch($search_target) {
                    case 'content' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_content = $search_keyword;
                        break;
                    case 'user_id' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_user_id = $search_keyword;
                            $query_id = 'comment.getTotalCommentListWithinMember';
                            $args->sort_index = 'comments.list_order';
                        break;
                    case 'user_name' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_user_name = $search_keyword;
                        break;
                    case 'nick_name' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_nick_name = $search_keyword;
                        break;
                    case 'email_address' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_email_address = $search_keyword;
                        break;
                    case 'homepage' :
                            if($search_keyword) $search_keyword = str_replace(' ','%',$search_keyword);
                            $args->s_homepage = $search_keyword;
                        break;
                    case 'regdate' :
                            $args->s_regdate = $search_keyword;
                        break;
                    case 'last_update' :
                            $args->s_last_upate = $search_keyword;
                        break;
                    case 'ipaddress' :
                            $args->s_ipaddress= $search_keyword;
                        break;
                    case 'member_srl' :
                            $args->{"s_".$search_target} = (int)$search_keyword;
                        break;
                }
            }

            // comment.getTotalCommentList  
            $output = executeQueryArray($query_id, $args);

            //  ų  ߻ ׳ return
            if(!$output->toBool()||!count($output->data)) return $output;
            foreach($output->data as $key => $val) {
                unset($_oComment);
                $_oComment = new CommentItem(0);
                $_oComment->setAttribute($val);
                $output->data[$key] = $_oComment;
            }

            return $output;
        }

        /**
         * @brief ⺰   return
         **/
        function getCommentConfig($module_srl) {
            $oModuleModel = &getModel('module');
            $comment_config = $oModuleModel->getModulePartConfig('comment', $module_srl);
            if(!isset($comment_config->comment_count)) $comment_config->comment_count = 50;
            return $comment_config;
        }

    }
?>
