<?php

    class cu3er extends WidgetHandler {

        /**
         * @brief 위젯의 실행 부분
         *
         * ./widgets/위젯/conf/info.xml 에 선언한 extra_vars를 args로 받는다
         * 결과를 만든후 print가 아니라 return 해주어야 한다
         **/

        function proc($args) {
            // XML
            if (empty($args->xml_id))   $args->xml_id = null;

            // 가로세로
            if (intVal($args->width) <= 0) $args->width = 800;
            if (intVal($args->height) <= 0) $args->height = 360;

            // 템플릿의 스킨 경로를 지정 (skin, colorset에 따른 값을 설정)
            $tpl_path = sprintf('%sskins/%s', $this->widget_path, $args->skin);

            // 사용할 변수 설정
            Context::set('xml_id', $args->xml_id);
            Context::set('width', $args->width);
            Context::set('height', $args->height);
            Context::set('unique_id', md5('cu3ber_' .microtime()));
            Context::addJsFile('./widgets/cu3er/js/swfobject.js');

            // 템플릿 파일을 지정(페이지 수정일 때는 실제 모습은 보이지 않도록)
            if (in_array(Context::get('act'), array("procWidgetGenerateCodeInPage", "dispPageAdminContentModify")))
                $tpl_file = 'pageedit';
            else
                $tpl_file = 'cu3er';

            // 템플릿 컴파일
            $oTemplate = &TemplateHandler::getInstance();
            return $oTemplate->compile($tpl_path, $tpl_file);
        }
    }
?>