<?php
    /**
     * @class  mcubeimgModel
     * @author 난다날아 (sinsy200@gmail.com)
     * @brief  mcubeimg 모듈의 model class
     **/

    class mcubeimgModel extends mcubeimg {
        function init(){
        }

        function getXML($xml_id, $width = 300, $height = 300) {
            // 설정을 가져온다.
            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('mcubeimg_mid_' . $xml_id);
            if (!$config)   return;
            
            // 캐시파일
            $caching_file = "./files/cu3er/mid_" .$xml_id. "/config_" .$width. "_" .$height. ".xml";
            
            // 캐시 시간을 확인
            if (!file_exists($caching_file) || $config->caching_interval < 1 || ($config->caching_interval > 0 && file_exists($caching_file) && filemtime($caching_file) + $config->caching_interval*60 < time())){
                // 캐시를 생성
                $oMcubeimgController = &getController('mcubeimg');
                $oMcubeimgController->createXML($xml_id, $width, $height);
            }
            
            return $caching_file;

        }
    }
?>
