<?php
    /**
     * @class  mcubeimgController
     * @author 난다날아 (sinsy200@gmail.com)
     * @brief  mcubeimg 모듈의 controller class
     **/

    class mcubeimgController extends mcubeimg {
        function init(){
        }

        function createXML($xml_id, $width = 300, $height = 300) {
            // 설정을 가져온다.
            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('mcubeimg_mid_' . $xml_id);
            if (!$config)   return;

            // 폴더 생성(지우고 새로 만든다)
            $path = "./files/cu3er/mid_" . $xml_id . "/";
            if (!FileHandler::makeDir($path))   return;
            //FileHandler::removeFilesInDir($path);
            
            // 캐시 파일
            $caching_file = $path . "config_" .$width. "_" .$height. ".xml";
            
            // 최근 게시물을 얻는다.
            $obj->module_srl = $config->module_srls;
            $obj->list_count = $config->image_count;
            $oDocumentModel = &getModel('document');
            $output = $oDocumentModel->getDocumentList($obj);
            if (!$output->toBool()) return;
            $documents = $output->data;
            
            // 결과가 없으면 종료
            if (!is_array($documents))  return;
            
            // 썸네일 생성
            $images = array();
            foreach($documents as $val){
                $images[]->path = $val->getThumbnail($width, $height, 'crop');
                $images[count($images)-1]->title = $val->getTitleText();
                $images[count($images)-1]->link = $val->getPermanentUrl();
            }
            
            // XML 생성
            $xml_head = '<?xml version="1.0" encoding="utf-8" ?>
                        <cu3er>
                            <settings>

                                <prev_button>
                                    <defaults round_corners="5,5,5,5"/>
                                    <tweenIn  time="0"  height="35" width="35" />
                                    <tweenOver tint="0x31a1ff" scaleX="1.1" scaleY="1.1" />
                                    <tweenOut tint="0x000000" />
                                </prev_button>

                                <prev_symbol>
                                    <tweenIn   height="15" width="15" />
                                    <defaults type="7" />
                                    <tweenOver tint="0xffffff" />
                                </prev_symbol>

                                <next_button>
                                    <defaults round_corners="5,5,5,5"/>
                                    <tweenIn  time="0"  height="35" width="35" />
                                    <tweenOver tint="0x31a1ff"  scaleX="1.1" scaleY="1.1"/>
                                    <tweenOut tint="0x000000" />
                                </next_button>

                                <next_symbol>
                                    <tweenIn   height="15" width="15" />
                                    <defaults type="7" />
                                    <tweenOver tint="0xffffff" />
                                </next_symbol>
                                <auto_play>
                                    <defaults symbol="circular" time="5" />
                                    <tweenIn x="10" y="10" height="20" width="20" tint="0xFFFFFF" />
                                </auto_play>

                                <transitions cube_color="0x333333" />
                            </settings>
                            <slides>';

            $xml_foot = '</slides></cu3er>';

            $xml_default = '<slide><url>./widets/cu3er/images/slideBg.png</url></slide><slide><url>./widets/cu3er/images/slideBg2.png</url></slide><slide><url>./widets/cu3er/images/slideBg3.png</url></slide>';

            $xml_slide = '';
            foreach ($images as $val){
                // 이미지 있는지 검사
                if (!$val->path)    continue;

                // 슬라이드 노드
                $xml_slide .= sprintf('<slide><url><![CDATA[%s]]></url>', $val->path);

                // 링크
                $xml_slide .= sprintf('<link target="_self"><![CDATA[%s]]></link>', $val->link);

                $xml_slide .= '<description>';

                // 제목
                $xml_slide .= sprintf('<heading><![CDATA[%s]]></heading>', $val->title);

                $xml_slide .= '</description>';

                $xml_slide .= '</slide>';

                // 전환 효과
                if (!$config->tran_num) $config->tran_num = 1;
                $xml_slide .= sprintf('<transition slicing="%s" num="%s" direction="%s" />', $config->tran_slicing, $config->tran_num, $config->tran_direction);
            }

            // 아무것도 없으면 디폴트 xml을 사용
            if (empty($xml_slide)){
                FileHandler::writeFile($caching_file, $xml_head.$xml_default.$xml_foot);
            }else{
                // xml 파일 저장
                FileHandler::writeFile($caching_file, $xml_head.$xml_slide.$xml_foot);
            }
        }
    }
?>
