<?php
    /**
     * @class  mcubeimgAdminController
     * @author 난다날아 (sinsy200@gmail.com)
     * @brief  mcubeimg 모듈의 admin controller class
     **/

    class mcubeimgAdminController extends mcubeimg {
        function init(){
        }

        function procMcubeimgAdminUpdate() {
            $args = Context::getRequestVars();
            unset($args->module);
            unset($args->act);

            // XML ID 유효성 검사
            if (!preg_match("/[a-zA-Z0-9]+/", $args->xml_id)){
                $this->alert(Context::getLang('xml_id_invalid'));
                return;
            }
            $xml_id = $args->xml_id;

            $oModuleModel = &getModel('module');
            $config = $oModuleModel->getModuleConfig('mcubeimg_' . $args->xml_id);

            // 폴더 생성
            $path = "./files/cu3er/" . $args->xml_id . "/";
            if (!FileHandler::makeDir($path)){
                $this->alert(Context::getLang('create_cache_folder_fail'));
                return;
            }

            // 이미지 처리
            for ($i = 1; $i <= 10; $i++){
                $name = "slide".$i."_img";
                $image_obj = $args->{$name};
                $args->{$name} = $config->{$name};

                // 삭제 요청에 대한 변수를 구함
                $del_var = $args->{"del_".$name};
                unset($args->{"del_".$name});
                // 삭제 요청이 있거나, 새로운 파일이 업로드 되면, 기존 파일 삭제
                if($del_var == 'Y' || $image_obj['tmp_name']) {
                    FileHandler::removeFile($args->{$name});
                    $args->{$name} = '';
                    if($del_var == 'Y' && !$image_obj['tmp_name']) continue;
                }

                // 정상적으로 업로드된 파일이 아니면 무시
                if(!$image_obj['tmp_name'] || !is_uploaded_file($image_obj['tmp_name'])) continue;

                // 이미지 파일이 아니어도 무시
                if(!preg_match("/\.(jpg|jpeg|gif|png)$/i", $image_obj['name'])) continue;

                $filename = $path.$image_obj['name'];

                // 파일 이동
                if(!move_uploaded_file($image_obj['tmp_name'], $filename)) continue;

                $args->{"slide".$i."_img"} = $filename;
            }

            // config에 저장
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');


            $config = $oModuleModel->getModuleConfig('mcubeimg');
            if (!in_array($args->xml_id, $config->xml_id)){
                $config->xml_id[] = $args->xml_id;
                $oModuleController->insertModuleConfig('mcubeimg', $config);
            }

            $config_name = 'mcubeimg_' . $args->xml_id;
            unset($args->xml_id);
            $oModuleController->insertModuleConfig($config_name, $args);

            // XML 생성
            $xml_head = '<?xml version="1.0" encoding="utf-8" ?>
                        <cu3er>
                            <settings>

                                <prev_button>
                                    <defaults round_corners="5,5,5,5"/>
                                    <tweenIn  time="0"  height="35" width="35" />
                                    <tweenOver tint="0x31a1ff" scaleX="1.1" scaleY="1.1" />
                                    <tweenOut tint="0x000000" />
                                </prev_button>

                                <prev_symbol>
                                    <tweenIn   height="15" width="15" />
                                    <defaults type="7" />
                                    <tweenOver tint="0xffffff" />
                                </prev_symbol>

                                <next_button>
                                    <defaults round_corners="5,5,5,5"/>
                                    <tweenIn  time="0"  height="35" width="35" />
                                    <tweenOver tint="0x31a1ff"  scaleX="1.1" scaleY="1.1"/>
                                    <tweenOut tint="0x000000" />
                                </next_button>

                                <next_symbol>
                                    <tweenIn   height="15" width="15" />
                                    <defaults type="7" />
                                    <tweenOver tint="0xffffff" />
                                </next_symbol>
                                <auto_play>
                                    <defaults symbol="circular" time="5" />
                                    <tweenIn x="10" y="10" height="20" width="20" tint="0xFFFFFF" />
                                </auto_play>

                                <transitions cube_color="0x333333" />
                            </settings>
                            <slides>';

            $xml_foot = '</slides></cu3er>';

            $xml_default = '<slide><url>./widets/cu3er/images/slideBg.png</url></slide><slide><url>./widets/cu3er/images/slideBg2.png</url></slide><slide><url>./widets/cu3er/images/slideBg3.png</url></slide>';

            $xml_slide = '';
            for ($i = 1; $i <= 10; $i++){
                // 이미지 있는지 검사
                $name = "slide".$i."_img";
                if (!$args->{$name})    break;

                // 슬라이드 노드
                $xml_slide .= sprintf('<slide><url>%s</url>', $args->{$name});

                // 링크
                $name = "slide".$i."_link";
                $name2 = "slide".$i."_target";
                if ($args->{$name}){
                    if ($args->{$name2})    $target = $args->{$name2};
                    else                    $target = '_self';

                    $xml_slide .= sprintf('<link target="%s">%s</link>', $target, $args->{$name});
                }

                if ($args->{"slide".$i."_heading"} || $args->{"slide".$i."_paragraph"}){
                    $xml_slide .= '<description>';

                    // 제목
                    $name = "slide".$i."_heading";
                    if ($args->{$name}){
                        $xml_slide .= sprintf('<heading>%s</heading>', $args->{$name});
                    }

                    // 설명
                    $name = "slide".$i."_paragraph";
                    if ($args->{$name}){
                        $xml_slide .= sprintf('<paragraph>%s</paragraph>', $args->{$name});
                    }

                    // 설명 링크
                    $name = "slide".$i."_desc_link";
                    $name2 = "slide".$i."_desc_target";
                    if ($args->{$name}){
                        if ($args->{$name2})    $target = $args->{$name2};
                        else                    $target = '_self';

                        $xml_slide .= sprintf('<link target="%s">%s</link>', $target, $args->{$name});
                    }

                    $xml_slide .= '</description>';
                }

                $xml_slide .= '</slide>';

                // 전환 효과
                $name = "slide".$i.($i+1)."_tran_slicing";
                $slicing = $args->{$name};
                if (!$slicing)  $slicing = 'horizontal';

                $name = "slide".$i.($i+1)."_tran_num";
                $num = $args->{$name};
                if (!$num)  $num = 1;

                $name = "slide".$i.($i+1)."_tran_direction";
                $direction = $args->{$name};
                if (!$direction) $direction = 'left';

                $xml_slide .= sprintf('<transition slicing="%s" num="%s" direction="%s" />', $slicing, $num, $direction);
            }

            // 아무것도 없으면 디폴트 xml을 사용
            if (empty($xml_slide)){
                FileHandler::writeFile($path."config.xml", $xml_head.$xml_default.$xml_foot);
            }else{
                // xml 파일 저장
                FileHandler::writeFile($path."config.xml", $xml_head.$xml_slide.$xml_foot);
            }

            Context::set('xml_id', $xml_id);
            $this->setLayoutPath('./common/tpl');
            $this->setLayoutFile('default_layout.html');
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile("top_refresh.html");
        }

        // XML 삭제
        function procMcubeimgAdminDelete(){
            $xml_id = Context::get('xml_id');

            // 전체 설정에서 XML ID를 삭제
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');
            $config = $oModuleModel->getModuleConfig('mcubeimg');
            $key = array_search($xml_id, $config->xml_id);
            if ($key !== false){
                array_splice($config->xml_id, $key, 1);
                $oModuleController->insertModuleConfig('mcubeimg', $config);
            }

            // XML ID에 해당하는 설정 삭제
            $args->module = 'mcubeimg_' . $xml_id;
            executeQuery('module.deleteModuleConfig', $args);

            // 폴더 삭제
            FileHandler::removeDir("./files/cu3er/" . $xml_id);

            Context::set('xml_id', null);
            $this->setLayoutPath('./common/tpl');
            $this->setLayoutFile('default_layout.html');
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile("top_refresh.html");
        }

        // 에러 메시지
        function alert($msg){
            Context::set('msg', $msg);
            $this->setLayoutPath('./common/tpl');
            $this->setLayoutFile('default_layout.html');
            $this->setTemplatePath($this->module_path.'tpl');
            $this->setTemplateFile("alert.html");
        }
    }
?>
