<?php
/**
 * @class loginlogAdminController
 * @author 퍼니엑스이 (admin@funnyxe.com)
 * @brief loginlog 모듈의 admin controller class
 **/

class loginlogAdminController extends loginlog {
	/**
	 * @brief 초기화
	 */
	function init() {
	}

	/**
	 * @brief 설정 저장
	 */
	function procLoginlogAdminInsertConfig()
	{
		// 기존 DB에 저장된 설정값을 가져옵니다
		$oLoginlogModel = getModel('loginlog');
		$config = $oLoginlogModel->getModuleConfig();

		// 넘어온 설정값과 기존에 저장된 설정값을 합칩니다.
		$config->delete_logs = Context::get('delete_logs');
		$config->admin_user_log = Context::get('admin_user_log');

		// 불필요한 값을 제거합니다.
		unset($config->body);
		unset($config->_filter);
		unset($config->error_return_url);
		unset($config->act);
		unset($config->module);

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('loginlog', $config);


		// 저장 후 이동할 URL을 지정합니다
		$returnUrl = Context::get('success_return_url');
		if(!$returnUrl)
		{
			$returnUrl = getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLoginlogAdminSetting');
		}

		$this->setMessage('success_saved');

		$this->setRedirectUrl($returnUrl);
	}

	public function procLoginlogAdminInsertDesignConfig()
	{
		// GET 방식으로 접근하는 것을 방지합니다.
		if(Context::getRequestMethod() == 'GET') return new Object(-1, 'msg_invalid_request');

		$oLoginlogModel = getModel('loginlog');
		$config = $oLoginlogModel->getModuleConfig();

		// 불필요한 값을 제거합니다.
		unset($config->body);
		unset($config->_filter);
		unset($config->error_return_url);
		unset($config->act);
		unset($config->module);
		unset($config->ruleset);

		$config->design = Context::gets('skin', 'mskin');

		// DB에 설정값을 저장합니다
		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('loginlog', $config);

		// 메시지 지정
		$this->setMessage('success_saved');

		// 저장 후 이동할 URL을 지정합니다
		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLoginlogAdminDesign');
		$this->setRedirectUrl($returnUrl);
	}

	/**
	 * @brief 설정 저장
	 */
	function procLoginlogAdminSaveListSetting()
	{
		$oLoginlogModel = getModel('loginlog');
		$config = $oLoginlogModel->getModuleConfig();

		$config->listSetting = explode('|@|', Context::get('listsetting'));

		$oModuleController = getController('module');
		$oModuleController->insertModuleConfig('loginlog', $config);

		$this->setMessage('success_saved');
	}

	/**
	 * @brief 기록 초기화
	 */
	function procLoginlogAdminInitLogs()
	{
		$args = new stdClass;

		if(Context::get('expire_date'))
		{
			$args->expire_date = Context::get('expire_date');
		}

		$msg_code = 'success_reset';

		$output = executeQuery('loginlog.initLoginlogs', $args);
		if(!$output->toBool()) $msg_code = 'msg_failed_reset_logs';

		$this->setMessage($msg_code);
	}


	/**
	 * @brief 선택한 항목 삭제
	 */
	public function procLoginlogAdminDeleteChecked()
	{
		$log_srls= Context::get('cart');

		for($i=0, $c=count($log_srls); $i < $c; $i++)
		{
			$log_srl = $log_srls[$i];
			$this->deleteLog($log_srl);
		}

		// 저장 후 이동할 URL을 지정합니다
		$returnUrl = Context::get('success_return_url') ? Context::get('success_return_url') : getNotEncodedUrl('', 'module', 'admin', 'act', 'dispLoginlogAdminList');
		$this->setRedirectUrl($returnUrl);

		$this->setMessage('success_deleted');
	}

	public function deleteLog($log_srl)
	{
		$args = new stdClass;
		$args->log_srl = $log_srl;
		return executeQuery('loginlog.deleteLog', $args);
	}
}