<?php
    /**
     * @class loginlog
     * @author SMaker (dowon2308@paran.com)
     * @brief loginlog 모듈의 high class
     **/

    class loginlog extends ModuleObject {
        /**
         * @brief 모듈 설치
         */
        function moduleInstall() {
            $oModuleController = &getController('module');
            $oModuleController->insertTrigger('member.doLogin', 'loginlog', 'controller', 'triggerAfterLogin', 'after');

            return new Object();
        }

        /**
         * @brief 모듈 삭제
         */
        function moduleUninstall() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // 트리거 삭제
            if($oModuleModel->getTrigger('member.doLogin', 'loginlog', 'controller', 'triggerAfterLogin', 'after'))
                $oModuleController->deleteTrigger('member.doLogin', 'loginlog', 'controller', 'triggerAfterLogin', 'after');

            return new Object();
        }

        /**
         * @brief 업데이트가 필요한지 확인
         **/
        function checkUpdate() {
            return false;
        }

        /**
         * @brief 모듈업데이트
         **/
        function moduleUpdate() {
            return new Object(0,'success_updated');
        }

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }
    }
?>