<?php
    /**
     * @class loginlogAdminView
     * @author SMaker (dowon2308@paran.com)
     * @brief loginlog 모듈의 controller class
     **/

    class loginlogAdminView extends loginlog {
        /**
         * @brief 초기화
         */
        function init() {
            // 템플릿 폴더 지정
            $this->setTemplatePath($this->module_path.'tpl');
        }

        /**
         * @brief 로그인 기록 열람
         */
        function dispLoginlogAdminIndex() {
            // 목록을 구하기 위한 옵션
            $args->page = Context::get('page'); ///< 페이지
            $args->list_count = 30; ///< 한페이지에 보여줄 기록 수
            $args->page_count = 10; ///< 페이지 네비게이션에 나타날 페이지의 수

            $output = executeQueryArray('loginlog.getLoginlogList');

            // 템플릿에 쓰기 위해 Context::set
            Context::set('total_count', $output->total_count);
            Context::set('total_page', $output->total_page);
            Context::set('page', $output->page);
            Context::set('log_list', $output->data);
            Context::set('page_navigation', $output->page_navigation);

            // 템플릿 파일 지정
            $this->setTemplateFile('index');
        }
    }
?>