<?php
	/**
     * @file   calendar.html
     * @orginal author Kim, Muhak
     * @brief  calender function
     **/

define("base_ganji",9); // 계유 : 1900-01-00

class splanner_widget extends Object
{
// internal vars.
var $m_to_d = array(0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334);
var $aLunar = array(
// 2000. 1. 1일부터 매월 1일과 15일의 음력 테이블
array(1125,1209,1226,111,126,210,227,311,327,412,429,514,
530,614,702,716,804,818,904,918,1006,1020,1106,1120),
// 2001
array(1207,1221,109,123,207,221,308,322,408,422,10410,10424,
511,525,612,626,714,728,815,829,916,1001,1017,1101),
// 2002
array(1118,1203,1220,104,118,202,219,303,319,404,421,505,
521,606,623,707,724,809,825,910,927,1011,1027,1112),
// 2003
array(1129,1213,101,115,129,213,230,314,401,415,502,516,
602,616,704,718,805,819,906,920,1008,1022,1108,1122),
// 2004
array(1210,1224,111,125,211,225,10212,10226,313,327,414,428,
514,528,616,630,717,802,818,902,919,1003,1019,1104),
// 2005
array(1121,1206,1223,107,121,206,223,307,323,408,425,509,
525,610,627,711,728,812,828,913,930,1014,1030,1114),
// 2006
array(1202,1216,104,118,202,216,304,318,404,418,506,520,
606,620,708,722,10709,10723,810,824,911,925,1011,1025),
// 2007
array(1113,1127,1214,1228,112,126,214,228,315,329,416,501,
517,602,619,703,720,805,821,905,922,1006,1022,1106),
// 2008
array(1123,1208,1225,109,124,208,225,310,326,411,428,512,
528,613,701,715,802,816,903,917,1004,1018,1104,1118),
// 2009
array(1206,1220,107,121,205,219,306,320,407,421,509,523,
10509,10523,611,625,713,727,813,827,915,929,1015,1029),
// 2010
array(1117,1201,1218,102,116,130,217,302,318,402,419,504,
520,604,621,706,723,808,824,908,925,1010,1026,1110),
// 2011
array(1127,1212,1229,113,127,211,228,313,329,413,430,514,
601,615,702,716,804,818,905,919,1006,1020,1107,1121),
// 2012
array(1208,1222,110,124,209,223,311,325,10311,10325,412,426,
512,526,614,628,715,729,816,901,918,1002,1018,1103),
// 2013
array(1120,1204,1221,106,120,204,221,306,322,406,423,507,
523,608,625,709,726,811,827,911,928,1013,1029,1113),
// 2014
array(1201,1215,102,116,201,215,302,316,403,417,504,518,
605,619,706,720,808,822,908,922,10909,10923,1010,1024),
// 2015
array(1111,1125,1213,1227,111,125,213,227,313,327,415,429,
516,530,617,702,719,803,819,903,920,1004,1020,1105),
// 2016
array(1122,1206,1223,107,122,207,224,309,325,409,426,511,
527,612,629,713,801,815,901,915,1002,1016,1103,1117),
// 2017
array(1204,1218,105,119,203,217,305,319,406,420,507,521,
10508,10522,610,624,711,725,812,826,913,927,1014,1028),
// 2018
array(1115,1129,1216,1230,114,128,216,230,316,401,418,502,
518,603,620,705,722,806,822,907,924,1008,1024,1109),
// 2019
array(1126,1210,1227,111,125,209,226,311,327,411,428,513,
529,613,701,715,803,817,903,917,1005,1019,1105,1119),
// 2020
array(1207,1221,108,122,207,221,309,323,409,423,10410,10424,
511,525,612,626,714,728,815,829,916,1001,1017,1101),
// 2021
array(1118,1203,1220,104,118,203,220,304,320,404,421,506,
522,606,623,708,725,809,825,910,927,1011,1027,1112),
// 2022
array(1129,1213,101,115,129,213,301,315,401,415,503,517,
603,617,704,718,806,820,906,920,1008,1022,1108,1122),
// 2023
array(1210,1224,111,125,210,224,10211,10225,312,326,413,427,
514,528,615,629,717,801,817,901,918,1003,1019,1103),
// 2024
array(1120,1205,1222,106,121,206,223,307,323,408,425,510,
526,610,627,712,729,813,829,913,1001,1015,1101,1115),
// 2025
array(1202,1216,104,118,202,216,304,318,404,418,506,520,
607,621,10608,10622,710,724,810,824,912,926,1012,1026),
// 2026
array(1113,1127,1214,1228,113,127,214,228,315,329,416,501,
517,602,619,703,720,805,821,905,922,1007,1023,1107),
// 2027
array(1124,1208,1225,109,123,208,225,309,325,410,427,511,
527,612,629,714,801,815,902,916,1004,1018,1104,1118),
// 2028
array(1205,1219,106,120,206,220,307,321,407,421,509,523,
10509,10523,611,625,713,727,813,827,915,929,1016,1030),
// 2029
array(1117,1201,1218,103,117,201,218,302,318,403,420,504,
520,604,621,706,723,808,824,908,925,1010,1026,1111),
// 2030
array(1128,1212,1229,113,127,212,229,313,329,414,501,515,
601,615,703,717,804,818,905,919,1006,1020,1107,1121),
// 2031
array(1208,1222,110,124,208,222,310,324,10310,10324,412,426,
512,526,614,628,715,729,815,829,917,1001,1017,1102),
// 2032
array(1119,1203,1220,105,120,204,221,306,322,407,424,508,
524,609,626,710,727,811,827,912,929,1013,1029,1113),
// 2033
array(1201,1215,102,116,201,215,302,316,403,417,505,519,
605,619,707,721,10708,10722,809,823,910,924,1010,1024),
// 2034
array(1111,1125,1213,1227,111,125,213,227,313,327,415,429,
516,530,617,702,719,803,819,904,921,1005,1021,1105),
// 2035
array(1122,1206,1223,108,122,206,223,308,324,408,425,510,
526,611,628,712,729,814,901,915,1002,1016,1102,1116),
// 2036
array(1204,1218,105,119,204,218,305,319,406,420,507,521,
608,622,10610,10624,711,725,812,826,914,928,1014,1028),
// 2037
array(1116,1130,1217,101,115,129,216,230,316,401,418,502,
518,603,620,705,722,806,822,907,924,1009,1025,1109),
// 2038
array(1126,1211),
);
var $aJeolki = array(
// 2000. 1. 1일부터 24절기
array(6,21,4,19,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,21),
//2001
array(5,20,4,18,5,20,5,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,22),
//2002
array(5,20,4,19,6,21,5,20,6,21,6,21,8,23,8,23,8,23,8,23,7,22,7,22),
//2003
array(6,20,4,19,6,21,5,21,6,21,6,22,8,23,8,23,8,23,8,24,7,23,7,22),
//2004
array(6,21,4,19,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,21),
//2005
array(5,20,4,18,5,20,5,20,5,21,5,21,7,22,7,23,7,23,8,23,8,22,7,22),
//2006
array(5,20,4,19,6,21,5,20,6,21,6,21,8,23,7,23,8,23,8,23,8,22,7,22),
//2007
array(6,20,4,19,6,21,5,20,6,21,6,22,8,23,8,23,8,23,8,24,8,23,7,22),
//2008
array(6,21,4,19,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,21),
//2009
array(5,20,4,18,5,20,5,20,5,21,5,21,7,22,7,23,7,23,8,23,8,22,7,22),
//2010
array(5,20,4,19,6,21,5,20,5,21,6,21,8,22,7,23,8,23,8,23,8,22,7,22),
//2011
array(6,20,4,19,6,21,5,20,6,21,6,22,8,24,8,23,8,23,8,24,8,23,7,22),
//2012
array(6,21,4,19,5,20,4,20,5,20,5,21,7,22,7,23,7,22,8,23,7,22,7,21),
//2013
array(5,20,4,18,5,20,5,20,5,21,5,21,7,22,7,23,7,23,8,23,8,22,7,22),
//2014
array(5,20,4,19,6,21,5,20,5,21,6,21,8,22,7,23,8,23,8,23,8,22,7,22),
//2015
array(6,20,4,19,6,21,5,20,6,21,6,22,8,23,8,23,8,23,8,24,7,23,7,22),
//2016
array(6,21,4,19,5,20,4,20,5,20,5,21,7,22,7,23,7,22,8,23,6,22,7,21),
//2017
array(5,20,4,18,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,22),
//2018
array(5,20,4,19,6,21,5,20,5,21,6,21,8,22,7,23,8,23,8,23,7,22,7,22),
//2019
array(6,20,4,19,6,21,5,20,6,21,6,22,8,23,8,23,8,23,8,23,7,22,7,22),
//2020
array(6,20,4,19,5,20,4,20,5,20,5,21,7,22,7,23,7,22,8,23,6,22,7,21),
//2021
array(5,20,3,18,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,22),
//2022
array(5,20,4,19,5,21,5,20,5,21,6,21,8,22,7,23,8,23,8,23,7,22,7,22),
//2023
array(6,20,4,19,6,21,5,20,6,21,6,21,8,23,8,23,8,23,8,23,7,22,7,22),
//2024
array(6,20,4,19,5,20,4,20,5,20,5,21,7,22,7,23,7,22,7,23,6,22,6,21),
//2025
array(5,20,3,18,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,22),
//2026
array(5,20,4,19,5,20,5,20,5,21,6,21,7,22,8,23,8,23,8,23,7,22,7,22),
//2027
array(5,20,4,19,6,21,5,20,6,21,6,21,8,22,8,23,8,23,8,23,7,22,7,22),
//2028
array(6,20,4,19,5,20,4,20,5,20,5,21,7,22,7,22,7,22,7,23,6,22,6,21),
//2029
array(5,20,3,18,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,21),
//2030
array(5,20,4,18,5,20,5,20,5,21,5,21,7,22,8,23,7,23,8,23,7,22,7,22),
//2031
array(5,20,4,19,6,21,5,20,6,21,6,21,8,22,8,23,8,23,8,23,8,22,7,22),
//2032
array(6,20,4,19,5,20,4,20,5,20,5,21,7,22,7,22,7,22,7,23,7,22,6,21),
//2033
array(5,20,3,18,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,21),
//2034
array(5,20,4,18,5,20,5,20,5,21,5,21,7,22,8,23,7,23,8,23,8,22,7,22),
//2035
array(5,20,4,19,6,21,5,20,6,21,6,21,8,22,8,23,8,23,8,23,8,22,7,22),
//2036
array(6,20,4,19,5,20,4,20,5,20,5,21,7,22,7,22,7,22,7,23,7,22,6,21),
//2037
array(5,20,3,18,5,20,4,20,5,21,5,21,7,22,7,23,7,23,8,23,7,22,7,21),
);
var $AjeolkiName = array
(
'소한','대한','입춘','우수','경칩','춘분','청명','곡우',
'입하','소만','망종','하지','소서','대서','입추','처서',
'백로','추분','한로','상강','입동','소설','대설','동지'
);
//------------------------------------------------------------------------
	/**
	 * @function: fn_leapyear($year)
	 * @return  : boolean
	 * @brief:    윤년여부
	 **/
function fn_leapyear($year)
{
	if( (($year % 4 ==0) && ($year % 100 != 0)) || ($year % 400 == 0))
		return 1;
	else return 0;
}

//------------------------------------------------------------------------
	/**
	 * @function: fn_month_days($year, $month)
	 * @return  : days
	 * @brief:    월별 날짜
	 **/
function fn_month_days($year, $month)
{
	static $month_days = array(0,31,28,31,30,31,30,31,31,30,31,30,31);
	if($month != 2) return $month_days[$month];
	if(splanner_widget::fn_leapyear($year)) return 29;
	else return 28;
}


//------------------------------------------------------------------------
	/**
	 * @function: fn_mkdate($year, $month, $day)
	 * @return  : 일수
	 * @brief:    1900.1.1일을 1로하는 상대적인 일수 
	 **/
function fn_mkdate($year, $month, $day)
{
	if($year < 1900) return 0;
	if($month < 1 || $month > 12) return 0;
	if($day < 1 || $day > 31) return 0;
	$month--;
	$result = ($year - 1900) * 365 + $this->m_to_d[$month];
	if($month <= 1)
		$year --;
	$result += (int)(($year - 1900) / 4);
	$result -= (int)(($year - 1900) / 100);
	$result += (int)(($year - 1600) / 400);
	$result += $day;
	return $result;
}

//------------------------------------------------------------------------
	/**
	 * @function: fn_mkrdate($days)
	 * @return  : 날짜	(YYYYMMDD)
	 * @brief:    1900.1.1일을 1로하는 상대적인 일수를 받아 날짜를 return
	 **/
function fn_mkrdate($days)
{
	$y = (int)($days / 365);
	$dd = $days % 365;
	if($y > 0)
	{	// 지난해 까지의 윤년 보정
		$yy = $y - 1;
		$dd -= (int)($yy / 4);
		$dd += (int)($yy / 100);
		$yy += 1900;
		$dd -= (int)(($yy - 1600)/400);
	}
	$y += 1900;
	if($dd < 1)
	{
		$y--;
		if($this->fn_leapyear($y))
			$dd += 366;
		else
			$dd += 365;
	}
	if(($dd > 59) && $this->fn_leapyear($y))
	{
		if($dd == 60)
		{
			return $y*10000 + 229; // 2월29일
		}
		$dd--;
	}
	$mm = (int)(($dd-1)/31);
	if($mm < 11 && $this->m_to_d[$mm+1] < $dd)
		$mm++;
	$d = $dd - $this->m_to_d[$mm];
	return $y*10000 + ($mm+1)*100 + $d;
}

//------------------------------------------------------------------------
	/**
	 * @function: fn_get_month_sun($year, $month)
	 * @return  : 한달 양력 달력 array
	 * @brief:    양력 달력을 return
	 *            1900.1.1은 월요일
	 * @brief:     형태예제
	 * @brief:     |일|월|화|수|목|금|토|
	 * @brief:     | 0| 0| 0| 0| 0| 0| 1|
	 * @brief:     | 2| 3| 4| 5| 6| 7| 8|
	 * @brief:     | 9|10|11|12|13|14|15|
	 * @brief:     |16|17|18|19|20|21|22|
	 * @brief:     |23|24|25|26|27|28|29|
	 * @brief:     |30|31| 0| 0| 0| 0| 0|
	 **/
function fn_get_month_sun($year, $month)
{
	if($year < 1900) return;
	if($month < 1 || $month > 12) return;
	$calendar = array();
	$mdays = splanner_widget::fn_month_days($year,$month);
	$days = splanner_widget::fn_mkdate($year,$month,1);
	$week = $days % 7;
	$vertical = (int)(($mdays + $week + 6)/ 7);

	$day = 1;
	for($i=0;$i<$vertical;$i++)
	{
		for($j=0;$j<7;$j++)
		{
			if(($i==0 && $j < $week) || $day > $mdays)
				$calendar[$i][$j] = 0;
			else
			{
				$calendar[$i][$j] = $day;
				$day++;
			}
		}
	}
	return $calendar;
}


//------------------------------------------------------------------------
	/**
	 * @function: fn_get_month_lunar($year, $month)
	 * @return  : 한달 음력 달력 array
	 * @brief:    양력에해당하는 음력을 생성함.
	 **/
function fn_get_month_lunar($year, $month)
{
	if($year < 2000 || $year > 2037) return;
	if($month < 1 || $month > 12) return;
	$yidx = $year - 2000;
	$midx = ($month-1)*2;
	$first = $this->aLunar[$yidx][$midx];
	$middle = $this->aLunar[$yidx][$midx+1];
	if($month != 12)
		$last = $this->aLunar[$yidx][$midx+2];
	else
		$last = $this->aLunar[$yidx+1][0];
	$mdays = splanner_widget::fn_month_days($year,$month);

	if((int)($first/100) == (int)($middle/100))
	{	// 같은달
		for($i=1;$i<15;$i++)
		{
			$aLun[$i] = $first;
			$first += 1;
		}
		$rem = $last % 100;
		for($j=$mdays; $rem > 1; )
		{
			$rem -= 1;
			$last -= 1;
			$aLun[$j] = $last;
			$j -= 1;
		}
		for(;$i <= $j; $i++)
		{
			$aLun[$i] = $first;
			$first += 1;
		}
	} else
	{
	   $rem = $middle % 100;
		$ll = $middle;
		for($j=15;$rem > 1; )
		{
			$j -= 1;
			$rem -= 1;
			$ll -= 1;
			$aLun[$j] = $ll;
		}
		for($i=1;$i<$j;$i++)
		{
			$aLun[$i] = $first;
			$first += 1;
		}
		for($i=15;$i<=$mdays;$i++)
		{
			$aLun[$i] = $middle;
			$middle += 1;
		}
		if($mdays == 31 && ($last % 100) == 2)
			$aLun[$mdays] = $last - 1;
	}
	return $aLun;
}

//------------------------------------------------------------------------
	/**
	 * @function: fn_sun2lunar($year, $month, $day)
	 * @return  : MMDD
	 * @brief:    양력을 음력으로 변환
	 **/
function fn_sun2lunar($year, $month, $day)
{
	if($year < 2000 || $year > 2037) return 0;
	if($month < 1 || $month > 12) return 0;
	$mdays = splanner_widget::fn_month_days($year,$month);
	if($day < 1 || $day > $mdays) return 0;
	$yidx = $year - 2000;
	$midx = ($month-1)*2;
	$first = $this->aLunar[$yidx][$midx];
	$middle = $this->aLunar[$yidx][$midx+1];
	if($month != 12)
		$last = $this->aLunar[$yidx][$midx+2];
	else
		$last = $this->aLunar[$yidx+1][0];

	if((int)($first/100) == (int)($middle/100))
	{	// 같은달
		$rem = $last % 100;
		$j = $mdays - $rem + 2; // j는 음력 1일인 양력
		if($day < $j) $ret = $first + $day - 1;
		else $ret = $last - $rem + 1 + ($day - $j); // j일의 음력 :last-rem+1
	} else
	{
		$rem = $middle % 100;
		$j = 15 - rem + 1;
		if($day < $j) $ret = $fisrt + $day - 1;
		else if($day == 31 && ($last % 100 == 2))
			$ret = $last -1;
		else $ret = $middle + ($day - 15);
	}
	return $ret;
}
//------------------------------------------------------------------------
	/**
	 * @function: fn_lunar2sun($year, $month, $day)
	 * @return  : MMDD
	 * @brief:    음력을 양력으로 변환
	 **/
function fn_lunar2sun($year, $month, $day)
{
	if($year < 2000 || $year > 2037) return 0;
	$yidx = $year - 2000;
	$midx = $month*2 - 1;
	for($i=0;$i<6;$i++)
	{
		$ll = $this->aLunar[$yidx][$midx];
		if((int)($ll/100) == $month)
			break;
		$midx++;
		if($midx >= 24)
		{
			$midx = 0;
			$yidx++;
			
		}
	}
	if($i == 6) return 0; // error
/*
	if($midx >= 24)
	{
		$midx -= 24;
		$yidx++;
	}
*/
	$dd = $ll % 100;
	$smm = (int)($midx/2) + 1;
	$sdd = ($midx&1) ? 15 : 1;
	$sdd += $day - $dd;
	if($sdd < 1)
	{
		$smm--;
		if($smm < 1)
		{
			$smm = 12;
			$yidx--;
		}
		$mdays = splanner_widget::fn_month_days($yidx+2000,$smm);
		$sdd += $mdays;
	} else
	{
		$mdays = splanner_widget::fn_month_days($yidx+2000,$smm);
		if($sdd > $mdays)
		{
			$smm++;
			$sdd -= $mdays;
			if($smm > 12)
			{
				$yidx++;
				$smm -= 12;
			}
		}
	}
	return $smm * 100 + $sdd;
}


//------------------------------------------------------------------------
	/**
	 * @function: fn_get_jeolki($year, $pMonth)
	 * @return  : array
	 * @brief:    24절기, 초,중,말복, 단오, 한식
	 **/
function fn_get_jeolki($year, $month)
{
	if($year < 2000 || $year > 2037) return;
	if($month < 1 || $month > 12) return;
	$yidx = $year - 2000;
	$midx = ($month-1) * 2;
	$Rjeolki[$this->aJeolki[$yidx][$midx]] = $this->AjeolkiName[$midx];
	$Rjeolki[$this->aJeolki[$yidx][$midx+1]] = $this->AjeolkiName[$midx+1];
	switch($month)
	{
	case 7:
		$ret = splanner_widget::fn_mkdate($year,$month,$this->aJeolki[$yidx][$midx-1]); // 하지
		if($ret)
		{
			$gan = ($ret + base_ganji) % 10;
			if($gan > 6) $gyeong = 16 - $gan;
			else $gyeong = 6 - $gan;
			$bok = $this->aJeolki[$yidx][$midx-1] + $gyeong + 20; // 세번째 '경'일
			$bok -= 30; // 6월 -> 7월
			$Rjeolki[$bok] = "초복";
			$Rjeolki[$bok+10] = "중복";
		}
		break;
	case 8:
		$ret = splanner_widget::fn_mkdate($year,$month,$this->aJeolki[$yidx][$midx]); // 입추
		if($ret)
		{
			$gan = ($ret + base_ganji) % 10;
			if($gan > 6) $gyeong = 16 - $gan;
			else $gyeong = 6 - $gan;
			$bok = $this->aJeolki[$yidx][$midx] + $gyeong; // 번째 '경'일
			$Rjeolki[$bok] = "말복";
		}
		break;
	case 5:
	case 6:
		$ret = splanner_widget::fn_lunar2sun($year,5,5); // 단오
		if((int)($ret / 100) == $month)
		{
			$Rjeolki[$ret%100] =  "단오";
		}
		break;
	case 4:
		if($yidx > 0)
		{
			$ret = splanner_widget::fn_mkdate($year-1,12,$this->aJeolki[$yidx-1][23]); // 동지
			$ret += 105;
			$ret = splanner_widget::fn_mkrdate($ret);
			$Rjeolki[$ret%100] = "한식";
		}
		break;
	}
	return $Rjeolki;
}
//------------------------------------------------------------------------
	/**
	 * @function: fn_holidays($year, $month)
	 * @return  : array
	 * @brief:    
	 **/
function fn_holidays($year, $month)
{
	if($year < 2000 || $year > 2037) return;
	if($month < 1 || $month > 12) return;
	switch($month)
	{
	case 1:
		$Aholi[1] = "신정";
		$ret = splanner_widget::fn_lunar2sun($year,1,1);
		if($ret == 201) $Aholi[31] = "설연휴";
		else if((int)($ret/100) == 1)
		{
			$d = $ret % 100;
			$Aholi[$d] = "설날";
			$Aholi[$d-1] = "설연휴";
			if($d < 31)
				$Aholi[$d+1] = "설연휴";
		}
		break;
	case 2:
		$ret = splanner_widget::fn_lunar2sun($year,1,1);
		if($ret == 131) $Aholi[1] = "설연휴";
		else if((int)($ret/100) == 2)
		{
			$d = $ret % 100;
			$Aholi[$d] = "설날";
			$Aholi[$d+1] = "설연휴";
			if($d > 1)
				$Aholi[$d-1] = "설연휴";
		}
		break;
	case 3:
		$Aholi[1] = "삼일절";
		break;
	case 4:
		$ret = splanner_widget::fn_lunar2sun($year,4,8);
		if((int)($ret/100) == 4)
		{
			$Aholi[$ret%100] = "석가탄신일";
		}
		break;
	case 5:
		$ret = splanner_widget::fn_lunar2sun($year,4,8);
		if((int)($ret/100) == 5)
		{
			$Aholi[$ret%100] = "석가탄신일";
		}
		if($Aholi[5] != null) $Aholi[5] .= " 어린이날";
		else $Aholi[5] = "어린이날";
		break;
	case 6:
		$Aholi[6] = "현충일";
		break;
	case 8:
		$Aholi[15] = "광복절";
		break;
	case 9:
		$ret = splanner_widget::fn_lunar2sun($year,8,15);
		if($ret == 1001) $Aholi[30] = "추석연휴";
		else if((int)($ret/100) == 9)
		{
			$d = $ret % 100;
			$Aholi[$d] = "추석";
			$Aholi[$d-1] = "추석연휴";
			if($d < 30)
				$Aholi[$d+1] = "추석연휴";
		}
		break;
	case 10:
		$ret = splanner_widget::fn_lunar2sun($year,8,15);
		if($ret == 930) $Aholi[1] = "추석연휴";
		else if((int)($ret/100) == 10)
		{
			$d = $ret % 100;
			$Aholi[$d] = "추석";
			$Aholi[$d+1] = "추석연휴";
			if($d > 1)
				$Aholi[$d-1] = "추석연휴";
		}
		if($Aholi[3]) $Aholi[3] .= " 개천절";
		else $Aholi[3] = "개천절";
		break;
	case 12:
		$Aholi[25] = "성탄절";
		break;
	}
	return $Aholi;
}

//------------------------------------------------------------------------
	/**
	 * @function: fn_get_ganji($year, $month, $day)
	 * @return  : string
	 * @brief:    간지
	 **/
function fn_get_ganji($year, $month, $day)
{
static $l_gan = array("갑","을","병","정","무","기","경","신","임","계");
static $l_ji = array("자","축","인","묘","진","사","오","미","신","유","술","해");
	$ret = splanner_widget::fn_mkdate($year,$month,$day);
	if($ret)
	{
		$ganji = ($ret + base_ganji);
		return $l_gan[$ganji%10].$l_ji[$janji%12];
	}
}

//------------------------------------------------------------------------
	/**
	 * @function: fn_get_Memday($year, $pMonth)
	 * @return  : boolean
	 * @brief:    기념일 여부
	 **/
function fn_get_Memday($year, $pMonth)
{
	/******************************************************
	*법정 기념일과 공휴일이 아닌 국경일
	*음력 기념일 등 
	*******************************************************/
	
	$aMoml[32];

/*	양력 기념일을 등록할 경우 사용 */
	switch($pMonth)
	{
	case 1:
		break;
	case 2:
		break;
	case 3:
		$aMoml[3] = " 납세자의날";
		break;
	case 4:
		$aMoml[5] = " 식목일";
		$aMoml[7] = " 보건의날";
		$aMoml[13] = " 임시정부수립";
		$aMoml[19] = " 4.19기념일";
		$aMoml[20] = " 장애인의날";
		$aMoml[21] = " 과학의날";
		$aMoml[22] = " 정보통신의날";
		$aMoml[25] = " 법의날";
		$aMoml[28] = " 충무공탄신일";
		break;
	case 5:
		$aMoml[1] = " 근로자의날";
		$aMoml[8] = " 어버이날";
		$aMoml[11] = " 입양의날";  //개별법
		$aMoml[15] = " 스승의날 가정의날"; //개별법:가정의날
		$aMoml[18] = " 5.18기념일";
		$aMoml[19] = " 발명의날";
		$aMoml[20] = " 세계인의날";	//개별법
		$aMoml[21] = " 부부의날";
		$aMoml[25] = " 방재의날";  //개별법";
		$aMoml[31] = " 바다의날";
		break;
	case 6:
		$aMoml[5] = " 환경의날";
		$aMoml[10] = " 6.10기념일";
		$aMoml[25] = " 6.25사변일";
		break;
	case 9:
		$aMoml[1] = " 통계의날";    //개별법
		$aMoml[4] = " 태권도의날";  //개별법
		$aMoml[7] = " 사회복지의날";    //개별법
		$aMoml[18] = " 철도의날";
		break;
	case 10:
		$aMoml[1] = " 국군의날";
		$aMoml[2] = " 노인의날";
		$aMoml[5] = " 세계한인의날";
		$aMoml[8] = " 재향군인의날";
		$aMoml[9] = " 한글날"; //국경일
		$aMoml[10] = " 임산부의날";  //개별법
		$aMoml[15] = " 체육의날";
		$aMoml[21] = " 경찰의날";
		$aMoml[24] = " 국제연합일";
		$aMoml[28] = " 교정의날";
		break;
	case 11:
		$aMoml[3] = " 학생독립운동기념일";
		$aMoml[9] = " 소방의날";  //개별법
		$aMoml[11] = " 농업인의날";
		$aMoml[17] = " 순국선열의날";
		$aMoml[30] = " 무역의날";
		break;
	case 12:
		$aMoml[3] = " 소비자의날";
		$aMoml[5] = " 자원봉사자의날";    //개별법
		break;
	}
/*	음력 기념일을 등록할 경우 사용
	$lunarMeml[1220] = "음력시험";	// 12월20일
	$lunarMeml[312] = "음력시험";	// 3월12일
	foreach($lunarMeml as $key => $val)
	{
		$m = (int)($key/100);
		if($pMonth < 3 && $m > 10)
			$y = $year - 1;
		else
			$y = $year;
		$d = $key%100;
		$sun = splanner_widget::fn_lunar2sun($y,$m,$d);
		$m = (int)($sun/100);
		if($m == $pMonth)
			$aMoml[$sun%100] .= " ".$val;
	}
*/
	return $aMoml;
}


//------------------------------------------------------------------------
	/**
	 * @function: Function fn_repeat_schedule(&$Calmain, $plan_period, $plan_value, &$aHoliday) 
	 * @return  : array
	 * @brief:    반복일정이 적용되는 양력일자 어레이 리턴
	 *            sdocument/sdocument.item.php와 같이 변경 필요
	 **/
Function fn_repeat_schedule(&$Calmain, $plan_period, $plan_value, &$aHoliday) {
	/******************************************************
	* 반복일정이 적용되는 일자에 "*" 삽입
	*******************************************************/

	$aSched[32];

	$weekcount = count($Calmain);
	if($plan_period == 9)	// 매월
	{
		$aSched[$plan_value] = '*';
		return $aSched;
	}
	else if($plan_period == 10)	// 매월말일
	{
		$weekcount--;
		for($wday=6;$wday>=0;$wday--)
		{
			if($Calmain[$weekcount][$wday])
			{
				$aSched[$Calmain[$weekcount][$wday]] = '*';
				break;
			}
		}
		return $aSched;
	}
	else if($plan_period == 11)	// 휴일제외 : 토, 일, 공휴일 제외
	{
		for($i=0;$i<$weekcount;$i++)
		{
			for($j=1;$j<6;$j++)	// 월 ~ 금
			{
				$tday = $Calmain[$i][$j];
				if($tday)
				{
					if($aHoliday[$tday] == null)
						$aSched[$tday] = '*';
				}
			}
		}
		return $aSched;
	}
	{
		$wday = $plan_value;
		if($Calmain[0][$wday]) $firstWeek = 0;
		else $firstWeek = 1;
		if($plan_period == 1) // 매주
		{
			for($j=0;$j<$weekcount;$j++)
			{
				if($Calmain[$j][$wday])
					$aSched[$Calmain[$j][$wday]] = '*';
			}
		} else if($plan_period == 2) // 매월1주
		{
			$aSched[$Calmain[$firstWeek][$wday]] = '*';
		} else if($plan_period == 3) // 매월2주
		{
			$aSched[$Calmain[$firstWeek+1][$wday]] = '*';
		} else if($plan_period == 4) // 매월3주
		{
			$aSched[$Calmain[$firstWeek+2][$wday]] = '*';
		} else if($plan_period == 5) // 매월4주
		{
			$aSched[$Calmain[$firstWeek+3][$wday]] = '*';
		} else if($plan_period == 6) // 매월1,3주
		{
			$aSched[$Calmain[$firstWeek][$wday]] = '*';
			$aSched[$Calmain[$firstWeek+2][$wday]] = '*';
		} else if($plan_period == 7) // 매월2,4주
		{
			$aSched[$Calmain[$firstWeek+1][$wday]] = '*';
			$aSched[$Calmain[$firstWeek+3][$wday]] = '*';
		} else if($plan_period == 8) // 매월마지막주
		{
			if($Calmain[$weekcount-1][$wday])
				$aSched[$Calmain[$weekcount-1][$wday]] = '*';
			else
				$aSched[$Calmain[$weekcount-2][$wday]] = '*';
		}
	}

	return $aSched;
}

//------------------------------------------------------------------------
	/**
	 * @function: Function fn_get_reg_days($year, $month, $text_days) 
	 * @return  : array
	 * @brief:    등록일이 적용되는 어레이 리턴
	 **/
Function fn_get_reg_days($year, $month, & $text_days) {

	$dd = explode(';',$text_days);

	for($i=0;$i<count($dd);$i++)
	{
		$d1 = explode(':',$dd[$i]);
		if(count($d1) != 2) continue;
		$d2 = explode('/',$d1[0]);
		if(count($d2) != 2) continue;
		if($d2[0] < 0)	//음력
		{
			$d2[0] = -$d2[0];
			if(($month < 3) && $d2[0] > 10)
				$year--;
			$ss = splanner_widget::fn_lunar2sun($year,$d2[0],$d2[1]);
			if((int)($ss/100) == $month)
			{
				$days[$ss%100] .= ' '.trim($d1[1]);
			}
		} else if($d2[0] == $month)
		{
			$days[$d2[1]] .= ' '.trim($d1[1]);
		}
	}
	return $days;
}

} // end of class

?>
