<?php
    /**
     * @class  sboard
     * @author zero (zero@nzeo.com)
     * @brief  sboard 모듈의 high class
     **/

    class sboard extends ModuleObject {

        var $search_option = array('title','content','title_content','comment','user_name','nick_name','user_id','tag'); ///< 검색 옵션

        var $order_target = array('list_order', 'update_order', 'regdate', 'voted_count', 'readed_count', 'comment_count', 'title', 'plan_sdate'); // 정렬 옵션

        var $skin = "default"; ///< 스킨 이름
        var $list_count = 50; ///< 한 페이지에 나타날 글의 수
        var $page_count = 10; ///< 페이지의 수
        var $category_list = NULL; ///< 카테고리 목록


        /**
         * @brief 설치시 추가 작업이 필요할시 구현
         **/
        function moduleInstall() {
            // action forward에 등록 (관리자 모드에서 사용하기 위함)
            $oModuleController = &getController('module');
            $oModuleModel = &getModel('module');

            // 2007. 10. 17 아이디 클릭시 나타나는 팝업메뉴에 작성글 보기 기능 추가
            $oModuleController->insertTrigger('member.getMemberMenu', 'sboard', 'controller', 'triggerMemberMenu', 'after');

            // 기본 게시판 생성
            $args->site_srl = 0;
            $output = executeQuery('module.getSite', $args);
            if(!$output->data->index_module_srl) {
                $args->mid = 'sboard';
                $args->module = 'sboard';
                $args->browser_title = 'XpressEngine';
                $args->skin = 'xe_default';
                $args->site_srl = 0;
                $output = $oModuleController->insertModule($args);
                $module_srl = $output->get('module_srl');
                $site_args->site_srl = 0;
                $site_args->index_module_srl = $module_srl;
                $oModuleController = &getController('module');
                $oModuleController->updateSite($site_args);
            }

            return new Object();
        }

		function checkDocQuery($xml)
		{
			$f_xml = "./modules/document/queries/".$xml;
			$lines = file($f_xml);
			$plan_sdate = 0;
			$plan_edate = 0;
			$plan_bgcolor = 0;
			$plan_check = 0;
			$plan_period = 0;
			$plan_value = 0;
			$plan_time = 0;
			foreach($lines as $str)
			{
				if(strstr($str,'plan_sdate')) $plan_sdate = 1;
				if(strstr($str,'plan_edate')) $plan_edate = 1;
				if(strstr($str,'plan_bgcolor')) $plan_bgcolor = 1;
				if(strstr($str,'plan_check')) $plan_check = 1;
				if(strstr($str,'plan_period')) $plan_period = 1;
				if(strstr($str,'plan_value')) $plan_value = 1;
				if(strstr($str,'plan_time')) $plan_time = 1;
			}
			if(!$plan_sdate) return true;
			if(!$plan_edate) return true;
			if(!$plan_bgcolor) return true;
			if(!$plan_check) return true;
			if(!$plan_period) return true;
			if(!$plan_value) return true;
			if(!$plan_time) return true;
			return false;
		}
		function updateDocQuery($xml)
		{
			$f_xml = "./modules/document/queries/".$xml;
			$lines = file($f_xml);
			$plan_sdate = 0;
			$plan_edate = 0;
			$plan_bgcolor = 0;
			$plan_check = 0;
			$plan_period = 0;
			$plan_value = 0;
			$plan_time = 0;
			$columns = 0;
			foreach($lines as $no => $str)
			{
				if(strstr($str,'plan_sdate')) $plan_sdate = 1;
				if(strstr($str,'plan_edate')) $plan_edate = 1;
				if(strstr($str,'plan_bgcolor')) $plan_bgcolor = 1;
				if(strstr($str,'plan_check')) $plan_check = 1;
				if(strstr($str,'plan_period')) $plan_period = 1;
				if(strstr($str,'plan_value')) $plan_value = 1;
				if(strstr($str,'plan_time')) $plan_time = 1;
				if(strstr($str,'</columns>')) $columns = $no;
			}
			if($plan_sdate && $plan_edate && $plan_bgcolor 
				&& $plan_check && $plan_period 
				&& $plan_value && $plan_time)
			{
				return;
			}
			rename($f_xml,$f_xml.'.org');
			$handle = fopen($f_xml,"w+");
			foreach($lines as $no => $str)
			{
				if($no == $columns)
				{
					$newline = sprintf("\n");
					if(!$plan_sdate)
					{
						fwrite($handle,' <column name="plan_sdate" var="plan_sdate" default="0" />'.$newline);
					}
					if(!$plan_edate) 
					{
						fwrite($handle,' <column name="plan_edate" var="plan_edate" default="0" />'.$newline);
					}
					if(!$plan_bgcolor) 
					{
						fwrite($handle,' <column name="plan_bgcolor" var="plan_bgcolor" />'.$newline);
					}
						
					if(!$plan_check) 
					{
						fwrite($handle,' <column name="plan_check" var="plan_check" />'.$newline);
					}
					if(!$plan_period) 
					{
						fwrite($handle,' <column name="plan_period" var="plan_period" />'.$newline);
					}
					if(!$plan_value) 
					{
						fwrite($handle,' <column name="plan_value" var="plan_value" />'.$newline);
					}
					if(!$plan_time) 
					{
						fwrite($handle,' <column name="plan_time" var="plan_time" />'.$newline);
					}
				}
				fwrite($handle,$str);
			}
			fclose($handle);
		}
        /**
         * @brief 설치가 이상이 없는지 체크하는 method
         **/
        function checkUpdate() {
            $oModuleModel = &getModel('module');

            // 2007. 10. 17 아이디 클릭시 나타나는 팝업메뉴에 작성글 보기 기능 추가
            if(!$oModuleModel->getTrigger('member.getMemberMenu', 'sboard', 'controller', 'triggerMemberMenu', 'after')) return true;
			// muhak start : 2010.5.5
			$oDB = &DB::getInstance();
            if(!$oDB->isColumnExists("documents","plan_sdate")) return true;
            if(!$oDB->isColumnExists("documents","plan_edate")) return true;
            if(!$oDB->isColumnExists("documents","plan_bgcolor")) return true;
            if(!$oDB->isColumnExists("documents","plan_check")) return true;
            if(!$oDB->isColumnExists("documents","plan_period")) return true;
            if(!$oDB->isColumnExists("documents","plan_value")) return true;
            if(!$oDB->isColumnExists("documents","plan_time")) return true;
			// muhak end
			if($this->checkDocQuery('insertDocument.xml')) return true;
			if($this->checkDocQuery('updateDocument.xml')) return true;
            return false;
        }

        /**
         * @brief 업데이트 실행
         **/
        function moduleUpdate() {
            $oModuleModel = &getModel('module');
            $oModuleController = &getController('module');

            // 2007. 10. 17 아이디 클릭시 나타나는 팝업메뉴에 작성글 보기 기능 추가
            if(!$oModuleModel->getTrigger('member.getMemberMenu', 'sboard', 'controller', 'triggerMemberMenu', 'after'))
                $oModuleController->insertTrigger('member.getMemberMenu', 'sboard', 'controller', 'triggerMemberMenu', 'after');

			// muhak start : 2010.5.5
			$oDB = &DB::getInstance();
            if(!$oDB->isColumnExists("documents","plan_sdate"))
				$oDB->addColumn('documents','plan_sdate','number', 10);
            if(!$oDB->isColumnExists("documents","plan_edate"))
				$oDB->addColumn('documents','plan_edate','number', 10, 0);
            if(!$oDB->isColumnExists("documents","plan_bgcolor"))
				$oDB->addColumn('documents','plan_bgcolor','char', 16);
            if(!$oDB->isColumnExists("documents","plan_check"))
				$oDB->addColumn('documents','plan_check','varchar', 24);
            if(!$oDB->isColumnExists("documents","plan_period"))
				$oDB->addColumn('documents','plan_period','char', 4);
            if(!$oDB->isColumnExists("documents","plan_value"))
				$oDB->addColumn('documents','plan_value','char', 4);
            if(!$oDB->isColumnExists("documents","plan_time"))
				$oDB->addColumn('documents','plan_time','char', 8);
			// muhak end
			$this->updateDocQuery('insertDocument.xml');
			$this->updateDocQuery('updateDocument.xml');
            return new Object(0, 'success_updated');
        }

		function moduleUninstall() {
			$output = executeQueryArray("sboard.getAllBoard");
			if(!$output->data) return new Object();
			set_time_limit(0);
			$oModuleController =& getController('module');
			foreach($output->data as $sboard)
			{
				$oModuleController->deleteModule($sboard->module_srl);
			}
			return new Object();
		}

        /**
         * @brief 캐시 파일 재생성
         **/
        function recompileCache() {
        }

    }
?>
