/**
 * blogshopWriter component
 * @author alivejune(dev@perbiz.co.kr)
 */
jQuery(function($){
var editor = xe.getApp('DrEditor')[0];
var blogshopWriter = xe.createPlugin('blogshopWriter', {
    configs : {},
    _eForm : null,
    blogshopSrls : 0,
    blogshopMemEmail : null,
    blogshopMemAuthcode : 0,
    authArea : null,
    opened : false,
    init : function() {
        this.configs = {},
        this._eForm = $('<table class="blogshopShowTable">')
            .append('<input type="hidden" name="blogshop_srl" value="0"  />')
            .append('<input type="hidden" name="blogshop_title" />')
            .append('<input type="hidden" name="blogshop_price" />')
            .append('<input type="hidden" name="blogshop_take_type" />')
            .append('<input type="hidden" name="blogshop_pay_type" />')
            .append('<input type="hidden" name="blogshop_pro_num" />')
            .append('<input type="hidden" name="blogshop_content" />')
            .append('<tr><td class="th">'+array_lang_blogshop["title"]+'</td><td><span class="eBlogshopPrice"></span></td></tr>')
            .append('<tr><td class="th">'+array_lang_blogshop["take_type"]+'</td><td><span class="eBlogshopTakeType"></span></td></tr>')
            .append('<tr><td class="th">'+array_lang_blogshop["pay_type"]+'</td><td><span class="eBlogshopPayType"></span></td></tr>')
            .append('<tr><td class="th">'+array_lang_blogshop["pro_num"]+'</td><td><span class="eBlogshopProNum"></span></td></tr>')
            .append('<tr><td class="th">'+array_lang_blogshop["content"]+'</td><td><span class="eBlogshopContent"></span></td></tr>')
          
        this.authArea = $('div.blogshopAuthArea');
        this.blogshopMemAuthcode = $('input[name=blogshop_mem_auth_code]');
        this.blogshopSrls = $('input[name=blogshop_srls]');
        
    },
    create : function(seq) {
        var self = this;
        var config  = editor.getConfig(seq);
        var _editor = config.writeArea.find('>div.blogshop_writer');
        var _blankBox = config.writeArea.find('>div.blank:first');
        var _editArea = config.editArea;

        // form data
        var _data = {
            title : _editor.find('input#blogshopTitle'),
            price : _editor.find('input#blogshopPrice'),
            takeType : _editor.find('.blogshopTakeType:input'),
            payType : _editor.find('.blogshopPayType:input'),
            proNum : _editor.find('input#blogshopProNum'),
            content : _editor.find('textarea#blogshopContent')
        };
        this.cast('ADD_DEFAULT_EDITOR_ACTION', [seq, _editor, 'blogshop_writer']);

        this.configs[seq] = {
            editor : _editor,
            blankBox : _blankBox,
            editArea : _editArea,
            blogshopMemAuthcode : self.blogshopMemAuthcode,
            authArea : self.authArea,
            blogshopSrl : 0,
            data   : _data
        };

        return this.configs[seq];
    },
    API_SETTING_CONTENT : function(sender, params) {
        var self = this;
        var seq = params[0];
        var obj = params[1];
        var aArea = self.authArea;
        this.blogshopMemEmail = aArea.find('input[name=blogshop_mem_email]'); //임시값
        
        if(xGetCookie('blogshop_auth_mem_email')) {
            this.blogshopMemEmail.val(xGetCookie('blogshop_auth_mem_email'));
        }
        
        aArea.find("#btn_blogshop_auth_mem_mail").click(
            function(e) {
            	var regx = /^[_0-9a-zA-Z-]+(\.[_0-9a-zA-Z-]+)*@[0-9a-zA-Z-]+(\.[0-9a-zA-Z-]+)*$/;
                if(!regx.test(self.blogshopMemEmail.val())) {
                    alert('이메일 주소가 잘못되었습니다.');
                    self.blogshopMemEmail.focus();
                    return; 
                }
    
                // 인증 프레임 생성
                aArea.find('.blogshopAuthFrame').attr('src', '?act=procBlogshopViewAuthFrame&blogshop_mem_email='+self.blogshopMemEmail.val());
                aArea.find('.blogshopAuthFrame').css('height','480px').css('width','100%').show();
                
            }        
        );

    },
    API_GETTING_CONTENT : function(sender, params) {
        return;
    },
    API_OPEN_BLOGSHOP_WRITER_EDITOR : function(sender, params) {
        var seq = params[0];
        var box = params[1];
        var bef = params[2];
        var cfg = this.configs[seq];
      
        if (!cfg) cfg = this.create(seq);
        cfg.blogshopSrl = 0;
        this.opened = true;
        this.cast('RESET_EDITOR', [seq, cfg.editor, 'BLOGSHOP_WRITER']);

        if(box) {
            // 에디터 수정시
            box.hide().after(cfg.editor);
            
            cfg.blogshopSrl = box.attr("id");
            cfg.data.title.val(box.find('input[name=blogshop_title]').val());
            cfg.data.price.val(box.find('input[name=blogshop_price]').val());
            cfg.data.takeType.eq(box.find('input[name=blogshop_take_type]').val()).attr('checked','checked');

            if(box.find('input[name=blogshop_pay_type]').val() == '0|@|1') {
                cfg.data.payType.each(function (e){ this.checked = true;});
            } else {
                cfg.data.payType.eq(box.find('input[name=blogshop_pay_type]').val()).attr('checked','checked');
            }
            
            cfg.data.proNum.val(box.find('input[name=blogshop_pro_num]').val());
            cfg.data.content.val(box.find('input[name=blogshop_content]').val());
            
        } else if (bef) {
            // before
            bef.after(cfg.editor);
        } else {
            cfg.editor.appendTo(editor.getConfig(seq).editArea);
        }

        cfg.editor.show();
        cfg.data.title.focus();
        this.cast('SCROLL_INTO_VIEW', [seq, cfg.editor]);
    },
    API_BEFORE_RESET_EDITOR : function(sender,params) {
        var seq  = params[0];
        var type = params[2];
        if(type != 'BLOGSHOP_WRITER') return;

        var cfg  = this.configs[seq];
        cfg.editor.find(".blogshopPayType:checked").attr('checked','');
        cfg.editor.find(".blogshopTakeType:checked").attr('checked','');
    },
    API_AFTER_OPEN_BLOGSHOP_WRITER_EDITOR : function(sender,params) {
        var seq  = params[0];
        var cfg  = this.configs[seq];
        this.controlAuthArea();
    },
    API_CLOSE_BLOGSHOP_WRITER_EDITOR : function(sender, params) {
        var self = this;
        var ret_flag = false; // return flag (with ajax)
        var seq  = params[0];
        var save = params[1];

        var cfg  = this.configs[seq];
        var box  = cfg.editor.prev('div._blogshop_writer:hidden');
        var blogshop_title = $.trim(cfg.data.title.val());
        var blogshop_price = $.trim(cfg.data.price.val());
        var blogshop_pro_num = $.trim(cfg.data.proNum.val());
        var blogshop_content = $.trim(cfg.data.content.val());
        var blogshop_take_type = cfg.data.takeType.filter(":checked").val();
        var blogshop_pay_type = this.getArrangedPayType(cfg.data.payType);
        
        if(save) {

            var params = {
                "blogshop_srl" : cfg.blogshopSrl,
                "blogshop_mem_auth_code" : self.blogshopMemAuthcode.val(),
                "blogshop_title" : blogshop_title,
                "blogshop_price" : blogshop_price,
                "blogshop_take_type" : blogshop_take_type,
                "blogshop_pay_type" : blogshop_pay_type,
                "blogshop_pro_num" : blogshop_pro_num,
                "blogshop_content" : blogshop_content
            };

            this.exec_json('blogshop.procBlogshopSaveInfo', params, function(ret_obj) {
                if(ret_obj.error != 0) {
                    alert(ret_obj.message);
                    ret_flag = false;
                    self.cast('SCROLL_INTO_VIEW', [seq, cfg.editor]);
                } else {
                    
                    // set blogshopSrl to edit form
                    var blogshop_srl = ret_obj.blogshop_srl;

                    // editable table setting     
                    self._eForm.find('.eBlogshopPrice').html(blogshop_price);
                    self._eForm.find('.eBlogshopTakeType').html(self.getProductInfo('take_type',blogshop_take_type));
                    self._eForm.find('.eBlogshopPayType').html(self.getProductInfo('pay_type',blogshop_pay_type));
                    self._eForm.find('.eBlogshopProNum').html(blogshop_pro_num);
                    self._eForm.find('.eBlogshopContent').html(blogshop_content);
                    
                    // editable table hidden value setting
                    self._eForm.find('input[name=blogshop_srl]').attr('value', blogshop_srl);
                    self._eForm.find('input[name=blogshop_title]').attr('value', blogshop_title);
                    self._eForm.find('input[name=blogshop_price]').attr('value', blogshop_price);
                    self._eForm.find('input[name=blogshop_pro_num]').attr('value', blogshop_pro_num);
                    self._eForm.find('input[name=blogshop_take_type]').attr('value', blogshop_take_type);
                    self._eForm.find('input[name=blogshop_pay_type]').attr('value', blogshop_pay_type);
                    self._eForm.find('input[name=blogshop_content]').attr('value', blogshop_content);
                    
                    var documentProxyUrl = current_url.setQuery('mid','')
                            .setQuery('act','procBlogshopGetDealingPost')
                            .setQuery('blogshop_srl', blogshop_srl);

                    // edit box
                    var newBox = $('<div class="blogshopShowArea" id="' + blogshop_srl + '">')
                        .append('<div><span class="title">■ ' + blogshop_title + '</span></div>')
                        .append(self._eForm.clone())
                        .append('<div class="payBtn"><a href="'+documentProxyUrl+'" target="_blank" id="' + blogshop_srl + '" class="blogshopPaymodule"><img src="/modules/blogshop/tpl/images/blogshop_pay_btn.png" alt="물품구매하기" /></a></div>')
                    
                    box.remove(); 
                    self.cast('SAVE_PARAGRAPH', [seq, cfg.editor, box=newBox, 'BLOGSHOP_WRITER']);
                    ret_flag = true;
                }
            }, false);

            if(!ret_flag) return false;
        } else {
            self.opened = false;
            box.show();
        } // end save condition

        // save blogshop_srls
        self.saveBlogshopSrls();

        cfg.editor.hide().appendTo(editor.getConfig(seq).writeArea);
        if(!box.length) box = cfg.editor.prev('div.eArea');
        self.cast('SELECT_PARAGRAPH', [seq, box, box, box]);
    },
    API_AFTER_DELETE_PARAGRAPH : function(sender, params) {
        var self   = this;
        var seq    = params[0];
        var target = params[1];
        
        // 단락 삭제 + 이지크로 거래중지요청
        if(target.hasClass("blogshopShowArea")) {
            var blogshop_srl = target.attr("id");
            if(blogshop_srl > 0) {
                self.exec_json('blogshop.procBlogshopDeleteInfo', {"blogshop_srl" : blogshop_srl}, function(ret_obj) {
                    if(ret_obj.error == -1) {
                        alert(ret_obj.message);
                    }
                },false);
                self.controlAuthArea();
            }
        }
    },
    API_AFTER_CLOSE_EDITOR : function(sender,params) {
        if(params[2] != 'BLOGSHOP_WRITER') return;

        var seq  = params[0];
        var cfg  = this.configs[seq];
        
        this.controlAuthArea();
        if (cfg.editArea.children('div.eArea').length || this.opened) {
            cfg.blankBox.hide();
        } else {
            cfg.blankBox.show();
        }
    },
    getProductInfo : function(type,value) {     
        switch (type) {
            case 'take_type' :
                if(value == '0') return '일반택배'; 
                if(value == '1') return '할인택배';
                if(value == '2') return '직거래';
                if(value == '3') return '택배,직거래';
            case 'pay_type' :
                if(value == '0') return '가상계좌';
                if(value == '1') return '신용카드';
                if(value == '0|@|1') return '가상계좌,신용카드';
        }
        return 'error';
    },
    getArrangedPayType : function(payType) {
        var tmp = [];
        payType.filter(":checked").each(function(e){ tmp.push(this.value); });
        return tmp.join('|@|');
    },
    controlAuthArea : function() {
        if(this.blogshopMemAuthcode.val() == 0 && this.opened) {
            this.authArea.show();
            this.authArea.find('input[type=text]:first').focus();
        } else {
            this.authArea.hide();
        }
    },
    saveBlogshopSrls : function() {
        var blogshop_srls = [];
        $("div > .blogshopShowArea").each(function() { blogshop_srls.push($(this).attr('id')); });
        $("#blogshop_srls:input").val(blogshop_srls);
    },
    // ....;
    exec_json : function(action,data,func,async){
        if(typeof(data) == 'undefined') data = {};
        if(typeof(async) == 'undefined') async = true;
        action = action.split(".");
        
        if(action.length == 2){

            if(show_waiting_message) {
                $("#waitingforserverresponse").html(waiting_message).css('top',$(document).scrollTop()+20).css('left',$(document).scrollLeft()+20).css('visibility','visible');
            }

            $.extend(data,{module:action[0],act:action[1]});
            if(typeof(xeVid)!='undefined') $.extend(data,{vid:xeVid});
            $.ajax({
                type:"POST"
                ,dataType:"json"
                ,url:request_uri
                ,contentType:"application/json"
                ,data:$.param(data)
                ,async:async
                ,success : function(data){
                    $("#waitingforserverresponse").css('visibility','hidden');
                    if(data.error > 0) alert(data.message);
                    if($.isFunction(func)) func(data);
                }
            });
        }
    }
});

editor.registerPlugin(new blogshopWriter);

});

function blogshpo_succed_auth(mem_email,mem_auth_code) {
    if(mem_email && mem_auth_code) {
        var blogshopAuthAfterArea = jQuery('<div>')
                .addClass('blogshopAuthAfterArea')
                .append('<p>ezPay 안전거래 판매자 인증이 정상적으로 완료되었습니다.</p>');
    
        jQuery('input[name=blogshop_mem_auth_code]').attr('value',mem_auth_code);
        jQuery('div > .blogshopAuthArea').hide().after(blogshopAuthAfterArea);
    
        // set cookie
        var expire = new Date();
        expire.setTime(expire.getTime()+ (7 * 24 * 60 * 60));
        xSetCookie('blogshop_auth_mem_email', mem_email, expire);
    }
}
