<?php
    /**
     * @class  blogshopItem
     * @author aliveJune(dev@perbiz.co.kr)
     * @brief  blogshopItem item 객체
     **/

    require_once './modules/document/document.item.php';
    
    class blogshopItem extends Object {
        var $document_srl = 0;

        function blogshopItem($document_srl = 0) {
            $this->document_srl = $document_srl;
        }

        function setAttribute($attribute) {
            if(!$attribute->document_srl) {
                $this->document_srl = 0;
                return;
            }
            $this->document_srl = $attribute->document_srl;
            $this->adds($attribute);
        }

        function isExists() {
            return $this->document_srl ? true : false;
        }
        
        function isGranted() {
            if($_SESSION['own_document'][$this->document_srl]) return true;

            if(!Context::get('is_logged')) return false;

            $logged_info = Context::get('logged_info');

            if($logged_info->is_admin == 'Y') return true;

            if($this->get('member_srl') && ($this->get('member_srl') == $logged_info->member_srl || $this->get('member_srl')*-1 == $logged_info->member_srl)) return true;

            return false;
        }   
             
        function isSecret() {
            return $this->get('is_secret') == 'Y' ? true : false;
        }
        
        function isAccessible() {
            return $_SESSION['accessible'][$this->document_srl]==true?true:false;
        }        
        
        function getPermanentUrl() {
            $url = getUrl('','document_srl',$this->get('document_srl'));
            if(substr($url,0,1)=='/') return substr(Context::getRequestUri(),0,-1).$url;
            return $url;
        }
        
        function getTitleLink() {
            $url = getUrl('','document_srl',$this->get('document_srl'));
            if(substr($url,0,1)=='/') return substr(Context::getRequestUri(),0,-1).$url;
            return $url;
        }
        
        function getCommentCount() {
            return $this->get('comment_count');
        }        
                
        function getTitleText($cut_size = 0, $tail='...') {
            if(!$this->document_srl) return;

            if($cut_size) $title = cut_str($this->get('title'), $cut_size, $tail);
            else $title = $this->get('title');

            return $title;
        }     
        
        function getTitle($cut_size = 0, $tail='...') {
            if(!$this->document_srl) return;

            $title = $this->getTitleText($cut_size, $tail);

            $attrs = array();
            $this->add('title_color', trim($this->get('title_color')));
            if($this->get('title_bold')=='Y') $attrs[] = "font-weight:bold;";
            if($this->get('title_color') && $this->get('title_color') != 'N') $attrs[] = "color:#".$this->get('title_color');

            if(count($attrs)) return sprintf("<span style=\"%s\">%s</span>", implode(';',$attrs), htmlspecialchars($title));
            else return htmlspecialchars($title);
        }        
        
        function getContentText($strlen = 0) {
            if(!$this->document_srl) return;

            if($this->isSecret() && !$this->isGranted() && !$this->isAccessible()) return Context::getLang('msg_is_secret');

            $_SESSION['accessible'][$this->document_srl] = true;

            $content = $this->get('content');

            if($strlen) return cut_str(strip_tags($content),$strlen,'...');

            return htmlspecialchars($content);
        }

        function getContent() {
            if(!$this->document_srl) return;

            if($this->isSecret() && !$this->isGranted() && !$this->isAccessible()) return Context::getLang('msg_is_secret');

            $_SESSION['accessible'][$this->document_srl] = true;
            $content = $this->get('content');
            
            // rewrite모듈을 사용하면 링크 재정의
            $oContext = &Context::getInstance();
            if($oContext->allow_rewrite) {
                $content = preg_replace('/<a([ \t]+)href=("|\')\.\/\?/i',"<a href=\\2". Context::getRequestUri() ."?", $content);
            }

            return $content;
        }
                
        function getSummary($str_size = 50, $tail = '...') {
            $content = $this->getContent(false,false);

            // 줄바꿈이 있을 때, 공백문자 삽입
            $content = preg_replace('!(<br[\s]*/{0,1}>[\s]*)+!is', ' ', $content);

            // </p>, </div>, </li> 등의 태그를 공백 문자로 치환
            $content = str_replace(array('</p>', '</div>', '</li>'), ' ', $content);

            // 태그 제거
            $content = preg_replace('!<([^>]*?)>!is','', $content);

            // < , > , " 를 치환
            $content = str_replace(array('&lt;','&gt;','&quot;','&nbsp;'), array('<','>','"',' '), $content);

            // 연속된 공백문자 삭제
            $content = preg_replace('/ ( +)/is', ' ', $content);

            // 문자열을 자름
            $content = trim(cut_str($content, $str_size, $tail));

            // >, <, "를 다시 복구
            $content = str_replace(array('<','>','"'),array('&lt;','&gt;','&quot;'), $content);

            // 영문이 연결될 경우 개행이 안 되는 문제를 해결
            $content = preg_replace('/([a-z0-9\+:\/\.\~,\|\!\@\#\$\%\^\&\*\(\)\_]){20}/is',"$0-",$content);

            return $content;
        }
        
        function getVotedCount() {
        	return $this->get('voted_count');
        }
        
        function getReadedCount() {
        	return $this->get('readed_count');
            
        }
        
        // 추천하기
        function getVotebox() {
            if(!$this->document_srl) return;
            if(Context::get('logged_info')) {
                return "<a href='#' onclick='doUpdateVote(".$this->document_srl.")'>want u!!</a>";
            } else {
                return "&nbsp;";
            }            
        }
        
        // 썸네일 존재 여부
        function thumbnailExists($width = 80, $height = 0, $type = '') {
            if(!$this->document_srl) return false;
            if(!$this->getThumbnail($width, $height, $type)) return false;
            return true;
        }        
        // 썸네일 이미지
        function getThumbnail($width = 80, $height = 0, $thumbnail_type = '') {
           if(!$this->document_srl) return null;
           if(!$this->get('uploaded_count') && !preg_match("!<img!is", $this->get('content'))) return null;
           $documentItem = new documentItem($this->document_srl, false);
           $thumnb_image = $documentItem->getThumbnail($width,$height,$thumbnail_type);
           if($thumnb_image) {
                return sprintf('<a href="%s"><img src="%s" width="%s" height="%s" class="thumb" /></a>',$this->getTitleLink(), $thumnb_image,$width,$height);
           } 
           return null;
        }
        
        function getNickName() {
            return htmlspecialchars($this->get('nick_name'));
        }
        
        function getRegdate($format = 'Y.m.d H:i:s') {
            return zdate($this->get('regdate'), $format);
        }
        
        function getTags() {
        	return $this->get('tags'); 
        }
    }
?>