<?php
    /**
     * @class  blogshopController
     * @author aliveJune (sjune@perbiz.co.kr)
     * @brief  blogshop 모듈의 controller class
     **/

    require_once(_XE_PATH_.'classes/httprequest/XEHttpRequest.class.php');
    require_once './modules/blogshop/blogshop.item.php';

    class blogshopController extends blogshop {

        /**
         * @brief 초기화
         **/
        function init() {
            ;
        }

        /**
         * @brief 상품데이터 저장 및 등록
         **/
        function procBlogshopSaveInfo() {

        	// blogshop 필수데이터 검증
            $args = Context::gets('blogshop_srl','blogshop_mem_auth_code','blogshop_title','blogshop_price','blogshop_take_type','blogshop_pay_type','blogshop_pro_num','blogshop_content');
            list($flag,$massage) = $this->checkValidBlogshopInfo($args);
            if($flag == -1) return new Object(-1,$massage);

            $cnt = 0;
            $oBlogshopModel = &getModel('blogshop');

            // 상품 데이터가 존재하는지 검증
            if($args->blogshop_srl > 0) {
                $output = $oBlogshopModel->getBlogshopByBlogshopSrl($args);
            }

            if($output->data->blogshop_srl) {

                // 이지크로 상품번호가 등록된 상품은 수정 불가
                $blogshopOldItem = $output->data;

                if($blogshopOldItem->blogshop_deal_number < 1) {
                    // 안전거래 미등록 제품 수정
                    $output = $oBlogshopModel->updateBlogshop($args);
                } else {
                    // 안전거래 원격수정을 위한 상품 파라미터 세팅
                    $blogshop_list = null;
                    $blogshop_list->blogshop_title = urlencode($args->blogshop_title);
                    $blogshop_list->blogshop_price = $args->blogshop_price;
                    $blogshop_list->blogshop_content = urlencode(cut_str($args->blogshop_content,80));
                    $blogshop_list->blogshop_take_type = $args->blogshop_take_type;
                    $blogshop_list->blogshop_pay_type = $args->blogshop_pay_type;
                    $blogshop_list->blogshop_pro_num  = $args->blogshop_pro_num;

                    $blogshop_list->blogshop_srl = $blogshopOldItem->blogshop_srl;
                    $blogshop_list->blogshop_document_srl = $blogshopOldItem->blogshop_document_srl;
                    $blogshop_list->blogshop_deal_number  = $blogshopOldItem->blogshop_deal_number;
                    $blogshop_mem_email = $blogshopOldItem->blogshop_mem_email;
                    $blogshop_mem_auth_code = $blogshopOldItem->blogshop_mem_auth_code;

                    $params = null;
                    $params = "?blogshop_mem_email=".$blogshop_mem_email;
                    $params .= "&blogshop_mem_auth_code=".$blogshop_mem_auth_code;
                    $params .= "&blogshop_list=".base64_encode(serialize($blogshop_list));
                    $params .= "&mod_type=update";

                    $router_page = $this->ezcro_router_home."router_textyle.php";

                    // 상품 수정
                    $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
                    for($i=0;$i<=10;$i++) {
                        $sock_return_data = $oXEHttpReq->Send($router_page.$params,"POST",60);
                        if($sock_return_data->error != -1) {
                            break;
                        }
                    } // end for

                    // 안전거래 서버에서 받은 결과 데이터 처리
                    if($sock_return_data->error == -1) {
                        return new Object(-1, 'msg_blogshop_sock_failed');
                    } else {
                        $return_ser = unserialize($sock_return_data->body);
                        if($return_ser[code] == "0000") {
                            $return_array = $return_ser[return_array];
                            if(count($return_array)) $output = $oBlogshopModel->updateBlogshop($args);
                        } else if($return_ser[code] == "1111") {
                            return new Object(-1, $return_ser[body]);
                        } else {
                            return new Object(-1, 'msg_blogshop_sock_failed');
                        } // end if return_ser process
                    }
                }
            } else {
                // db상에 존재하지 않는 데이터지만 단락에디터의 임시저장본에 정보가 남아있는 경우 삭제됐던 blogshop_srl 로 다시 insert 한다.
                $args->blogshop_srl = ($args->blogshop_srl < 1) ? getNextSequence() : $args->blogshop_srl;
            	$output = $oBlogshopModel->insertBlogshop($args);
            }

            if (!$output->toBool()) return $output;
            else $this->add('blogshop_srl', $output->get('blogshop_srl'));
        }


        /**
         * @brief 상품데이터 임시정보 삭제
         **/
        function procBlogshopDeleteInfo() {
            $blogshop_srl = Context::get('blogshop_srl');
            $oBlogshopModel = &getModel('blogshop');
            $params = null;
            $params->blogshop_srl = $blogshop_srl;

            // $args->blogshop_srl 이 없는 경우는 잘못된요청으로 인식하지 않고 스킵.
            if($params->blogshop_srl > 0){
                $output = $oBlogshopModel->getBlogshopByBlogshopSrl($params);
                $blogshopOldItem = $output->data;

                if($blogshopOldItem->blogshop_deal_number > 0 ) {
                    // 안전거래 등록 제품 원격 삭제 요청
                    $blogshop_list = null;
                    $blogshop_list->blogshop_srl = $blogshopOldItem->blogshop_srl;
                    $blogshop_list->blogshop_document_srl = $blogshopOldItem->blogshop_document_srl;
                    $blogshop_list->blogshop_deal_number  = $blogshopOldItem->blogshop_deal_number;
                    $blogshop_mem_email = $blogshopOldItem->blogshop_mem_email;
                    $blogshop_mem_auth_code = $blogshopOldItem->blogshop_mem_auth_code;

                    $params = null;
                    $params = "?blogshop_mem_email=".$blogshop_mem_email;
                    $params .= "&blogshop_mem_auth_code=".$blogshop_mem_auth_code;
                    $params .= "&blogshop_list=".base64_encode(serialize($blogshop_list));
                    $params .= "&mod_type=delete";
                    $router_page = $this->ezcro_router_home."router_textyle.php";

                    // 상품 수정
                    $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
                    for($i=0;$i<=10;$i++) {
                        $sock_return_data = $oXEHttpReq->Send($router_page.$params,"POST",60);
                        if($sock_return_data->error != -1) {
                            break;
                        }
                    } // end for

                    // 안전거래 서버에서 받은 결과 데이터 처리
                    if($sock_return_data->error == -1) {
                        return new Object(-1, 'msg_blogshop_sock_failed');
                    } else {
                        $return_ser = unserialize($sock_return_data->body);
                        if($return_ser[code] == "0000") {
                            $return_array = $return_ser[return_array];
                            if(count($return_array)) {
                                $args = null;
                                $args->blogshop_srl = $blogshop_srl;
                                $output = $oBlogshopModel->deleteBlogshop($args);
                                if (!$output->toBool()) return $output;
                            }
                        } else if($return_ser[code] == "1111") {
                            return new Object(-1, $return_ser[body]);
                        } else {
                            return new Object(-1, 'msg_blogshop_sock_failed');
                        } // end if return_ser process
                    }

                } else {
                    // 원격처리 없이 그냥 삭제
                    $args = null;
                    $args->blogshop_srl = $blogshop_srl;
                    $output = $oBlogshopModel->deleteBlogshop($args);
                    if (!$output->toBool()) return $output;
                }
            } else {
                return new Object();
            }
        }

        /**
         * @brief 인증프레임 노출
         **/
        function procBlogshopViewAuthFrame() {
            $blogshop_mem_email = Context::get('blogshop_mem_email');
            if(!$blogshop_mem_email) return new Object(-1, 'msg_invalid_request');

            $oBlogshopView = &getView('blogshop');
            $args = null;
            $args->blogshop_mem_email = $blogshop_mem_email;
            $oBlogshopView->showBlogshopAuthFrameBySock($args);
        }

        /**
         * @brief 블로그샵 신규가입 요청
         */
        function procBlogshopNewMemberReq() {
            $oBlogshopView = &getView('blogshop');
            $oBlogshopView->showBlogshopAuthFrameBySock();
        }

        /**
         * @brief 블로그샵 회원 가입 결과처리
         **/
        function procBlogshopRegResult() {
            $xe_mem_auth_code = Context::get('xe_mem_auth_code');
            $xe_mem_email = Context::get('xe_mem_email');
            if(!$xe_mem_auth_code || !$xe_mem_email) return new Object(-1, 'msg_invalid_request');

            $oBlogshopView = &getView('blogshop');
            $args = null;
            $args->xe_mem_auth_code = $xe_mem_auth_code;
            $args->xe_mem_email = $xe_mem_email;
            $oBlogshopView->dispBlogshopRegResult($args);
        }

        /**
         * @brief 블로그샵 이메일 체크
         */
        function procBlogshopEmailCheck() {
            $params = null;
            $mem_email = Context::get('mem_email');
            $sock_url = $this->ezcro_router_home."email_chk.php";
            $params .= "?mem_email=".$mem_email;

            // 안전거래 서버에 데이터 전송
            $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
            for($i=0;$i<=9;$i++) {
                $sock_result = $oXEHttpReq->Send($sock_url.$params,"GET",10);
                if($sock_result->error != -1) {
                    break;
                }
            }

            // 안전거래 서버에서 받은 결과 데이터 처리
            if($sock_result->error == -1) {
                return new Object(-1, 'msg_blogshop_auth_failed');
            } else {
                die($sock_result->body);
            }
        }

        /**
         * @brief 결제모듈이동
         */
        function procBlogshopGetPaymodule(){
            $blogshop_srl = Context::get('blogshop_srl');
            if($blogshop_srl < 1) return new Object(-1, 'msg_invalid_request');

            // blogshop_srl 으로 blogshop_deal_number 얻기
            $oBlogshopModel = &getModel('blogshop');
            $params = null;
            $params->blogshop_srl = $blogshop_srl;
            $output = $oBlogshopModel->getBlogshopByBlogshopSrl($params);

            if($output->data && $output->data->blogshop_deal_number) {
                header('Location: '.$this->ezcro_paymodule_url.'&pro_unique='.$output->data->blogshop_deal_number);
            } else {
                header('Content-Type: text/html; charset=utf-8');
                die("<script language='JavaScript'>alert('".Context::getLang('msg_blogshop_deal_number_failed')."');self.close();</script>");
            }
        }

        /**
         * @brief blogshop_srl로 해당 문서를 찾는다.
         */
        function procBlogshopGetDealingPost(){
            $blogshop_srl = Context::get('blogshop_srl');
            if($blogshop_srl < 1) return new Object(-1, 'msg_invalid_request');

            // blogshop_srl 으로 blogshop_deal_number 얻기
            $oBlogshopModel = &getModel('blogshop');
            $params = null;
            $params->blogshop_srl = $blogshop_srl;
            $output = $oBlogshopModel->getBlogshopValidDataByBlogshopDocumentSrl($params);
            if($output->data && $output->data->blogshop_document_srl) {
                $return_url = sprintf(getFullSiteUrl().'?document_srl=%s',$output->data->blogshop_document_srl);
                header('Location: '.$return_url);
            } else {
                header('Content-Type: text/html; charset=utf-8');
                die("<script language='JavaScript'>alert('".Context::getLang('msg_blogshop_deal_number_failed')."');self.close();</script>");
            }
        }

        /**
         * @brief document insert after trigger
         */
        function triggerInsertDocument(&$obj) {
            $this->triggerControl(&$obj);
        }

        /**
         * @brief document udpate after trigger
         */
        function triggerUpdateDocument(&$obj){
        	$this->triggerControl(&$obj);
        }

        /**
         * @brief 트리거 제어
         */
        function triggerControl(&$obj) {
            $act = ($obj->act) ? $obj->act : Context::get('act');

            switch ($act) {
                case 'procTextylePostsave' :
                    $this->blogshopSavePost(&$obj);
                break;
                case 'procTextylePostPublish':
                    $this->blopshopPostPublish(&$obj);
                break;
            }
        }
        /**
         * @brief 단락에디터 그냥 저장
         */
        function blogshopSavePost(&$obj){
        	$oBlogshopModel = &getModel('blogshop');

            // 판매자 인증메일,인증코드,document_srl 업데이트
            if($obj->blogshop_mem_auth_code && $obj->blogshop_mem_email && $obj->document_srl && $obj->blogshop_srls) {
                $obj->blogshop_document_srl = $obj->document_srl;
                $array_blogshop_srls =  explode(',',$obj->blogshop_srls);

                // 블로그샵 인증 정보 저장.
                if(count($array_blogshop_srls) > 0) {
                    $oDB = &DB::getInstance();
                    $oDB->begin();
                    foreach($array_blogshop_srls as $blogshop_srl) {
                        if($blogshop_srl < 1) break;
                        $obj->blogshop_srl = $blogshop_srl;
                        $output = $oBlogshopModel->updateBlogshopAuthInfo($obj);
                        if(!$output->toBool()){
                            $oDB->rollback();
                            return new Object(-1, 'msg_error_occured');
                        }
                    } // end foreach
                    $oDB->commit();
                }
            }
        }

        /**
         * @brief 단락에디터 발행
         */
        function blopshopPostPublish(&$obj) {
        	$oBlogshopModel = &getModel('blogshop');

            $args = null;
            $args->blogshop_document_srl = $obj->document_srl;
            $output = $oBlogshopModel->getBlogshopByBlogshopDocumentSrl($args);

            // 저장된 블로그샵 단락이 존재할경우 이지크로에 등록 요청
            if($output->data) {
                $db_info = Context::getDBInfo();

                $blogshop_list = $output->data;
                $blogshop_mem_email = $output->data[0]->blogshop_mem_email;
                $blogshop_mem_auth_code = $output->data[0]->blogshop_mem_auth_code;
                $blogshop_deal_number = $output->data[0]->blogshop_deal_number;

                // 상품거래 번호가 등록되지 않은 거래정보만 이지크로에 전달
                $setted_blogshop_list = null;
                foreach($blogshop_list as $num => $item) {
                    if(!$item->blogshop_deal_number) {
                        $item->blogshop_title = urlencode($item->blogshop_title);
                        $item->blogshop_content = urlencode(cut_str($item->blogshop_content,80));
                        $setted_blogshop_list[] = $item;
                    }
                } // end foreach
                if(!count($setted_blogshop_list)) return;

                // 원격 상품 등록
                $params = null;
                $params = "?blogshop_mem_email=".$blogshop_mem_email;
                $params .= "&blogshop_mem_auth_code=".$blogshop_mem_auth_code;
                $params .= "&blogshop_list=".base64_encode(serialize($setted_blogshop_list));
                $params .= "&default_url=".$db_info->default_url;
                $params .= "&site_url=".getSiteUrl();

                $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
                $router_page = $this->ezcro_router_home."router_textyle.php";
                for($i=0;$i<=10;$i++) {
                    $sock_return_data = $oXEHttpReq->Send($router_page.$params,"POST",60);
                    if($sock_return_data->error != -1) {
                        break;
                    }
                } // end for

                // 안전거래 서버에서 받은 결과 데이터 처리
                if($sock_return_data->error == -1) {
                    return new Object(-1, 'msg_blogshop_sock_failed');
                } else {
                    $return_ser = unserialize($sock_return_data->body);
                    if($return_ser[code] == "0000") {
                        // 데이터 연동 성공
                        $return_array = $return_ser[return_array];
                        if(count($return_array)) {
                            $oDB = &DB::getInstance();
                            $oDB->begin();

                            foreach($return_array['blogshop'] as $successed_item) {
                                $args = null;
                                $args->blogshop_srl = $successed_item[blogshop_srl];
                                $args->blogshop_document_srl = $successed_item[blogshop_document_srl];
                                $args->blogshop_deal_number = $successed_item[blogshop_deal_number];

                                $output = $oBlogshopModel->updateBlogshopDealNumber($args);
                                if(!$output->toBool()){
                                    $oDB->rollback();
                                    return new Object(-1, 'msg_error_occured');
                                }
                            } // end foreach
                        }
                        $oDB->commit();
                    } else if($return_ser[code] == "1111") {
                        // 데이터 연동 실패
                        return new Object(-1, $return_ser[body]);
                    } else {
                        // 소켓 연결 실패
                        return new Object(-1, 'msg_blogshop_sock_failed');
                    } // end if return_ser process
                }
            } // end if sock process
        }

        /**
         * @brief blogshop 문서 가져오기
         **/
        function procBlogshopGetDocumentsList($args) {
            $oBlogshopModel = &getModel('blogshop');
            $output = $oBlogshopModel->getBlogshopDocumentsList($args);
            $arranged_list = $this->arrangeBlogshopList($output);
            return $arranged_list;
        }

        /**
         * @brief 문서 blogshopItem으로 정리
         **/
        function arrangeBlogshopList($output) {
            $return_output = $output;
            $list = $output->data;
            if($output->data) {
                foreach($output->data as $key => $attribute) {
                    $document_srl = $attribute->document_srl;
                    if(!$GLOBALS['XE_BLOGSHOP_LIST'][$document_srl]) {
                        $oTextyleMetaCategoryItem = null;
                        $oTextyleMetaCategoryItem = new blogshopItem($document_srl);
                        $oTextyleMetaCategoryItem->setAttribute($attribute);
                        $GLOBALS['XE_BLOGSHOP_LIST'][$document_srl] = $oTextyleMetaCategoryItem;
                    }
                    $return_output->data[$key] = $GLOBALS['XE_BLOGSHOP_LIST'][$document_srl];
                } // end foreach
            }
            return $return_output;
        }
    }
?>