<?php
    /**
     * @class  blogshopView
     * @author aliveJune (sjune@perbiz.co.kr)
     * @brief  blogshop 모듈의 view 클래스
     **/

    require_once(_XE_PATH_.'classes/httprequest/XEHttpRequest.class.php');

    class blogshopView extends blogshop {

        /**
         * @brief 초기화
         **/
        function init() {
            $this->setTemplatePath($this->module_path.'tpl');
        }

        /**
         * display moduleHandler.proc 트리거
         **/
        function triggerModuleHandlerProc(&$obj) {
        	$act = $obj->act;

        	switch ($act) {
        		// 텍스타일 디스플레이
        		case 'dispTextyle' :
                    Context::addCSSFile($this->module_path."tpl/css/common.css");
                    Context::addJSFile($this->module_path."tpl/js/blogshop_view.js");
        			break;
        	   // 단락에디터 글쓰기
        		case 'dispTextyleToolPostManageWrite' :
        			// 배송방법 js 툴팁처리
                    $js_qtips = '';
                    for($i=0;$i<=3;$i++) {
                        $lang_desc = Context::getLang(sprintf('blogshop_take_type%s_desc',$i));
                        $js_qtips .= sprintf('jQuery("#blogshopTakeTypeDesc%s")',$i).'.qtip({content: "'.$lang_desc.'"});';
                    }
                    // 결제방법 js 툴팁처리
                    for($i=0;$i<=1;$i++) {
                        $lang_desc = Context::getLang(sprintf('blogshop_pay_type%s_desc',$i));
                        $js_qtips .= sprintf('jQuery("#blogshopPayTypeDesc%s")',$i).'.qtip({content: "'.$lang_desc.'"});';
                    }
                    // js,css import
                    Context::loadJavascriptPlugin('qtip');
                    Context::addJSFile($this->module_path."tpl/js/blogshop_write.js");
                    Context::addHtmlFooter('<script language="JavaScript">'.$js_qtips.'</script>');
                    break;
        	} // end switch
        }

        /**
         * @brief 블로그샵 인증 페이지 가져오기
         */
        function showBlogshopAuthFrameBySock($arg = null) {
            $db_info = Context::getDBInfo();

            //관리자 인증아이디 & 인증코드 얻어서 회원 연동 데이터를 소켓을 통해 가져옴
            $params = null;
            $sock_url = $this->ezcro_router_home."mem_index_textyle.php";
            $params =  "?default_url=".$db_info->default_url;
            $params .= "&site_url=".getSiteUrl();
            if($arg->blogshop_mem_email) $params .= "&site_mem_email=".$arg->blogshop_mem_email;

            // 안전거래 사이트에 데이터 전송
            $oXEHttpReq = new XEHttpRequest($this->ezcro_hostname,"80");
            for($i=0;$i<=5;$i++) {
                $sock_result = $oXEHttpReq->Send($sock_url.$params,"GET",10);
                if($sock_result->error != -1) {
                    break;
                }
            } // end for
            // 안전거래 사이트에서 받은 결과 데이터 처리
            if($sock_result->error == -1) {
                return new Object(-1, 'msg_blogshop_auth_failed');
            } else {
                $body = $this->unchunkHttpResponse($sock_result->body);
                if(!strlen($body)) $body = $sock_result->body;
                die($body);
            }
        }


        /**
         * @brief 블로그샵 회원 가입 결과처리
         */
        function dispBlogshopRegResult() {
            $xe_mem_auth_code = Context::get('xe_mem_auth_code');
            $xe_mem_email = Context::get('xe_mem_email');

            if(!$xe_mem_auth_code || !$xe_mem_email) return new Object(-1, 'msg_invalid_request');

            Context::set('xe_mem_email',$xe_mem_email);
            Context::set('xe_mem_auth_code',$xe_mem_auth_code);
            Context::set('msg_blogshop_auth_failed',$lang->msg_blogshop_auth_failed);

            header('Content-Type: text/html; charset=utf-8');
            $result_html = "<script type='text/javascript'> if(parent) { parent.blogshpo_succed_auth('".$xe_mem_email."','".$xe_mem_auth_code."');} else { alert('".Context::getLang('msg_blogshop_auth_failed')."');}</script>";
            die($result_html);
        }

    }
?>